/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.btree;

import org.neodatis.OrderByConstants;
import org.neodatis.btree.BTreeError;
import org.neodatis.btree.BTreeIteratorMultipleValuesPerKey;
import org.neodatis.btree.IBTree;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.session.SessionEngine;

public class LazyODBBTreeIteratorMultiple
extends BTreeIteratorMultipleValuesPerKey {
    private SessionEngine sessionEngine;
    private boolean returnObjects;
    protected InstanceBuilderContext ibc;

    public LazyODBBTreeIteratorMultiple(IBTree tree, OrderByConstants orderByType, SessionEngine storageEngine, boolean returnObjects) {
        super(tree, orderByType);
        this.sessionEngine = storageEngine;
        this.returnObjects = returnObjects;
        this.ibc = new InstanceBuilderContext();
    }

    public Object next() {
        ObjectOid oid = (ObjectOid)super.next();
        try {
            return this.loadObject(oid);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(BTreeError.LAZY_LOADING_NODE.addParameter(oid), (Throwable)e);
        }
    }

    private Object loadObject(ObjectOid oid) throws Exception {
        NonNativeObjectInfo nnoi = this.sessionEngine.getMetaObjectFromOid(oid, true, this.ibc);
        if (this.returnObjects) {
            Object o = nnoi.getObject();
            if (o != null) {
                return o;
            }
            return this.sessionEngine.layer2ToLayer1(nnoi, this.ibc);
        }
        return nnoi;
    }
}

