/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core;

import java.net.Socket;
import java.util.Map;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.Query;
import org.neodatis.odb.core.CoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.ClassIntrospector;
import org.neodatis.odb.core.layers.layer1.IntrospectorFactory;
import org.neodatis.odb.core.layers.layer1.ObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.ClassPool;
import org.neodatis.odb.core.layers.layer2.instance.ClassPoolImpl;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilder;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderImpl;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.odb.core.layers.layer4.BaseIdentification;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.query.IMatchingObjectAction;
import org.neodatis.odb.core.refactor.RefactorManager;
import org.neodatis.odb.core.refactor.RefactorManagerImpl;
import org.neodatis.odb.core.server.ClientSessionImpl;
import org.neodatis.odb.core.server.MessageStreamer;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.core.session.SessionImpl;
import org.neodatis.odb.core.trigger.TriggerManager;
import org.neodatis.odb.core.trigger.TriggerManagerImpl;
import org.neodatis.tool.wrappers.OdbSystem;
import org.neodatis.tool.wrappers.io.MessageStreamerBuilder;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class CoreProviderImpl
implements CoreProvider {
    private ClassPool classPool;
    private static Map<Session, TriggerManager> triggerManagers = new OdbHashMap<Session, TriggerManager>();
    private static OidGenerator oidGenerator;
    protected NeoDatisConfig neoDatisConfig;

    public CoreProviderImpl(NeoDatisConfig config) {
        this.neoDatisConfig = config;
        this.classPool = new ClassPoolImpl(this.neoDatisConfig);
    }

    private boolean osIsAndroid() {
        String javaVendor = OdbSystem.getProperty("java.vendor");
        return javaVendor != null && javaVendor.equals("The Android Project");
    }

    public void resetClassDefinitions() {
        this.classPool.reset();
    }

    public DataConverter getByteArrayConverter(boolean debug, String characterEncoding, NeoDatisConfig config) {
        return new DataConverterImpl(debug, characterEncoding, config);
    }

    public InstanceBuilder getLocalInstanceBuilder(Session session, ClassIntrospector classIntrospector, TriggerManager triggerManager) {
        return new InstanceBuilderImpl(session, classIntrospector, triggerManager);
    }

    public InstanceBuilder getServerInstanceBuilder(Session session, ClassIntrospector classIntrospector, TriggerManager triggerManager) {
        return new InstanceBuilderImpl(session, classIntrospector, triggerManager);
    }

    public ObjectIntrospector getLocalObjectIntrospector(Session session, ClassIntrospector classIntrospector, OidGenerator oidGenerator) {
        return IntrospectorFactory.getObjectIntrospector(session, classIntrospector, oidGenerator);
    }

    public TriggerManager getLocalTriggerManager(Session session) {
        TriggerManager triggerManager = triggerManagers.get(session);
        if (triggerManager != null) {
            return triggerManager;
        }
        triggerManager = new TriggerManagerImpl(session);
        triggerManagers.put(session, triggerManager);
        return triggerManager;
    }

    public void removeLocalTriggerManager(Session session) {
        triggerManagers.remove(session);
    }

    public ClassIntrospector getClassIntrospector(Session session, OidGenerator oidGenerator) {
        return IntrospectorFactory.getClassIntrospector(session, oidGenerator);
    }

    public RefactorManager getRefactorManager(SessionEngine engine) {
        return new RefactorManagerImpl(engine);
    }

    public IMatchingObjectAction getCollectionQueryResultAction(SessionEngine engine, Query query, boolean inMemory, boolean returnObjects) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public OidGenerator getOidGenerator() {
        try {
            Class clazz = this.neoDatisConfig.getOidGeneratorClass();
            return (OidGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e);
        }
    }

    public void setoidGenerator(OidGenerator newoidGenerator) {
        oidGenerator = newoidGenerator;
    }

    public Session getLocalSession(BaseIdentification baseIdentification) {
        SessionImpl session = new SessionImpl(baseIdentification);
        return session;
    }

    public Session getClientSession(BaseIdentification baseIdentification) {
        ClientSessionImpl session = new ClientSessionImpl(baseIdentification);
        return session;
    }

    public MessageStreamer getMessageStreamer(Socket socket) {
        return MessageStreamerBuilder.getMessageStreamer(socket, this.neoDatisConfig);
    }

    public MessageStreamer getMessageStreamer(String host, int port, String name) {
        return MessageStreamerBuilder.getMessageStreamer(host, port, name, this.neoDatisConfig);
    }

    public void init2() {
    }
}

