/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs;

import java.io.File;

public class NdfsConfig {
    protected static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    protected static final int DEFAULT_BLOCK_SIZE = 1024;
    protected static final String DEFAULT_TRANSACTION_DIRECTORY = ".transactions";
    private String baseDirectory;
    private String transactionDirectory;
    private int blockSize;
    protected long timeBetweenEachFlush;
    protected boolean debug;
    protected String characterEncoding;

    public NdfsConfig(String baseDirectory, int blockSize) {
        File f = new File(baseDirectory);
        this.baseDirectory = f.getAbsolutePath();
        if (!f.exists()) {
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            } else {
                f.mkdirs();
            }
        }
        this.blockSize = blockSize;
        this.timeBetweenEachFlush = 100L;
        this.debug = false;
        this.characterEncoding = DEFAULT_CHARACTER_ENCODING;
        this.transactionDirectory = DEFAULT_TRANSACTION_DIRECTORY;
    }

    public NdfsConfig(String baseDirectory) {
        this(baseDirectory, 1024);
    }

    public boolean debug() {
        return this.debug;
    }

    public NdfsConfig setDebug(boolean newDebug) {
        this.debug = newDebug;
        return this;
    }

    public long getTimeBetweenEachFlush() {
        return this.timeBetweenEachFlush;
    }

    public NdfsConfig setTimeBetweenEachFlush(long timeBetweenEachFlush) {
        return this;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public NdfsConfig setTransactionDirectory(String transactionDirectory) {
        this.transactionDirectory = transactionDirectory;
        return this;
    }

    public String getTransactionFileName(long transactionId) {
        return String.format("%d.transaction", transactionId);
    }

    public String getTransactionDirectory(boolean full) {
        if (full) {
            return new StringBuffer(this.baseDirectory).append("/").append(this.transactionDirectory).toString();
        }
        return this.transactionDirectory;
    }
}

