/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.neodatis;

import griffon.exceptions.GriffonException;
import griffon.plugins.neodatis.NeodatisProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.neodatis.odb.ODB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNeodatisProvider
implements NeodatisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNeodatisProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withOdb(Closure<R> closure) {
        return this.withOdb(DEFAULT, closure);
    }

    @Override
    public <R> R withOdb(String databaseName, Closure<R> closure) {
        Object result = null;
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (closure != null) {
            ODB db = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on database '" + databaseName + "'");
            }
            try {
                result = closure.call(new Object[]{databaseName, db});
                db.commit();
            }
            catch (Exception e) {
                db.rollback();
                throw new GriffonException((Throwable)e);
            }
        }
        return (R)result;
    }

    @Override
    public <R> R withOdb(CallableWithArgs<R> callable) {
        return this.withOdb(DEFAULT, callable);
    }

    @Override
    public <R> R withOdb(String databaseName, CallableWithArgs<R> callable) {
        Object result = null;
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (callable != null) {
            ODB db = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on database '" + databaseName + "'");
            }
            try {
                callable.setArgs(new Object[]{databaseName, db});
                result = callable.call();
                db.commit();
            }
            catch (Exception e) {
                db.rollback();
                throw new GriffonException((Throwable)e);
            }
        }
        return (R)result;
    }

    protected abstract ODB getDatabase(String var1);
}

