/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.xml;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.MetaModelImpl;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.layers.layer4.engine.Dummy;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.tool.ObjectTool;
import org.neodatis.tool.ConsoleLogger;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLImporter
implements ContentHandler {
    private static final String LOG_ID = "XMLImporter";
    private static final int STATE_UNKNOWN = 0;
    private static final int STATE_CLASS_INFO = 1;
    private static final int STATE_OBJECTS = 2;
    private static final int STATE_OBJECT = 3;
    private static final int STATE_ATTRIBUTE = 4;
    private static final int STATE_ATTRIBUTE_COLLECTION = 5;
    private static final int STATE_ATTRIBUTE_ARRAY = 6;
    private static final int STATE_ATTRIBUTE_MAP = 7;
    private static final int STATE_ODB = 8;
    private SessionEngine sessionEngine;
    private Map<ClassInfo, ObjectOid> maxObjectOids;
    private MetaModel metaModel;
    private ClassInfo ci;
    private IOdbList<ClassAttributeInfo> classAttributeInfo;
    private int state;
    private NonNativeObjectInfo nnoi;
    private List objectInfos;
    private ObjectOid objectId;
    private ClassOid objectClassId;
    private Collection<AbstractObjectInfo> attributeCollection;
    private Collection<NonNativeObjectInfo> attributeCollectionNonNativeObjects;
    private String realClassName;
    private Map attributeMap;
    private AbstractObjectInfo[] attributeArray;
    private int arrayIndex;
    private int currentLevel;
    private int fileFormatVersion;
    private int attributeId;
    private int nbObjects;
    private ILogger externalLogger;
    private Session session;
    private OidGenerator oidGenerator;
    private ObjectTool objectTool;

    public XMLImporter(SessionEngine storageEngine) {
        this.sessionEngine = storageEngine;
    }

    public XMLImporter(ODB odb) {
        this.sessionEngine = Dummy.getEngine(odb);
    }

    public void importFile(String directory, String filename) throws Exception {
        String fullFileName = directory + "/" + filename;
        this.maxObjectOids = new HashMap<ClassInfo, ObjectOid>();
        this.info("Importing file " + new File(fullFileName).getAbsolutePath());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.parse(fullFileName);
        this.sessionEngine.commit();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
        ++this.currentLevel;
        try {
            if (tagName.equals("odb")) {
                this.state = 8;
                String version = attributes.getValue("file-format-version");
                this.fileFormatVersion = Integer.parseInt(version);
                return;
            }
            if (tagName.equals("meta-model")) {
                this.metaModel = new MetaModelImpl(NeoDatis.getConfig());
                this.info("Importing Meta Model");
                return;
            }
            if (tagName.equals("class")) {
                this.nbObjects = 0;
                this.state = 1;
                String classId = attributes.getValue("id");
                String name = attributes.getValue("name");
                String maxObjectOid = attributes.getValue("max-object-oid");
                this.ci = new ClassInfo(name, "");
                this.ci.setOid(this.oidGenerator.classOidFromString(classId));
                this.classAttributeInfo = new OdbArrayList<ClassAttributeInfo>();
                this.info(". Importing class " + this.ci.getFullClassName() + " - coid=" + this.ci.getOid());
                return;
            }
            if (tagName.equals("attribute") && this.state == 1) {
                String id = attributes.getValue("id");
                String name = attributes.getValue("name");
                String sClassOid = attributes.getValue("class-id");
                String type = attributes.getValue("type");
                String isEnum = attributes.getValue("is-enum");
                ClassOid coid = null;
                if (sClassOid != null) {
                    coid = this.oidGenerator.classOidFromString(sClassOid);
                    type = "not yet defined";
                }
                ClassAttributeInfo cai = new ClassAttributeInfo(Integer.parseInt(id), name, type, coid, null);
                if (isEnum != null && isEnum.equals("true")) {
                    cai = new ClassAttributeInfo(Integer.parseInt(id), name, ODBType.ENUM.getName(), null, null);
                    ODBType odbType = cai.getAttributeType().copy();
                    odbType.setName(type);
                    cai.setAttributeType(odbType);
                    cai.setClassName(type);
                }
                if (cai.getAttributeType().isArray()) {
                    String arrayOfWhat = attributes.getValue("array-of");
                    cai.getAttributeType().setSubType(ODBType.getFromName(arrayOfWhat));
                    cai.setAttributeType(cai.getAttributeType().copy());
                }
                this.classAttributeInfo.add(cai);
                return;
            }
            if (tagName.equals("objects")) {
                this.state = 2;
                this.objectInfos = new ArrayList();
                this.info("Start importing objects");
                return;
            }
            if (tagName.equals("object") && this.state == 2) {
                this.state = 3;
                String sObjectId = attributes.getValue("oid");
                this.objectId = this.oidGenerator.objectOidFromString(sObjectId);
                String sObjectClassId = attributes.getValue("class-id");
                this.objectClassId = this.oidGenerator.classOidFromString(sObjectClassId);
                this.nnoi = new NonNativeObjectInfo(this.metaModel.getClassInfoFromId(this.objectClassId));
                this.nnoi.setOid(this.objectId);
                ++this.nbObjects;
                if (this.nbObjects % 1000 == 0) {
                    this.info(". " + this.nbObjects + " objects");
                }
                return;
            }
            if (tagName.equals("attribute") && this.state == 3) {
                ClassInfo ci;
                ClassAttributeInfo cai;
                ODBType type;
                this.state = 4;
                String id = attributes.getValue("id");
                this.attributeId = Integer.parseInt(id);
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                String encoding = this.sessionEngine.getSession().getConfig().getDatabaseCharacterEncoding();
                if (value != null) {
                    value = encoding == null ? URLDecoder.decode(value) : URLDecoder.decode(value, encoding);
                }
                String objectRefId = attributes.getValue("ref-oid");
                String sIsNull = attributes.getValue("is-null");
                boolean isNull = false;
                if (sIsNull != null) {
                    isNull = true;
                }
                if (((type = (cai = (ci = this.metaModel.getClassInfoFromId(this.objectClassId)).getAttributeInfoFromId(this.attributeId)).getAttributeType()).isArrayOrCollection() || type.isMap()) && !isNull) {
                    this.nnoi.setAttributeValue(this.attributeId, new NullNativeObjectInfo(type.getId()));
                    if (type.isCollection()) {
                        this.state = 5;
                    }
                    if (type.isArray()) {
                        this.state = 6;
                    }
                    if (type.isMap()) {
                        this.state = 7;
                    }
                } else {
                    AbstractObjectInfo aoi = null;
                    if (objectRefId != null) {
                        aoi = new ObjectReference(this.oidGenerator.objectOidFromString(objectRefId));
                        this.nnoi.setAttributeValue(this.attributeId, aoi);
                    } else if (isNull) {
                        if (type.isNonNative()) {
                            this.nnoi.setAttributeValue(this.attributeId, new NonNativeNullObjectInfo());
                        } else {
                            this.nnoi.setAttributeValue(this.attributeId, new NullNativeObjectInfo(type.getId()));
                        }
                    } else {
                        ClassInfo attributeCi = null;
                        if (type.isEnum()) {
                            attributeCi = this.metaModel.getClassInfo(cai.getClassName(), true);
                        }
                        aoi = this.objectTool.stringToObjectInfo(type.getId(), value, ObjectTool.ID_CALLER_IS_XML, attributeCi);
                        this.nnoi.setAttributeValue(this.attributeId, aoi);
                    }
                }
                return;
            }
            if (tagName.equals("collection") && this.state == 5) {
                int size = Integer.parseInt(attributes.getValue("size"));
                this.attributeCollection = new ArrayList<AbstractObjectInfo>(size);
                this.attributeCollectionNonNativeObjects = new ArrayList<NonNativeObjectInfo>(size);
                this.realClassName = attributes.getValue("native-class-name");
                return;
            }
            if (tagName.equals("array") && this.state == 6) {
                int size = Integer.parseInt(attributes.getValue("size"));
                this.attributeArray = new AbstractObjectInfo[size];
                this.arrayIndex = 0;
                this.realClassName = attributes.getValue("array-of");
                return;
            }
            if (tagName.equals("map") && this.state == 7) {
                int size = Integer.parseInt(attributes.getValue("size"));
                this.attributeMap = new OdbHashMap(size);
                this.realClassName = attributes.getValue("native-class-name");
                return;
            }
            if (tagName.equals("element") && this.state == 5) {
                String objectRefId = attributes.getValue("ref-oid");
                if (objectRefId != null) {
                    ObjectReference or = new ObjectReference(this.oidGenerator.objectOidFromString(objectRefId));
                    this.attributeCollection.add(or);
                    this.attributeCollectionNonNativeObjects.add(or);
                } else {
                    String value = attributes.getValue("value");
                    ODBType type = ODBType.getFromName(attributes.getValue("type"));
                    this.attributeCollection.add(this.objectTool.stringToObjectInfo(type.getId(), value, ObjectTool.ID_CALLER_IS_XML, null));
                }
                return;
            }
            if (tagName.equals("element") && this.state == 6) {
                String objectRefId = attributes.getValue("ref-oid");
                if (objectRefId != null) {
                    this.attributeArray[this.arrayIndex++] = new ObjectReference(this.oidGenerator.objectOidFromString(objectRefId));
                } else {
                    String value = attributes.getValue("value");
                    ODBType type = ODBType.getFromName(this.realClassName);
                    this.attributeArray[this.arrayIndex++] = this.objectTool.stringToObjectInfo(type.getId(), value, ObjectTool.ID_CALLER_IS_XML, null);
                }
                return;
            }
            if (tagName.equals("element") && this.state == 7) {
                ODBType type;
                String v;
                String keyRefId = attributes.getValue("key-id");
                String objectRefId = attributes.getValue("ref-oid");
                String valueIsNull = attributes.getValue("value-is-null");
                AbstractObjectInfo key = null;
                AbstractObjectInfo value = null;
                if (keyRefId != null) {
                    key = new ObjectReference(this.oidGenerator.objectOidFromString(keyRefId));
                } else {
                    v = attributes.getValue("key");
                    type = ODBType.getFromName(attributes.getValue("key-type"));
                    key = this.objectTool.stringToObjectInfo(type.getId(), v, ObjectTool.ID_CALLER_IS_XML, null);
                }
                if (valueIsNull != null) {
                    value = valueIsNull.equals("native") ? new NullNativeObjectInfo() : new NonNativeNullObjectInfo();
                } else if (objectRefId != null) {
                    value = new ObjectReference(this.oidGenerator.objectOidFromString(objectRefId));
                } else {
                    v = attributes.getValue("value");
                    type = ODBType.getFromName(attributes.getValue("value-type"));
                    value = this.objectTool.stringToObjectInfo(type.getId(), v, ObjectTool.ID_CALLER_IS_XML, null);
                }
                this.attributeMap.put(key, value);
                return;
            }
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.IMPORT_ERROR.addParameter(this.sessionEngine.getSession().getBaseIdentification().getFullIdentification()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String uri, String localName, String tagName) throws SAXException {
        try {
            if (tagName.equals("class")) {
                this.ci.setAttributes(this.classAttributeInfo);
                this.metaModel.addClass(this.ci, false);
                this.state = 0;
                if (this.sessionEngine.getSession().getConfig().isDebugEnabled(LOG_ID)) {
                    DLogger.debug("Class " + this.ci.getFullClassName() + " created");
                }
                return;
            }
            if (tagName.equals("meta-model")) {
                this.state = 0;
                this.info("Persisting Meta Model");
                for (ClassInfo ci : this.metaModel.getUserClasses()) {
                    for (ClassAttributeInfo cai : ci.getAllNonNativeAttributes()) {
                        cai.setClassName(this.metaModel.getClassInfoFromId(cai.getAttributeClassOid()).getFullClassName());
                    }
                }
                this.sessionEngine.getSession().setMetaModel(this.metaModel);
                for (ClassInfo ci : this.maxObjectOids.keySet()) {
                    ObjectOid oid = this.maxObjectOids.get(ci);
                    this.info(". Class " + ci.getFullClassName() + " -  max object id = " + oid);
                }
                this.info("Meta Model persisted. " + this.metaModel.getNumberOfClasses() + " classes");
                return;
            }
            if (tagName.equals("object") && this.state == 3) {
                try {
                    this.sessionEngine.storeMeta(this.nnoi.getOid(), this.nnoi);
                    if (this.sessionEngine.getSession().getConfig().isDebugEnabled(LOG_ID)) {
                        this.info("Object of type " + this.nnoi.getClassInfo().getFullClassName() + " with oid " + this.nnoi.getOid() + " created");
                    }
                }
                catch (Exception e) {
                    throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in XmlImporter.endElement.writeObjectInfo"), (Throwable)e);
                }
                this.state = 2;
                return;
            }
            if (tagName.equals("attribute") && this.state == 4) {
                this.state = 3;
                return;
            }
            if (tagName.equals("collection") && this.state == 5) {
                CollectionObjectInfo coi = new CollectionObjectInfo(this.attributeCollection, this.attributeCollectionNonNativeObjects);
                coi.setRealCollectionClassName(this.realClassName);
                this.nnoi.setAttributeValue(this.attributeId, coi);
                this.state = 4;
                this.attributeCollection = null;
                this.attributeId = -1;
                return;
            }
            if (tagName.equals("array") && this.state == 6) {
                ArrayObjectInfo aoi = new ArrayObjectInfo(this.attributeArray);
                aoi.setRealArrayComponentClassName(this.realClassName);
                aoi.setOdbType(aoi.getOdbType().copy());
                aoi.getOdbType().setSubType(ODBType.getFromName(this.realClassName));
                this.nnoi.setAttributeValue(this.attributeId, aoi);
                this.state = 4;
                this.attributeArray = null;
                this.attributeId = -1;
                return;
            }
            if (tagName.equals("map") && this.state == 7) {
                MapObjectInfo moi = new MapObjectInfo(this.attributeMap, this.realClassName);
                this.nnoi.setAttributeValue(this.attributeId, moi);
                this.state = 4;
                this.attributeMap = null;
                this.attributeId = -1;
                return;
            }
            if (tagName.equals("objects")) {
                this.info("End importing " + this.nbObjects + " objects");
                return;
            }
        }
        finally {
            --this.currentLevel;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setExternalLogger(ILogger logger) {
        this.externalLogger = logger;
    }

    public void logToConsole() {
        this.externalLogger = new ConsoleLogger();
    }

    protected void info(Object o) {
        if (this.externalLogger != null) {
            this.externalLogger.info(o);
        }
    }
}

