/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.plugin.nativ;

import java.io.IOException;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.layers.layer4.StorageEngineAdapter;
import org.neodatis.odb.plugin.idf.jdbm.JdbmClassOidIterator;
import org.neodatis.odb.plugin.idf.jdbm.JdbmObjectOidIterator;
import org.neodatis.odb.plugin.nativ.JDBMBTree;
import org.neodatis.tool.DLogger;

public class NeoDatisJdbmPlugin
extends StorageEngineAdapter {
    protected JDBMBTree pHashMap;
    protected NeoDatisConfig neoDatisConfig;
    protected boolean debug;
    public static int nbPut = 0;
    public static int nbRead = 0;
    public static int nbExist = 0;

    public OidAndBytes read(OID oid, boolean useCache) {
        ++nbRead;
        try {
            Bytes data = (Bytes)this.pHashMap.get(oid);
            if (data == null) {
                if (this.debug) {
                    DLogger.info("Reading OID " + oid.oidToString() + " = null");
                }
                return null;
            }
            OidAndBytes oab = new OidAndBytes(oid, data);
            if (this.debug) {
                DLogger.info("Reading OID " + oid.oidToString() + " | bytes = " + oab.bytes);
            }
            return oab;
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "Error while reading data for oid " + oid.oidToString());
        }
    }

    public void write(OidAndBytes oidAndBytes) {
        ++nbPut;
        try {
            if (this.debug) {
                DLogger.info("writing " + oidAndBytes.bytes.getByteArray().length);
            }
            this.pHashMap.put(oidAndBytes.oid, oidAndBytes.bytes);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "Error while writing data for oid " + oidAndBytes.oid.oidToString());
        }
    }

    public void close() {
        try {
            this.pHashMap.close();
        }
        catch (IOException e) {
            throw new NeoDatisRuntimeException(e, "Error while closing persistent Map");
        }
    }

    public void commit() {
        try {
            this.pHashMap.commit();
        }
        catch (IOException e) {
            throw new NeoDatisRuntimeException(e, "Error while create executing commit");
        }
    }

    public void deleteObjectWithOid(OID oid) {
        try {
            this.pHashMap.remove(oid);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "Error while delete data for oid " + oid.oidToString());
        }
    }

    public boolean existOid(OID oid) {
        ++nbExist;
        try {
            return this.pHashMap.containsKey(oid);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "Error while checking if key exist" + oid.oidToString());
        }
    }

    public String getEngineDirectoryForBaseName(String theBaseName) {
        if (this.neoDatisConfig.getBaseDirectory() != null) {
            return this.neoDatisConfig.getBaseDirectory() + "/";
        }
        return "";
    }

    public String getStorageEngineName() {
        return "jdbm";
    }

    public void open(String baseName, NeoDatisConfig config) {
        try {
            this.neoDatisConfig = config;
            this.debug = config.debugStorageEngine();
            String fullName = this.getEngineDirectoryForBaseName(baseName) + baseName;
            this.pHashMap = new JDBMBTree(fullName, config.isTransactional(), config.useStorageEngineCache());
        }
        catch (IOException e) {
            throw new NeoDatisRuntimeException(e, "Error while create persistent hashmap");
        }
    }

    public void open(String host, int port, String baseName, NeoDatisConfig config) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    public void rollback() {
        try {
            this.pHashMap.rollback();
        }
        catch (IOException e) {
            throw new NeoDatisRuntimeException(e, "Error while create executing rollback");
        }
    }

    public boolean useDirectory() {
        return false;
    }

    public static String stats() {
        return "NbPut=" + nbPut + " / nbRead=" + nbRead + " / nbExist=" + nbExist;
    }

    public ClassOidIterator getClassOidIterator() {
        return new JdbmClassOidIterator(this.pHashMap.getClassOidBTree(), this.getOidGenerator());
    }

    public ObjectOidIterator getObjectOidIterator(ClassOid classOid, ObjectOidIterator.Way way) {
        return new JdbmObjectOidIterator(this.pHashMap.getBtreeForName(classOid.oidToString()), way, this.getOidGenerator());
    }
}

