/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.plugin.idf.jdbm;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryParser.ParseException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.layers.layer4.plugin.jdbm.JdbmClassOidIterator;
import org.neodatis.odb.core.layers.layer4.plugin.jdbm.JdbmObjectOidIterator;
import org.neodatis.odb.core.oid.uuid.UniqueOidGeneratorImpl;
import org.neodatis.odb.plugin.idf.Indexer;
import org.neodatis.odb.plugin.idf.ObjectLocation;
import org.neodatis.odb.plugin.idf.jdbm.JDBMBtreeForIndexer;
import org.neodatis.odb.plugin.nativ.JDBMBTree;
import org.neodatis.tool.DLogger;

public class JDBMIndexer
implements Indexer {
    protected JDBMBTree btree;
    protected String fileName;
    protected String id;
    protected boolean isObjectIndeer;
    protected boolean debug;

    public void close() throws IOException {
        if (this.btree != null) {
            this.btree.close();
            this.btree = null;
        }
    }

    public ObjectLocation get(OID oid) throws ParseException, IOException {
        ObjectLocation ol = (ObjectLocation)this.btree.get(oid);
        if (this.debug) {
            DLogger.info("\tIndexer " + this.id + ":Read oid " + oid.oidToString() + " => Object Location is " + ol);
        }
        return ol;
    }

    public void put(OID oid, ObjectLocation objectLocation) throws CorruptIndexException, IOException {
        if (this.debug) {
            DLogger.info("\tIndexer " + this.id + ":Write oid " + oid.oidToString() + " => Object Location is " + objectLocation);
        }
        this.btree.put(oid, objectLocation);
    }

    public void init(String id, String fileName) throws IOException {
        this.id = id;
        this.fileName = fileName;
        this.btree = new JDBMBtreeForIndexer(fileName, true, true);
    }

    public void commit() {
    }

    public void rollback() {
    }

    public ObjectLocation delete(OID oid) {
        ObjectLocation ol = (ObjectLocation)this.btree.remove(oid);
        return ol;
    }

    public boolean existKey(OID oid) {
        return this.btree.containsKey(oid);
    }

    public ClassOidIterator getClassOidIterator() {
        return new JdbmClassOidIterator(this.btree.getBtreeForName(this.id), new UniqueOidGeneratorImpl());
    }

    public ObjectOidIterator getObjectOidIterator() {
        return new JdbmObjectOidIterator(this.btree.getBtreeForName(this.id), ObjectOidIterator.Way.INCREASING, new UniqueOidGeneratorImpl());
    }

    public void setDebug(boolean yes) {
        this.debug = yes;
    }
}

