/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.plugin.idf;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.plugin.idf.DataFile;
import org.neodatis.odb.plugin.idf.Indexer;
import org.neodatis.odb.plugin.idf.ObjectLocation;
import org.neodatis.odb.plugin.idf.jdbm.JDBMIndexer;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;

public class IOManager {
    protected String key;
    protected Indexer indexer;
    protected DataFile dataFile;
    protected boolean debug;
    protected NeoDatisConfig config;

    public IOManager(String key, NeoDatisConfig config) {
        this.key = key;
        this.config = config;
        this.debug = config.debugLayers();
        this.init();
    }

    private void init() {
        String baseDirectory = this.config.getBaseDirectory() + "/" + this.config.getBaseName() + "/" + this.key;
        String indexerFileName = baseDirectory + "/index.neodatis";
        String dataFileName = baseDirectory + "/data.neodatis";
        String deletedFileName = baseDirectory + "/deleted.neodatis";
        new File(baseDirectory).mkdirs();
        this.indexer = this.createIndexer();
        this.dataFile = new DataFile(this.key, dataFileName, 4, 4096, this.debug);
        if (this.debug) {
            DLogger.info("Creating IOManager for " + this.key + " in directory : " + baseDirectory);
            DLogger.info("\tIndexer : " + indexerFileName);
            DLogger.info("\tDatafile : " + dataFileName);
            DLogger.info("\tDeleted blocks : " + deletedFileName);
        }
        try {
            this.indexer.init(this.key, indexerFileName);
            this.indexer.setDebug(this.debug);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e);
        }
    }

    private Indexer createIndexer() {
        return new JDBMIndexer();
    }

    public String getKey() {
        return this.key;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public void close() throws IOException {
        this.indexer.close();
        this.dataFile.close();
    }

    public void commit() {
        this.indexer.commit();
        this.dataFile.commit();
    }

    public void delete(OID oid) {
        ObjectLocation ol = this.indexer.delete(oid);
        this.storeDeletedBlock(ol);
    }

    private void storeDeletedBlock(ObjectLocation ol) {
    }

    public void rollback() {
        this.indexer.rollback();
        this.dataFile.rollback();
    }

    public void write(OidAndBytes oidAndBytes) throws CorruptIndexException, IOException {
        long position = this.dataFile.write(oidAndBytes.bytes);
        if (this.debug) {
            DLogger.info("writing " + oidAndBytes.bytes.getByteArray().length + " bytes  at " + position + " : " + DisplayUtility.byteArrayToString(oidAndBytes.bytes.getByteArray()));
        }
        ObjectLocation ol = new ObjectLocation(1, position, oidAndBytes.bytes.getRealSize());
        OID oid = oidAndBytes.oid;
        this.indexer.put(oid, ol);
    }

    public OidAndBytes read(OID oid, boolean useCache) {
        try {
            ObjectLocation ol = this.indexer.get(oid);
            if (this.debug) {
                DLogger.info("reading data of oid " + oid + " at " + ol.getPosition() + " , size=" + ol.getSize());
            }
            Bytes bytes = this.dataFile.read(ol.getPosition(), ol.getSize());
            if (this.debug) {
                DLogger.info("\tbytes read for oid " + oid.oidToString() + " : " + DisplayUtility.byteArrayToString(bytes.getByteArray()));
            }
            return new OidAndBytes(oid, bytes);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e);
        }
    }
}

