/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.plugin.idf;

import java.io.IOException;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.buffer.MultiBufferedFileIO;

public class DataFile {
    protected MultiBufferedFileIO io;

    public DataFile(String name, String fileName, int nbBuffers, int bufferSize, boolean debug) {
        this.io = new MultiBufferedFileIO(nbBuffers, name, fileName, true, bufferSize, debug);
    }

    public void write(long position, Bytes bytes) {
        this.io.goToPosition(position);
        byte[] b = bytes.getByteArray();
        this.io.writeBytes(b);
    }

    public Bytes read(long position, int size) {
        this.io.goToPosition(position);
        byte[] bb = new byte[size];
        int iPosition = (int)position;
        int iSize = size;
        this.io.readBytes(bb, iPosition, iSize);
        return BytesFactory.getBytes(bb);
    }

    public void flush() throws IOException {
        this.io.flushIO();
    }

    public void close() {
        this.io.close();
    }

    public long length() {
        return this.io.getLength();
    }

    public void rollback() {
    }

    public void commit() {
    }

    public long write(Bytes bytes) {
        long positionToWrite = this.length();
        System.out.println("real size is " + positionToWrite);
        this.write(positionToWrite, bytes);
        long l = positionToWrite;
        System.out.println("\tafter size is " + this.length());
        return l;
    }
}

