/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.Release;
import org.neodatis.odb.core.layers.layer4.BaseIdentification;
import org.neodatis.odb.core.layers.layer4.IOFileParameter;
import org.neodatis.odb.core.layers.layer4.IOSocketParameter;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.ODBExplorerPanel;
import org.neodatis.odb.gui.ODBInternalFrame;
import org.neodatis.odb.gui.connect.Connection;
import org.neodatis.odb.gui.connect.LocalConnection;
import org.neodatis.odb.gui.connect.MainConnectPanel;
import org.neodatis.odb.gui.connect.RemoteConnection;
import org.neodatis.odb.gui.tool.GuiUtil;
import org.neodatis.odb.gui.xml.XmlExportPanel;
import org.neodatis.odb.gui.xml.XmlImportPanel;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbThread;

public class ODBExplorerFrame
extends JFrame
implements ActionListener,
ItemListener {
    private JDesktopPane desktop;
    private final JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
    private final LoggerPanel logger;
    private String nextThreadAction;
    protected NeoDatisConfig config = NeoDatis.getConfig();

    public ODBExplorerFrame() {
        super("NeoDatis Object Explorer");
        int inset = 5;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 5 - 50);
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(Color.WHITE);
        this.logger = new LoggerPanel();
        DLogger.register(this.logger);
        JSplitPane pane = new JSplitPane(0, this.desktop, this.logger);
        pane.setOneTouchExpandable(true);
        pane.setDividerLocation(550);
        this.setContentPane(pane);
        this.setJMenuBar(this.createMenuBar());
        this.desktop.setDragMode(1);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("NeoDatis");
        menu.setMnemonic(75);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Open DataBase");
        menuItem.setMnemonic(79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        menuItem.setActionCommand("open");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Export to XML");
        menuItem.setMnemonic(69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        menuItem.setActionCommand("export");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Import from XML");
        menuItem.setMnemonic(73);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        menuItem.setActionCommand("import");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Quit");
        menuItem.setMnemonic(81);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        menuItem.setActionCommand("quit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new JMenu("Options");
        menu.setMnemonic(79);
        menuBar.add(menu);
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Tolerate inconsistency", false);
        cbmi.setMnemonic(84);
        cbmi.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        cbmi.setActionCommand("tolerate-inconsistency");
        cbmi.addItemListener(this);
        menu.add(cbmi);
        menu = new JMenu("Go to");
        menu.setMnemonic(71);
        menuBar.add(menu);
        JMenuItem cbNeoDatisSite = new JMenuItem("NeoDatis Web Site");
        cbNeoDatisSite.setMnemonic(87);
        cbNeoDatisSite.setActionCommand("neodatis-site");
        cbNeoDatisSite.addActionListener(this);
        menu.add(cbNeoDatisSite);
        JMenuItem cbNeoDatisSF = new JMenuItem("Source forge forum");
        cbNeoDatisSF.setMnemonic(83);
        cbNeoDatisSF.setActionCommand("neodatis-forum");
        cbNeoDatisSF.addActionListener(this);
        menu.add(cbNeoDatisSF);
        JMenuItem cbNeoDatisBug = new JMenuItem("Report a bug");
        cbNeoDatisBug.setMnemonic(83);
        cbNeoDatisBug.setActionCommand("neodatis-new-bug");
        cbNeoDatisBug.addActionListener(this);
        menu.add(cbNeoDatisBug);
        JMenuItem cbNeoDatisFR = new JMenuItem("Create a feature request");
        cbNeoDatisFR.setMnemonic(83);
        cbNeoDatisFR.setActionCommand("neodatis-new-fr");
        cbNeoDatisFR.addActionListener(this);
        menu.add(cbNeoDatisFR);
        JMenuItem cbNeoDatisBuyService = new JMenuItem("Buy service or support from NeoDatis");
        cbNeoDatisBuyService.setMnemonic(83);
        cbNeoDatisBuyService.setActionCommand("neodatis-buy-service");
        cbNeoDatisBuyService.addActionListener(this);
        menu.add(cbNeoDatisBuyService);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        JMenuItem cbAbout = new JMenuItem("About");
        cbAbout.setMnemonic(65);
        cbAbout.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        cbAbout.setActionCommand("about");
        cbAbout.addActionListener(this);
        menu.add(cbAbout);
        return menuBar;
    }

    public void actionPerformed(ActionEvent e) {
        if ("new".equals(e.getActionCommand())) {
            return;
        }
        if ("about".equals(e.getActionCommand())) {
            this.displayAbout();
        }
        if ("open".equals(e.getActionCommand())) {
            try {
                this.openODBBase();
            }
            catch (Exception e1) {
                this.logger.error("Error while opening base", e1);
            }
            return;
        }
        if ("export".equals(e.getActionCommand())) {
            try {
                this.exportToXml();
            }
            catch (Exception e1) {
                this.logger.error("Error while exporting base", e1);
            }
            return;
        }
        if ("import".equals(e.getActionCommand())) {
            try {
                this.importFromXml();
            }
            catch (Exception e1) {
                this.logger.error("Error while importing base", e1);
            }
            return;
        }
        if ("neodatis-site".equals(e.getActionCommand())) {
            this.goToNeoDatisSite();
        }
        if ("neodatis-forum".equals(e.getActionCommand())) {
            this.goToAddress("https://sourceforge.net/forum/?group_id=179124");
        }
        if ("neodatis-new-bug".equals(e.getActionCommand())) {
            this.goToAddress("https://sourceforge.net/tracker/?group_id=179124&atid=887885");
        }
        if ("neodatis-new-fr".equals(e.getActionCommand())) {
            this.goToAddress("https://sourceforge.net/tracker/?group_id=179124&atid=887888");
        }
        if ("neodatis-buy-service".equals(e.getActionCommand())) {
            this.goToAddress("http://www.neodatis.com");
        }
        if ("quit".equals(e.getActionCommand())) {
            this.quit();
        }
    }

    private void goToAddress(String url) {
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Opening URL in default browser is not supported on your system\n\nPlease go to " + url, "Error", 64);
        }
    }

    private void goToNeoDatisSite() {
        try {
            BrowserLauncher.openURL((String)"http://www.neodatis.org");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Opening URL in default browser is not supported on your system\n\nPlease go to www.neodatis.org", "Error", 64);
        }
    }

    private void displayAbout() {
        String s = "NeoDatis Object Database - www.neodatis.org\n\nVersion\t" + Release.RELEASE_NUMBER + "\nBuild\t" + Release.RELEASE_BUILD + "\nDate\t" + Release.RELEASE_DATE;
        JOptionPane.showMessageDialog(null, s, "About NeoDatis Object Database", 0);
    }

    private void tolerateInconsistency(boolean tolerate) {
        this.config.setThrowExceptionWhenInconsistencyFound(!tolerate);
    }

    public void openODBBase() throws Exception {
        Object engine = null;
        MainConnectPanel mcp = null;
        Connection connection = null;
        mcp = new MainConnectPanel((Frame)this, this.logger);
        mcp.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = (int)screenSize.getWidth();
        int h = (int)screenSize.getHeight();
        int wdialog = (int)mcp.getBounds().getWidth();
        int hdialog = (int)mcp.getBounds().getHeight();
        int rw = w / 2 - wdialog / 2;
        int rh = h / 2 - hdialog / 2;
        mcp.setLocation(new Point(rw, rh));
        mcp.setVisible(true);
        connection = mcp.getConnection();
        if (connection == null) {
            return;
        }
        BaseIdentification baseIdentification = null;
        if (connection instanceof LocalConnection) {
            LocalConnection lc = (LocalConnection)connection;
            if (lc.getUser() != null) {
                this.config.setUser(lc.getUser());
                this.config.setPassword(lc.getPassword());
            }
            baseIdentification = new IOFileParameter(lc.getFileName(), true, this.config);
        } else {
            RemoteConnection rc = (RemoteConnection)connection;
            NeoDatisConfig config = NeoDatis.getConfig().setHostAndPort(rc.getHost(), rc.getPort()).setUser(rc.getUser()).setPassword(rc.getPassword());
            baseIdentification = new IOSocketParameter(rc.getBaseIdentifier(), config);
        }
        JInternalFrame iframe = this.createInternalFrame(connection.toString(), this.logger);
        ODBExplorerPanel oep = new ODBExplorerPanel(iframe, baseIdentification, connection.toString(), this.logger);
        iframe.setContentPane(oep);
        iframe.pack();
        iframe.setVisible(true);
        iframe.setLocation(15, 15);
        this.desktop.add(iframe);
        try {
            iframe.setSelected(true);
        }
        catch (PropertyVetoException e) {
            this.logger.error("Error while opening base", e);
        }
        mcp.dispose();
    }

    private JInternalFrame createInternalFrame(String title, ILogger logger) {
        ODBInternalFrame iframe = new ODBInternalFrame(title, logger);
        return iframe;
    }

    protected void quit() {
        System.exit(0);
    }

    public void run() {
        this.logger.info("Iniciando da thread " + OdbThread.getCurrentThreadName());
        if ("open".equals(this.nextThreadAction)) {
            try {
                this.openODBBase();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        if ("import".equals(this.nextThreadAction)) {
            try {
                this.importFromXml();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        this.logger.info("Saindo da thread " + OdbThread.getCurrentThreadName());
    }

    private void exportToXml() {
        XmlExportPanel panel = new XmlExportPanel(this.logger);
        final JDialog dialog = new JDialog();
        dialog.setTitle(Messages.getString("XML Exportation"));
        dialog.getContentPane().add(panel);
        JButton btClose = new JButton(Messages.getString("Close"));
        btClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.getContentPane().add((Component)btClose, "South");
        dialog.setModal(true);
        dialog.pack();
        GuiUtil.centerScreen(dialog);
    }

    private void importFromXml() {
        XmlImportPanel panel = new XmlImportPanel(this.logger);
        final JDialog dialog = new JDialog();
        dialog.setTitle(Messages.getString("XML importation"));
        dialog.getContentPane().add(panel);
        JButton btClose = new JButton(Messages.getString("Close"));
        btClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.getContentPane().add((Component)btClose, "South");
        dialog.setModal(true);
        dialog.pack();
        GuiUtil.centerScreen(dialog);
    }

    public void itemStateChanged(ItemEvent e) {
        this.tolerateInconsistency(e.getStateChange() == 1);
    }
}

