/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.ODBServer;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectRepresentationImpl;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.query.QueryManager;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.core.refactor.CheckMetaModelResult;
import org.neodatis.odb.core.server.ServerSession;
import org.neodatis.odb.core.server.connection.SessionManager;
import org.neodatis.odb.core.server.connection.ThreadToExecuteRemoteProcess;
import org.neodatis.odb.core.server.message.AddIndexMessage;
import org.neodatis.odb.core.server.message.AddIndexMessageResponse;
import org.neodatis.odb.core.server.message.CheckMetaModelCompatibilityMessage;
import org.neodatis.odb.core.server.message.CheckMetaModelCompatibilityMessageResponse;
import org.neodatis.odb.core.server.message.CloseMessage;
import org.neodatis.odb.core.server.message.CloseMessageResponse;
import org.neodatis.odb.core.server.message.CommitMessage;
import org.neodatis.odb.core.server.message.CommitMessageResponse;
import org.neodatis.odb.core.server.message.ConnectMessage;
import org.neodatis.odb.core.server.message.ConnectMessageResponse;
import org.neodatis.odb.core.server.message.CountMessage;
import org.neodatis.odb.core.server.message.CountMessageResponse;
import org.neodatis.odb.core.server.message.DeleteBaseMessage;
import org.neodatis.odb.core.server.message.DeleteBaseMessageResponse;
import org.neodatis.odb.core.server.message.DeleteIndexMessage;
import org.neodatis.odb.core.server.message.DeleteIndexMessageResponse;
import org.neodatis.odb.core.server.message.DeleteObjectMessage;
import org.neodatis.odb.core.server.message.DeleteObjectMessageResponse;
import org.neodatis.odb.core.server.message.ErrorMessage;
import org.neodatis.odb.core.server.message.GetFileMessage;
import org.neodatis.odb.core.server.message.GetFileMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectFromIdMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectFromOidMessage;
import org.neodatis.odb.core.server.message.GetObjectHeaderFromIdMessage;
import org.neodatis.odb.core.server.message.GetObjectHeaderFromIdMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectValuesMessage;
import org.neodatis.odb.core.server.message.GetObjectValuesMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectsMessage;
import org.neodatis.odb.core.server.message.GetObjectsMessageResponse;
import org.neodatis.odb.core.server.message.GetSessionsMessage;
import org.neodatis.odb.core.server.message.GetSessionsMessageResponse;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.odb.core.server.message.NewClassInfoListMessage;
import org.neodatis.odb.core.server.message.NewClassInfoListMessageResponse;
import org.neodatis.odb.core.server.message.NextClassInfoOidMessage;
import org.neodatis.odb.core.server.message.NextClassInfoOidResponseMessage;
import org.neodatis.odb.core.server.message.RebuildIndexMessage;
import org.neodatis.odb.core.server.message.RebuildIndexMessageResponse;
import org.neodatis.odb.core.server.message.RollbackMessage;
import org.neodatis.odb.core.server.message.RollbackMessageResponse;
import org.neodatis.odb.core.server.message.SendFileMessage;
import org.neodatis.odb.core.server.message.SendFileMessageResponse;
import org.neodatis.odb.core.server.message.StoreClassInfoMessage;
import org.neodatis.odb.core.server.message.StoreClassInfoMessageResponse;
import org.neodatis.odb.core.server.message.StoreObjectMessage;
import org.neodatis.odb.core.server.message.StoreObjectMessageResponse;
import org.neodatis.odb.core.server.message.process.AsyncProcessReturn;
import org.neodatis.odb.core.server.message.process.RemoteProcess;
import org.neodatis.odb.core.server.message.process.RemoteProcessMessage;
import org.neodatis.odb.core.server.message.process.RemoteProcessMessageResponse;
import org.neodatis.odb.core.server.message.process.RemoteProcessReturn;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.core.session.SessionWrapper;
import org.neodatis.odb.main.ODBForTrigger;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.IOUtil;
import org.neodatis.tool.mutex.Mutex;
import org.neodatis.tool.mutex.MutexFactory;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.io.OdbFile;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

public abstract class ClientServerConnection {
    private static final String LOG_ID = "ClientServerConnection";
    private static int nbMessages = 0;
    protected boolean connectionIsUp;
    protected String baseIdentifier;
    protected String connectionId;
    protected boolean debug;
    protected ODBServer server;
    protected ServerSession session;
    private static final String COMMIT_CLOSE_CONNECT_MUTEX_NAME = "commit-close-connect";
    private static final String COUNT_MUTEX_NAME = "commit-close-connect";
    private static final String GET_OBJECT_HEADER_FROM_ID_MUTEX_NAME = "commit-close-connect";
    private static final String GET_OBJECT_FROM_ID_MUTEX_NAME = "commit-close-connect";
    private static final String GET_VALUES_MUTEX_NAME = "commit-close-connect";
    private static final String GET_OBJECTS_MUTEX_NAME = "commit-close-connect";
    private static final String DELETE_OBJECT_MUTEX_NAME = "commit-close-connect";
    private static final String ADD_CLASS_INFO_LIST_MUTEX_NAME = "commit-close-connect";
    private static final String STORE_MUTEX_NAME = "commit-close-connect";

    public ClientServerConnection(ODBServer server) {
        this.debug = server.getConfig().logServerConnections();
        this.server = server;
    }

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message manageMessage(Message message) {
        ErrorMessage errorMessage;
        long start;
        block50: {
            Message message2;
            block49: {
                Message message3;
                block48: {
                    Message message4;
                    block47: {
                        Message message5;
                        block46: {
                            CheckMetaModelCompatibilityMessageResponse checkMetaModelCompatibilityMessageResponse;
                            block45: {
                                Message message6;
                                block44: {
                                    Message message7;
                                    block43: {
                                        Message message8;
                                        block42: {
                                            Message message9;
                                            block41: {
                                                Message message10;
                                                block40: {
                                                    Message message11;
                                                    block39: {
                                                        Message message12;
                                                        block38: {
                                                            Message message13;
                                                            block37: {
                                                                Message message14;
                                                                block36: {
                                                                    Message message15;
                                                                    block35: {
                                                                        Message message16;
                                                                        block34: {
                                                                            Message message17;
                                                                            block33: {
                                                                                Message message18;
                                                                                block32: {
                                                                                    Message message19;
                                                                                    block31: {
                                                                                        Message message20;
                                                                                        block30: {
                                                                                            Message message21;
                                                                                            block29: {
                                                                                                Message message22;
                                                                                                block28: {
                                                                                                    Message message23;
                                                                                                    block27: {
                                                                                                        start = OdbTime.getCurrentTimeInMs();
                                                                                                        try {
                                                                                                            ++nbMessages;
                                                                                                            int commandId = message.getMessageType();
                                                                                                            switch (commandId) {
                                                                                                                case 10: {
                                                                                                                    message23 = this.manageConnectCommand((ConnectMessage)message);
                                                                                                                    Object var8_28 = null;
                                                                                                                    break block27;
                                                                                                                }
                                                                                                                case 20: {
                                                                                                                    message22 = this.manageGetObjectsCommand((GetObjectsMessage)message);
                                                                                                                    break block28;
                                                                                                                }
                                                                                                                case 30: {
                                                                                                                    message21 = this.manageGetObjectFromIdCommand((GetObjectFromOidMessage)message);
                                                                                                                    break block29;
                                                                                                                }
                                                                                                                case 150: {
                                                                                                                    message20 = this.manageGetObjectHeaderFromIdCommand((GetObjectHeaderFromIdMessage)message);
                                                                                                                    break block30;
                                                                                                                }
                                                                                                                case 40: {
                                                                                                                    message19 = this.manageStoreObjectCommand((StoreObjectMessage)message);
                                                                                                                    break block31;
                                                                                                                }
                                                                                                                case 220: {
                                                                                                                    message18 = this.manageStoreClassInfoCommand((StoreClassInfoMessage)message);
                                                                                                                    break block32;
                                                                                                                }
                                                                                                                case 50: {
                                                                                                                    message17 = this.manageDeleteObjectCommand((DeleteObjectMessage)message);
                                                                                                                    break block33;
                                                                                                                }
                                                                                                                case 60: {
                                                                                                                    message16 = this.manageCloseCommand((CloseMessage)message);
                                                                                                                    break block34;
                                                                                                                }
                                                                                                                case 70: {
                                                                                                                    message15 = this.manageCommitCommand((CommitMessage)message);
                                                                                                                    break block35;
                                                                                                                }
                                                                                                                case 80: {
                                                                                                                    message14 = this.manageRollbackCommand((RollbackMessage)message);
                                                                                                                    break block36;
                                                                                                                }
                                                                                                                case 90: {
                                                                                                                    message13 = this.manageDeleteBaseCommand((DeleteBaseMessage)message);
                                                                                                                    break block37;
                                                                                                                }
                                                                                                                case 100: {
                                                                                                                    message12 = this.manageGetSessionsCommand((GetSessionsMessage)message);
                                                                                                                    break block38;
                                                                                                                }
                                                                                                                case 110: {
                                                                                                                    message11 = this.manageAddIndexCommand((AddIndexMessage)message);
                                                                                                                    break block39;
                                                                                                                }
                                                                                                                case 160: {
                                                                                                                    message10 = this.manageRebuildIndexCommand((RebuildIndexMessage)message);
                                                                                                                    break block40;
                                                                                                                }
                                                                                                                case 170: {
                                                                                                                    message9 = this.manageDeleteIndexCommand((DeleteIndexMessage)message);
                                                                                                                    break block41;
                                                                                                                }
                                                                                                                case 120: {
                                                                                                                    message8 = this.manageAddClassInfoListCommand((NewClassInfoListMessage)message);
                                                                                                                    break block42;
                                                                                                                }
                                                                                                                case 130: {
                                                                                                                    message7 = this.manageCountCommand((CountMessage)message);
                                                                                                                    break block43;
                                                                                                                }
                                                                                                                case 140: {
                                                                                                                    message6 = this.manageGetObjectValuesCommand((GetObjectValuesMessage)message);
                                                                                                                    break block44;
                                                                                                                }
                                                                                                                case 180: {
                                                                                                                    checkMetaModelCompatibilityMessageResponse = this.manageCheckMetaModelCompatibilityCommand((CheckMetaModelCompatibilityMessage)message);
                                                                                                                    break block45;
                                                                                                                }
                                                                                                                case 210: {
                                                                                                                    message5 = this.manageNextClassInfoOidCommand((NextClassInfoOidMessage)message);
                                                                                                                    break block46;
                                                                                                                }
                                                                                                                case 230: {
                                                                                                                    message4 = this.manageSendFileCommand((SendFileMessage)message);
                                                                                                                    break block47;
                                                                                                                }
                                                                                                                case 235: {
                                                                                                                    message3 = this.manageGetFileCommand((GetFileMessage)message);
                                                                                                                    break block48;
                                                                                                                }
                                                                                                                case 240: {
                                                                                                                    message2 = this.manageRemoteProcessCommand((RemoteProcessMessage)message);
                                                                                                                    break block49;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    StringBuffer buffer = new StringBuffer();
                                                                                                                    buffer.append("ODBServer.ConnectionThread:command ").append(commandId).append(" not implemented");
                                                                                                                    errorMessage = new ErrorMessage("?", "?", buffer.toString());
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            break block50;
                                                                                                        }
                                                                                                        catch (Throwable throwable) {
                                                                                                            Object var8_52 = null;
                                                                                                            long end = OdbTime.getCurrentTimeInMs();
                                                                                                            if (!this.debug) throw throwable;
                                                                                                            StringBuffer buffer = new StringBuffer();
                                                                                                            buffer.append("[").append(nbMessages).append("] ");
                                                                                                            buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                                                            DLogger.info(buffer);
                                                                                                            throw throwable;
                                                                                                        }
                                                                                                    }
                                                                                                    long end = OdbTime.getCurrentTimeInMs();
                                                                                                    if (!this.debug) return message23;
                                                                                                    StringBuffer buffer = new StringBuffer();
                                                                                                    buffer.append("[").append(nbMessages).append("] ");
                                                                                                    buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                                                    DLogger.info(buffer);
                                                                                                    return message23;
                                                                                                }
                                                                                                Object var8_29 = null;
                                                                                                long end = OdbTime.getCurrentTimeInMs();
                                                                                                if (!this.debug) return message22;
                                                                                                StringBuffer buffer = new StringBuffer();
                                                                                                buffer.append("[").append(nbMessages).append("] ");
                                                                                                buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                                                DLogger.info(buffer);
                                                                                                return message22;
                                                                                            }
                                                                                            Object var8_30 = null;
                                                                                            long end = OdbTime.getCurrentTimeInMs();
                                                                                            if (!this.debug) return message21;
                                                                                            StringBuffer buffer = new StringBuffer();
                                                                                            buffer.append("[").append(nbMessages).append("] ");
                                                                                            buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                                            DLogger.info(buffer);
                                                                                            return message21;
                                                                                        }
                                                                                        Object var8_31 = null;
                                                                                        long end = OdbTime.getCurrentTimeInMs();
                                                                                        if (!this.debug) return message20;
                                                                                        StringBuffer buffer = new StringBuffer();
                                                                                        buffer.append("[").append(nbMessages).append("] ");
                                                                                        buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                                        DLogger.info(buffer);
                                                                                        return message20;
                                                                                    }
                                                                                    Object var8_32 = null;
                                                                                    long end = OdbTime.getCurrentTimeInMs();
                                                                                    if (!this.debug) return message19;
                                                                                    StringBuffer buffer = new StringBuffer();
                                                                                    buffer.append("[").append(nbMessages).append("] ");
                                                                                    buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                                    DLogger.info(buffer);
                                                                                    return message19;
                                                                                }
                                                                                Object var8_33 = null;
                                                                                long end = OdbTime.getCurrentTimeInMs();
                                                                                if (!this.debug) return message18;
                                                                                StringBuffer buffer = new StringBuffer();
                                                                                buffer.append("[").append(nbMessages).append("] ");
                                                                                buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                                DLogger.info(buffer);
                                                                                return message18;
                                                                            }
                                                                            Object var8_34 = null;
                                                                            long end = OdbTime.getCurrentTimeInMs();
                                                                            if (!this.debug) return message17;
                                                                            StringBuffer buffer = new StringBuffer();
                                                                            buffer.append("[").append(nbMessages).append("] ");
                                                                            buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                            DLogger.info(buffer);
                                                                            return message17;
                                                                        }
                                                                        Object var8_35 = null;
                                                                        long end = OdbTime.getCurrentTimeInMs();
                                                                        if (!this.debug) return message16;
                                                                        StringBuffer buffer = new StringBuffer();
                                                                        buffer.append("[").append(nbMessages).append("] ");
                                                                        buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                        DLogger.info(buffer);
                                                                        return message16;
                                                                    }
                                                                    Object var8_36 = null;
                                                                    long end = OdbTime.getCurrentTimeInMs();
                                                                    if (!this.debug) return message15;
                                                                    StringBuffer buffer = new StringBuffer();
                                                                    buffer.append("[").append(nbMessages).append("] ");
                                                                    buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                    DLogger.info(buffer);
                                                                    return message15;
                                                                }
                                                                Object var8_37 = null;
                                                                long end = OdbTime.getCurrentTimeInMs();
                                                                if (!this.debug) return message14;
                                                                StringBuffer buffer = new StringBuffer();
                                                                buffer.append("[").append(nbMessages).append("] ");
                                                                buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                                DLogger.info(buffer);
                                                                return message14;
                                                            }
                                                            Object var8_38 = null;
                                                            long end = OdbTime.getCurrentTimeInMs();
                                                            if (!this.debug) return message13;
                                                            StringBuffer buffer = new StringBuffer();
                                                            buffer.append("[").append(nbMessages).append("] ");
                                                            buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                            DLogger.info(buffer);
                                                            return message13;
                                                        }
                                                        Object var8_39 = null;
                                                        long end = OdbTime.getCurrentTimeInMs();
                                                        if (!this.debug) return message12;
                                                        StringBuffer buffer = new StringBuffer();
                                                        buffer.append("[").append(nbMessages).append("] ");
                                                        buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                        DLogger.info(buffer);
                                                        return message12;
                                                    }
                                                    Object var8_40 = null;
                                                    long end = OdbTime.getCurrentTimeInMs();
                                                    if (!this.debug) return message11;
                                                    StringBuffer buffer = new StringBuffer();
                                                    buffer.append("[").append(nbMessages).append("] ");
                                                    buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                    DLogger.info(buffer);
                                                    return message11;
                                                }
                                                Object var8_41 = null;
                                                long end = OdbTime.getCurrentTimeInMs();
                                                if (!this.debug) return message10;
                                                StringBuffer buffer = new StringBuffer();
                                                buffer.append("[").append(nbMessages).append("] ");
                                                buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                                DLogger.info(buffer);
                                                return message10;
                                            }
                                            Object var8_42 = null;
                                            long end = OdbTime.getCurrentTimeInMs();
                                            if (!this.debug) return message9;
                                            StringBuffer buffer = new StringBuffer();
                                            buffer.append("[").append(nbMessages).append("] ");
                                            buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                            DLogger.info(buffer);
                                            return message9;
                                        }
                                        Object var8_43 = null;
                                        long end = OdbTime.getCurrentTimeInMs();
                                        if (!this.debug) return message8;
                                        StringBuffer buffer = new StringBuffer();
                                        buffer.append("[").append(nbMessages).append("] ");
                                        buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                        DLogger.info(buffer);
                                        return message8;
                                    }
                                    Object var8_44 = null;
                                    long end = OdbTime.getCurrentTimeInMs();
                                    if (!this.debug) return message7;
                                    StringBuffer buffer = new StringBuffer();
                                    buffer.append("[").append(nbMessages).append("] ");
                                    buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                    DLogger.info(buffer);
                                    return message7;
                                }
                                Object var8_45 = null;
                                long end = OdbTime.getCurrentTimeInMs();
                                if (!this.debug) return message6;
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("[").append(nbMessages).append("] ");
                                buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                                DLogger.info(buffer);
                                return message6;
                            }
                            Object var8_46 = null;
                            long end = OdbTime.getCurrentTimeInMs();
                            if (!this.debug) return checkMetaModelCompatibilityMessageResponse;
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("[").append(nbMessages).append("] ");
                            buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                            DLogger.info(buffer);
                            return checkMetaModelCompatibilityMessageResponse;
                        }
                        Object var8_47 = null;
                        long end = OdbTime.getCurrentTimeInMs();
                        if (!this.debug) return message5;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("[").append(nbMessages).append("] ");
                        buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                        DLogger.info(buffer);
                        return message5;
                    }
                    Object var8_48 = null;
                    long end = OdbTime.getCurrentTimeInMs();
                    if (!this.debug) return message4;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("[").append(nbMessages).append("] ");
                    buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                    DLogger.info(buffer);
                    return message4;
                }
                Object var8_49 = null;
                long end = OdbTime.getCurrentTimeInMs();
                if (!this.debug) return message3;
                StringBuffer buffer = new StringBuffer();
                buffer.append("[").append(nbMessages).append("] ");
                buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
                DLogger.info(buffer);
                return message3;
            }
            Object var8_50 = null;
            long end = OdbTime.getCurrentTimeInMs();
            if (!this.debug) return message2;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(nbMessages).append("] ");
            buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
            DLogger.info(buffer);
            return message2;
        }
        Object var8_51 = null;
        long end = OdbTime.getCurrentTimeInMs();
        if (!this.debug) return errorMessage;
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(nbMessages).append("] ");
        buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - sessionId =").append(message.getSessionId()).append(" - duration=").append(end - start);
        DLogger.info(buffer);
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageNextClassInfoOidCommand(NextClassInfoOidMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            SessionEngine engine = this.session.getEngine();
            ClassOid coid = engine.getStorageEngine().getOidGenerator().createClassOid();
            NextClassInfoOidResponseMessage nextClassInfoOidResponseMessage = new NextClassInfoOidResponseMessage(baseIdentifier, message.getSessionId(), coid);
            Object var9_10 = null;
            if (mutex != null) {
                mutex.release("nextClassInfoOid");
            }
            return nextClassInfoOidResponseMessage;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while getting next ClassInfo Oid";
                DLogger.error(msg, e);
                NewClassInfoListMessageResponse newClassInfoListMessageResponse = new NewClassInfoListMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var9_11 = null;
                if (mutex != null) {
                    mutex.release("nextClassInfoOid");
                }
                return newClassInfoListMessageResponse;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_12 = null;
                    if (mutex == null) break block6;
                    mutex.release("nextClassInfoOid");
                }
                throw throwable;
            }
        }
    }

    private CheckMetaModelCompatibilityMessageResponse manageCheckMetaModelCompatibilityCommand(CheckMetaModelCompatibilityMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        SessionManager sessionManager = null;
        Session session = null;
        try {
            sessionManager = this.getSessionManager(baseIdentifier);
            if (sessionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new CheckMetaModelCompatibilityMessageResponse(baseIdentifier, message.getSessionId(), buffer.toString());
            }
            session = sessionManager.getSession(message.getSessionId());
            SessionEngine engine = session.getEngine();
            Map<String, ClassInfo> currentCIs = message.getCurrentCIs();
            CheckMetaModelResult result = engine.checkMetaModelCompatibility(currentCIs);
            MetaModel updatedMetaModel = null;
            if (result.isModelHasBeenUpdated()) {
                updatedMetaModel = session.getMetaModel().duplicate();
            }
            return new CheckMetaModelCompatibilityMessageResponse(baseIdentifier, message.getSessionId(), result, updatedMetaModel);
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new CheckMetaModelCompatibilityMessageResponse(baseIdentifier, message.getSessionId(), OdbString.exceptionToString(e, false));
        }
    }

    private Message manageAddIndexCommand(AddIndexMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        SessionManager sessionManager = null;
        Session session = null;
        try {
            sessionManager = this.getSessionManager(baseIdentifier);
            if (sessionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new AddIndexMessageResponse(baseIdentifier, message.getSessionId(), buffer.toString());
            }
            session = sessionManager.getSession(message.getSessionId());
            SessionEngine engine = session.getEngine();
            engine.addIndexOn(message.getClassName(), message.getIndexName(), message.getIndexFieldNames(), message.isVerbose(), message.acceptMultipleValuesForSameKey());
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new AddIndexMessageResponse(baseIdentifier, message.getSessionId(), OdbString.exceptionToString(e, false));
        }
        return new AddIndexMessageResponse(baseIdentifier, message.getSessionId());
    }

    private Message manageRebuildIndexCommand(RebuildIndexMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        SessionManager sessionManager = null;
        Session session = null;
        try {
            sessionManager = this.getSessionManager(baseIdentifier);
            if (sessionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new RebuildIndexMessageResponse(baseIdentifier, message.getSessionId(), buffer.toString());
            }
            session = sessionManager.getSession(message.getSessionId());
            SessionEngine engine = session.getEngine();
            engine.rebuildIndex(message.getClassName(), message.getIndexName(), message.isVerbose());
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new RebuildIndexMessageResponse(baseIdentifier, message.getSessionId(), OdbString.exceptionToString(e, false));
        }
        return new RebuildIndexMessageResponse(baseIdentifier, message.getSessionId());
    }

    private Message manageDeleteIndexCommand(DeleteIndexMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        SessionManager sessionManager = null;
        Session session = null;
        try {
            sessionManager = this.getSessionManager(baseIdentifier);
            if (sessionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new DeleteIndexMessageResponse(baseIdentifier, message.getSessionId(), buffer.toString());
            }
            session = sessionManager.getSession(message.getSessionId());
            SessionEngine engine = session.getEngine();
            engine.deleteIndex(message.getClassName(), message.getIndexName(), message.isVerbose());
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new DeleteIndexMessageResponse(baseIdentifier, message.getSessionId(), OdbString.exceptionToString(e, false));
        }
        return new DeleteIndexMessageResponse(baseIdentifier, message.getSessionId());
    }

    private SessionManager getSessionManager(String baseIdentifier) throws Exception {
        return this.getSessionManager(baseIdentifier, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionManager getSessionManager(String baseIdentifier, String user, String password, boolean returnNullIfDoesNotExit) throws Exception {
        SessionManager sessionManager;
        block6: {
            block5: {
                try {
                    sessionManager = this.server.getSessionManagerForBase(baseIdentifier);
                    if (sessionManager != null || !returnNullIfDoesNotExit) break block5;
                    SessionManager sessionManager2 = null;
                    Object var9_9 = null;
                    return sessionManager2;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    throw throwable;
                }
            }
            if (sessionManager == null && this.server.automaticallyCreateDatabase()) {
                this.server.addBase(baseIdentifier, baseIdentifier, user, password);
                sessionManager = this.server.getSessionManagerForBase(baseIdentifier);
            }
            if (sessionManager != null || this.server.automaticallyCreateDatabase()) break block6;
            StringBuffer buffer = new StringBuffer();
            buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
            SessionManager sessionManager3 = null;
            Object var9_10 = null;
            return sessionManager3;
        }
        SessionManager sessionManager4 = sessionManager;
        Object var9_11 = null;
        return sessionManager4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageCloseCommand(CloseMessage message) {
        SessionManager sessionManager;
        Mutex mutex;
        String baseIdentifier;
        block8: {
            baseIdentifier = message.getBaseIdentifier();
            mutex = null;
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            sessionManager = this.getSessionManager(baseIdentifier);
            if (sessionManager != null) break block8;
            StringBuffer buffer = new StringBuffer();
            buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
            CloseMessageResponse closeMessageResponse = new CloseMessageResponse(baseIdentifier, message.getSessionId(), buffer.toString());
            Object var8_10 = null;
            if (mutex != null) {
                mutex.release("close");
            }
            return closeMessageResponse;
        }
        try {
            this.session.setCurrentAction(6);
            this.session.close();
            sessionManager.removeSession(this.session);
            this.connectionIsUp = false;
            CloseMessageResponse closeMessageResponse = new CloseMessageResponse(baseIdentifier, message.getSessionId());
            Object var8_11 = null;
            if (mutex != null) {
                mutex.release("close");
            }
            return closeMessageResponse;
        }
        catch (Exception e) {
            try {
                DLogger.error(baseIdentifier + ":Server error while closing", e);
                CloseMessageResponse closeMessageResponse = new CloseMessageResponse(baseIdentifier, message.getSessionId(), OdbString.exceptionToString(e, false));
                Object var8_12 = null;
                if (mutex != null) {
                    mutex.release("close");
                }
                return closeMessageResponse;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var8_13 = null;
                    if (mutex == null) break block9;
                    mutex.release("close");
                }
                throw throwable;
            }
        }
    }

    private Message manageGetSessionsCommand(GetSessionsMessage message) {
        try {
            List<String> descriptions = this.server.getSessionDescriptions();
            return new GetSessionsMessageResponse(descriptions);
        }
        catch (Exception e) {
            DLogger.error("Server error while getting session descriptions", e);
            return new GetSessionsMessageResponse(OdbString.exceptionToString(e, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageCommitCommand(CommitMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            this.session.setCurrentAction(5);
            this.session.commit();
            CommitMessageResponse commitMessageResponse = new CommitMessageResponse(baseIdentifier, message.getSessionId(), true);
            Object var7_6 = null;
            if (mutex != null) {
                mutex.release("commit");
            }
            this.session.endCurrentAction();
            return commitMessageResponse;
        }
        catch (Exception e) {
            try {
                DLogger.error(baseIdentifier + ":Server error while commiting", e);
                CommitMessageResponse commitMessageResponse = new CommitMessageResponse(baseIdentifier, message.getSessionId(), OdbString.exceptionToString(e, false));
                Object var7_7 = null;
                if (mutex != null) {
                    mutex.release("commit");
                }
                this.session.endCurrentAction();
                return commitMessageResponse;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (mutex != null) {
                    mutex.release("commit");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageRollbackCommand(RollbackMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        try {
            try {
                mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
                this.session.setCurrentAction(7);
                this.session.rollback();
            }
            catch (Exception e) {
                DLogger.error(baseIdentifier + ":Server error while rollbacking", e);
                RollbackMessageResponse rollbackMessageResponse = new RollbackMessageResponse(baseIdentifier, message.getSessionId(), OdbString.exceptionToString(e, false));
                Object var7_5 = null;
                if (mutex != null) {
                    mutex.release("rollback");
                }
                this.session.endCurrentAction();
                return rollbackMessageResponse;
            }
            Object var7_4 = null;
            if (mutex != null) {
                mutex.release("rollback");
            }
            this.session.endCurrentAction();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (mutex != null) {
                mutex.release("rollback");
            }
            this.session.endCurrentAction();
            throw throwable;
        }
        return new RollbackMessageResponse(baseIdentifier, message.getSessionId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageStoreObjectCommand(StoreObjectMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        ObjectOid oid = null;
        try {
            SessionEngine engine = this.session.getEngine();
            HashMap<ObjectOid, ObjectOid> clientIds = new HashMap<ObjectOid, ObjectOid>();
            for (ObjectOid ooid : message.getClientIds()) {
                clientIds.put(ooid, ooid);
            }
            OidAndBytes mainOab = message.getOabs().get(0);
            ObjectOid mainOid = (ObjectOid)mainOab.oid;
            this.session.setCurrentAction(100);
            boolean objectIsNew = ((ObjectOid)clientIds.get(mainOid)).isNew();
            ObjectOid[] serverOids = new ObjectOid[message.getClientIds().length];
            HashMap<OID, OID> oidsToReplace = new HashMap<OID, OID>();
            for (int i = 0; i < message.getOabs().size(); ++i) {
                OidAndBytes oab = message.getOabs().get(i);
                ObjectOid oid2 = (ObjectOid)oab.oid;
                ObjectOid clientOid = (ObjectOid)clientIds.get(oid2);
                if (!clientOid.isNew()) continue;
                ObjectOid serverOid = engine.getStorageEngine().getOidGenerator().createObjectOid(oid2.getClassOid());
                oidsToReplace.put(oid2, serverOid);
                serverOids[i] = serverOid;
                serverOid.setIsNew(true);
            }
            NonNativeObjectInfo nnoi = engine.layer3ToLayer2(message.getOabs(), true, oidsToReplace, 0);
            String className = nnoi.getClassInfo().getFullClassName();
            if (nnoi.getOid().isNew()) {
                if (engine.getTriggerManager().hasInsertTriggersFor(className)) {
                    engine.getTriggerManager().manageInsertTriggerBefore(className, new ObjectRepresentationImpl(nnoi, engine.getObjectIntrospector()));
                }
            } else if (engine.getTriggerManager().hasUpdateTriggersFor(className)) {
                engine.getTriggerManager().manageUpdateTriggerBefore(className, null, new ObjectRepresentationImpl(nnoi, engine.getObjectIntrospector()), nnoi.getOid());
            }
            oid = engine.storeMeta(nnoi.getOid(), nnoi);
            StoreObjectMessageResponse storeObjectMessageResponse = new StoreObjectMessageResponse(baseIdentifier, message.getSessionId(), oid, objectIsNew, serverOids, this.session.getValuesToReturn());
            Object var18_23 = null;
            if (mutex != null) {
                mutex.release("storeObject");
            }
            this.session.endCurrentAction();
            if (this.session != null) {
                this.session.clearValuesToReturn();
            }
            return storeObjectMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while storing object ";
                DLogger.error(msg, e);
                StoreObjectMessageResponse storeObjectMessageResponse = new StoreObjectMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var18_24 = null;
                if (mutex != null) {
                    mutex.release("storeObject");
                }
                this.session.endCurrentAction();
                if (this.session != null) {
                    this.session.clearValuesToReturn();
                }
                return storeObjectMessageResponse;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var18_25 = null;
                    if (mutex != null) {
                        mutex.release("storeObject");
                    }
                    this.session.endCurrentAction();
                    if (this.session == null) break block15;
                    this.session.clearValuesToReturn();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageStoreClassInfoCommand(StoreClassInfoMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        Object oid = null;
        try {
            SessionEngine engine = this.session.getEngine();
            OidAndBytes mainOab = message.getOabs().get(0);
            ClassOid mainOid = (ClassOid)mainOab.oid;
            this.session.setCurrentAction(100);
            engine.layer3ToLayer4(message.getOabs());
            ClassInfoList ciList = new ClassInfoList();
            for (OidAndBytes oab : message.getOabs()) {
                ciList.addClassInfo(engine.classInfoFromBytes(oab, false));
            }
            this.session.getMetaModel().addClasses(ciList);
            for (OidAndBytes oab : message.getOabs()) {
                ClassInfo ci = engine.classInfoFromBytes(oab, true);
                this.session.getMetaModel().addClass(ci, true);
            }
            StoreClassInfoMessageResponse storeClassInfoMessageResponse = new StoreClassInfoMessageResponse(baseIdentifier, message.getSessionId(), mainOid);
            Object var13_16 = null;
            if (mutex != null) {
                mutex.release("storeClassInfo");
            }
            this.session.endCurrentAction();
            return storeClassInfoMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while storing class info ";
                DLogger.error(msg, e);
                StoreClassInfoMessageResponse storeClassInfoMessageResponse = new StoreClassInfoMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var13_17 = null;
                if (mutex != null) {
                    mutex.release("storeClassInfo");
                }
                this.session.endCurrentAction();
                return storeClassInfoMessageResponse;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (mutex != null) {
                    mutex.release("storeClassInfo");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageAddClassInfoListCommand(NewClassInfoListMessage message) {
        Mutex mutex;
        String baseIdentifier;
        block8: {
            baseIdentifier = message.getBaseIdentifier();
            SessionManager sessionManager = null;
            mutex = null;
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            sessionManager = this.getSessionManager(baseIdentifier);
            if (sessionManager != null) break block8;
            StringBuffer buffer = new StringBuffer();
            buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
            StoreObjectMessageResponse storeObjectMessageResponse = new StoreObjectMessageResponse(baseIdentifier, message.getSessionId(), buffer.toString());
            Object var11_11 = null;
            if (mutex != null) {
                mutex.release("addClassInfoList");
            }
            return storeObjectMessageResponse;
        }
        try {
            SessionEngine engine = this.session.getEngine();
            ClassInfoList ciList = message.getClassInfoList();
            ciList = this.session.addClasses(ciList);
            OdbArrayList<ClassInfo> allClassInfos = new OdbArrayList<ClassInfo>();
            allClassInfos.addAll(this.session.getMetaModel().getAllClasses());
            NewClassInfoListMessageResponse r = new NewClassInfoListMessageResponse(baseIdentifier, message.getSessionId(), allClassInfos);
            this.session.resetClassInfoIds();
            NewClassInfoListMessageResponse newClassInfoListMessageResponse = r;
            Object var11_12 = null;
            if (mutex != null) {
                mutex.release("addClassInfoList");
            }
            return newClassInfoListMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while adding new Class Info List" + message.getClassInfoList();
                DLogger.error(msg, e);
                NewClassInfoListMessageResponse newClassInfoListMessageResponse = new NewClassInfoListMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var11_13 = null;
                if (mutex != null) {
                    mutex.release("addClassInfoList");
                }
                return newClassInfoListMessageResponse;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var11_14 = null;
                    if (mutex == null) break block9;
                    mutex.release("addClassInfoList");
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageDeleteObjectCommand(DeleteObjectMessage message) {
        Mutex mutex;
        String baseIdentifier;
        block9: {
            baseIdentifier = message.getBaseIdentifier();
            SessionManager sessionManager = null;
            mutex = null;
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            sessionManager = this.getSessionManager(baseIdentifier, null, null, true);
            if (sessionManager != null) break block9;
            StringBuffer buffer = new StringBuffer();
            buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
            DeleteObjectMessageResponse deleteObjectMessageResponse = new DeleteObjectMessageResponse(baseIdentifier, message.getSessionId(), buffer.toString());
            Object var10_11 = null;
            if (mutex != null) {
                mutex.release("deleteObject");
            }
            this.session.endCurrentAction();
            return deleteObjectMessageResponse;
        }
        try {
            this.session.setCurrentAction(3);
            SessionEngine engine = this.session.getEngine();
            engine.deleteObjectWithOid(message.getOid(), message.isCascade());
            DeleteObjectMessageResponse deleteObjectMessageResponse = new DeleteObjectMessageResponse(baseIdentifier, message.getSessionId(), message.getOid());
            Object var10_12 = null;
            if (mutex != null) {
                mutex.release("deleteObject");
            }
            this.session.endCurrentAction();
            return deleteObjectMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while deleting object " + message.getOid();
                DLogger.error(msg, e);
                DeleteObjectMessageResponse deleteObjectMessageResponse = new DeleteObjectMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var10_13 = null;
                if (mutex != null) {
                    mutex.release("deleteObject");
                }
                this.session.endCurrentAction();
                return deleteObjectMessageResponse;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (mutex != null) {
                    mutex.release("deleteObject");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message manageDeleteBaseCommand(DeleteBaseMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        SessionManager sessionManager = null;
        try {
            try {
                sessionManager = this.getSessionManager(baseIdentifier, null, null, true);
                StringBuffer log = new StringBuffer();
                String fileName = message.getBaseIdentifier();
                OdbFile file = new OdbFile(fileName);
                if (sessionManager == null) {
                    DeleteBaseMessageResponse b2;
                    block18: {
                        block14: {
                            DeleteBaseMessageResponse deleteBaseMessageResponse;
                            block17: {
                                block15: {
                                    DeleteBaseMessageResponse deleteBaseMessageResponse2;
                                    block16: {
                                        try {
                                            if (this.debug) {
                                                log.append("Server:Connection manager is null Deleting base " + file.getFullPath()).append(" | exists?").append(file.exists());
                                            }
                                            if (!file.exists()) break block14;
                                            boolean b2 = IOUtil.deleteFile(file.getFullPath());
                                            if (this.debug) {
                                                log.append("| deleted=").append(b2);
                                            }
                                            boolean bl = b2 = !file.exists();
                                            if (this.debug) {
                                                log.append("| deleted=").append(b2);
                                            }
                                            if (!b2) break block15;
                                            deleteBaseMessageResponse2 = new DeleteBaseMessageResponse(baseIdentifier);
                                            Object var10_17 = null;
                                            if (!this.debug) break block16;
                                        }
                                        catch (Throwable throwable) {
                                            Object var10_20 = null;
                                            if (!this.debug) throw throwable;
                                            DLogger.info(log.toString());
                                            throw throwable;
                                        }
                                        DLogger.info(log.toString());
                                    }
                                    Object var12_21 = null;
                                    this.connectionIsUp = false;
                                    return deleteBaseMessageResponse2;
                                }
                                deleteBaseMessageResponse = new DeleteBaseMessageResponse(baseIdentifier, "[1] could not delete base " + file.getFullPath());
                                Object var10_18 = null;
                                if (!this.debug) break block17;
                                DLogger.info(log.toString());
                            }
                            Object var12_22 = null;
                            this.connectionIsUp = false;
                            return deleteBaseMessageResponse;
                        }
                        b2 = new DeleteBaseMessageResponse(baseIdentifier);
                        Object var10_19 = null;
                        if (!this.debug) break block18;
                        DLogger.info(log.toString());
                    }
                    Object var12_23 = null;
                    this.connectionIsUp = false;
                    return b2;
                }
                Session session = sessionManager.getSession(message.getSessionId());
                if (!session.isClosed()) {
                    session.close();
                    sessionManager.removeSession(session);
                    this.removeSessionManager(baseIdentifier);
                }
                boolean b = IOUtil.deleteFile(fileName);
                log.append("| deleted=").append(b);
                if (b) {
                    DeleteBaseMessageResponse deleteBaseMessageResponse = new DeleteBaseMessageResponse(baseIdentifier);
                    Object var12_24 = null;
                    this.connectionIsUp = false;
                    return deleteBaseMessageResponse;
                }
                DeleteBaseMessageResponse deleteBaseMessageResponse = new DeleteBaseMessageResponse(baseIdentifier, "[2] could not delete base " + new OdbFile(message.getBaseIdentifier()).getFullPath());
                Object var12_25 = null;
                this.connectionIsUp = false;
                return deleteBaseMessageResponse;
            }
            catch (Exception e) {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while deleting base " + message.getBaseIdentifier();
                DLogger.error(msg, e);
                DeleteBaseMessageResponse deleteBaseMessageResponse = new DeleteBaseMessageResponse(baseIdentifier, msg + ":\n" + se);
                Object var12_26 = null;
                this.connectionIsUp = false;
                return deleteBaseMessageResponse;
            }
        }
        catch (Throwable throwable) {
            Object var12_27 = null;
            this.connectionIsUp = false;
            throw throwable;
        }
    }

    private void removeSessionManager(String baseId) {
        this.server.removeSessionManagerForBase(baseId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectsCommand(GetObjectsMessage message) {
        Objects metaObjects;
        SessionManager sessionManager;
        Mutex mutex;
        String baseIdentifier;
        block12: {
            Serializable meta;
            baseIdentifier = message.getBaseIdentifier();
            mutex = null;
            this.session.setCurrentAction(4);
            sessionManager = this.server.getSessionManagerForBase(baseIdentifier);
            if (this.session.getConfig().lockObjectsOnSelect()) {
                String fullClassName = QueryManager.getFullClassName(message.getQuery());
            }
            SessionEngine engine = this.session.getEngine();
            metaObjects = null;
            message.getQuery().setSessionEngine(engine);
            metaObjects = engine.getMetaObjects(message.getQuery());
            if (!message.isInMemory()) break block12;
            ArrayList<IOdbList<OidAndBytes>> listOfOabs = new ArrayList<IOdbList<OidAndBytes>>();
            while (metaObjects.hasNext()) {
                meta = (NonNativeObjectInfo)metaObjects.next();
                listOfOabs.add(engine.layer2ToLayer3((NonNativeObjectInfo)meta));
                if (!this.session.getConfig().lockObjectsOnSelect()) continue;
                sessionManager.lockOidForSession(((NonNativeObjectInfo)meta).getOid(), this.session, this.session.getConfig().getTimeoutToAcquireMutex());
            }
            meta = new GetObjectsMessageResponse(baseIdentifier, message.getSessionId(), listOfOabs, message.getQuery().getExecutionPlan(), false);
            Object var10_13 = null;
            if (mutex != null) {
                mutex.release("getObjects");
            }
            this.session.endCurrentAction();
            return meta;
        }
        try {
            ArrayList<ObjectOid> oids = new ArrayList<ObjectOid>();
            while (metaObjects.hasNext()) {
                NonNativeObjectInfo meta = (NonNativeObjectInfo)metaObjects.next();
                oids.add(meta.getOid());
                if (!this.session.getConfig().lockObjectsOnSelect()) continue;
                sessionManager.lockOidForSession(meta.getOid(), this.session, 10000L);
            }
            GetObjectsMessageResponse getObjectsMessageResponse = new GetObjectsMessageResponse(baseIdentifier, message.getSessionId(), oids, message.getQuery().getExecutionPlan());
            Object var10_14 = null;
            if (mutex != null) {
                mutex.release("getObjects");
            }
            this.session.endCurrentAction();
            return getObjectsMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while getting objects for query " + message.getQuery();
                DLogger.error(msg, e);
                GetObjectsMessageResponse getObjectsMessageResponse = new GetObjectsMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var10_15 = null;
                if (mutex != null) {
                    mutex.release("getObjects");
                }
                this.session.endCurrentAction();
                return getObjectsMessageResponse;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (mutex != null) {
                    mutex.release("getObjects");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectValuesCommand(GetObjectValuesMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            this.session.setCurrentAction(4);
            SessionEngine engine = this.session.getEngine();
            Values values = engine.getValues(message.getQuery());
            GetObjectValuesMessageResponse getObjectValuesMessageResponse = new GetObjectValuesMessageResponse(baseIdentifier, message.getSessionId(), values, message.getQuery().getExecutionPlan());
            Object var9_10 = null;
            if (mutex != null) {
                mutex.release("getObjects");
            }
            this.session.endCurrentAction();
            return getObjectValuesMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while getting objects for query " + message.getQuery();
                DLogger.error(msg, e);
                GetObjectValuesMessageResponse getObjectValuesMessageResponse = new GetObjectValuesMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var9_11 = null;
                if (mutex != null) {
                    mutex.release("getObjects");
                }
                this.session.endCurrentAction();
                return getObjectValuesMessageResponse;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (mutex != null) {
                    mutex.release("getObjects");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectFromIdCommand(GetObjectFromOidMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ObjectOid oid = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            this.session.setCurrentAction(4);
            SessionEngine engine = this.session.getEngine();
            oid = message.getOid();
            NonNativeObjectInfo nnoi = engine.getMetaObjectFromOid(oid, true, new InstanceBuilderContext(message.getDepth()));
            IOdbList<OidAndBytes> oabs = engine.layer2ToLayer3(nnoi);
            GetObjectFromIdMessageResponse getObjectFromIdMessageResponse = new GetObjectFromIdMessageResponse(baseIdentifier, message.getSessionId(), oabs);
            Object var10_13 = null;
            if (mutex != null) {
                mutex.release("getObjectFromId");
            }
            this.session.endCurrentAction();
            return getObjectFromIdMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while getting object of id " + oid;
                DLogger.error(msg, e);
                GetObjectFromIdMessageResponse getObjectFromIdMessageResponse = new GetObjectFromIdMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var10_14 = null;
                if (mutex != null) {
                    mutex.release("getObjectFromId");
                }
                this.session.endCurrentAction();
                return getObjectFromIdMessageResponse;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                if (mutex != null) {
                    mutex.release("getObjectFromId");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectHeaderFromIdCommand(GetObjectHeaderFromIdMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ObjectOid oid = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            this.session.setCurrentAction(4);
            SessionEngine engine = this.session.getEngine();
            oid = message.getOid();
            ObjectInfoHeader oih = engine.getMetaHeaderFromOid(oid, true, message.useCache());
            GetObjectHeaderFromIdMessageResponse getObjectHeaderFromIdMessageResponse = new GetObjectHeaderFromIdMessageResponse(baseIdentifier, message.getSessionId(), oih.duplicate());
            Object var10_11 = null;
            if (mutex != null) {
                mutex.release("getObjectFromId");
            }
            this.session.endCurrentAction();
            return getObjectHeaderFromIdMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while getting object of id " + oid;
                DLogger.error(msg, e);
                GetObjectHeaderFromIdMessageResponse getObjectHeaderFromIdMessageResponse = new GetObjectHeaderFromIdMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var10_12 = null;
                if (mutex != null) {
                    mutex.release("getObjectFromId");
                }
                this.session.endCurrentAction();
                return getObjectHeaderFromIdMessageResponse;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (mutex != null) {
                    mutex.release("getObjectFromId");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageCountCommand(CountMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            SessionEngine engine = this.session.getEngine();
            CriteriaQuery query = message.getCriteriaQuery();
            BigInteger nbObjects = engine.count(query);
            CountMessageResponse countMessageResponse = new CountMessageResponse(baseIdentifier, message.getSessionId(), nbObjects);
            Object var9_12 = null;
            if (mutex != null) {
                mutex.release("count");
            }
            return countMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while counting objects for " + message.getCriteriaQuery();
                DLogger.error(msg, e);
                CountMessageResponse countMessageResponse = new CountMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var9_13 = null;
                if (mutex != null) {
                    mutex.release("count");
                }
                return countMessageResponse;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_14 = null;
                    if (mutex == null) break block6;
                    mutex.release("count");
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageConnectCommand(ConnectMessage message) {
        Mutex mutex;
        SessionManager sessionManager;
        block14: {
            this.baseIdentifier = message.getBaseIdentifier();
            sessionManager = null;
            mutex = null;
            mutex = MutexFactory.get(this.baseIdentifier).acquire("commit-close-connect");
            sessionManager = this.getSessionManager(this.baseIdentifier, message.getUser(), message.getPassword(), false);
            if (sessionManager != null) break block14;
            StringBuffer buffer = new StringBuffer();
            buffer.append("Base ").append(this.baseIdentifier).append(" is not registered on this server!");
            ConnectMessageResponse connectMessageResponse = new ConnectMessageResponse(this.baseIdentifier, "?", buffer.toString());
            Object var13_10 = null;
            if (mutex != null) {
                mutex.release("connect");
            }
            if (this.session != null) {
                this.session.endCurrentAction();
            }
            return connectMessageResponse;
        }
        try {
            ConnectMessageResponse cmr;
            String ip = message.getIp();
            long dateTime = message.getDateTime();
            this.session = sessionManager.newSession(ip, dateTime, sessionManager.getNbSessions(), message.isTransactional(), this.server.getConfig());
            this.session.setCurrentAction(0);
            this.session.setUserParameter("user-info", message.getUserInfo());
            SessionEngine engine = this.session.getEngine();
            if (this.debug) {
                DLogger.info(new StringBuffer("Connection from ").append(ip).append(" - cid=").append(this.session.getId()).append(" - session=").append(this.session.getId()).append(" - Base Id=").append(this.baseIdentifier).toString());
            }
            MetaModel metaModel = engine.getSession().getMetaModel();
            OdbArrayList<OidAndBytes> oabs = new OdbArrayList<OidAndBytes>();
            for (ClassInfo ci : metaModel.getAllClasses()) {
                oabs.add(engine.classInfoToBytes(ci));
            }
            ConnectMessageResponse connectMessageResponse = cmr = new ConnectMessageResponse(this.baseIdentifier, this.session.getId(), oabs, this.session.getConfig().getOidGeneratorClass().getName());
            Object var13_11 = null;
            if (mutex != null) {
                mutex.release("connect");
            }
            if (this.session != null) {
                this.session.endCurrentAction();
            }
            return connectMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = this.baseIdentifier + ":Error while connecting to  " + message.getBaseIdentifier();
                DLogger.error(msg, e);
                ConnectMessageResponse connectMessageResponse = new ConnectMessageResponse(this.baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var13_12 = null;
                if (mutex != null) {
                    mutex.release("connect");
                }
                if (this.session != null) {
                    this.session.endCurrentAction();
                }
                return connectMessageResponse;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var13_13 = null;
                    if (mutex != null) {
                        mutex.release("connect");
                    }
                    if (this.session == null) break block15;
                    this.session.endCurrentAction();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageSendFileCommand(SendFileMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        try {
            File f = new File(this.server.getConfig().getInboxDirectory() + "/" + message.getRemoteFileName());
            boolean fileExist = f.exists();
            long size = f.length();
            SendFileMessageResponse sendFileMessageResponse = new SendFileMessageResponse(baseIdentifier, message.getSessionId(), fileExist, size);
            Object var10_11 = null;
            if (mutex != null) {
                mutex.release("File");
            }
            this.session.endCurrentAction();
            return sendFileMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while receiving file";
                DLogger.error(msg, e);
                SendFileMessageResponse sendFileMessageResponse = new SendFileMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var10_12 = null;
                if (mutex != null) {
                    mutex.release("File");
                }
                this.session.endCurrentAction();
                return sendFileMessageResponse;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (mutex != null) {
                    mutex.release("File");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetFileCommand(GetFileMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        Mutex mutex = null;
        try {
            GetFileMessageResponse getFileMessageResponse = new GetFileMessageResponse(baseIdentifier, message.getSessionId(), message.isGetFileInServerInbox(), message.getRemoteFileName(), message.isPutFileInClientInbox(), message.getLocalFileName());
            Object var9_6 = null;
            if (mutex != null) {
                mutex.release("File");
            }
            this.session.endCurrentAction();
            return getFileMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while getting file";
                DLogger.error(msg, e);
                GetFileMessageResponse getFileMessageResponse = new GetFileMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var9_7 = null;
                if (mutex != null) {
                    mutex.release("File");
                }
                this.session.endCurrentAction();
                return getFileMessageResponse;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (mutex != null) {
                    mutex.release("File");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageRemoteProcessCommand(RemoteProcessMessage message) {
        ODBForTrigger odb;
        Mutex mutex;
        String baseIdentifier;
        block9: {
            baseIdentifier = message.getBaseIdentifier();
            mutex = null;
            boolean synchronous = message.isSynchronous();
            odb = new ODBForTrigger(new SessionWrapper(this.session, 11));
            if (!synchronous) break block9;
            RemoteProcess rp = message.getProcess();
            rp.setOdb(odb);
            rp.setServerConfig(this.server.getConfig());
            rp.setClientIp(message.getClientIp());
            RemoteProcessReturn r = rp.execute();
            RemoteProcessMessageResponse remoteProcessMessageResponse = new RemoteProcessMessageResponse(baseIdentifier, message.getSessionId(), r);
            Object var10_14 = null;
            if (mutex != null) {
                mutex.release("File");
            }
            this.session.endCurrentAction();
            return remoteProcessMessageResponse;
        }
        try {
            ThreadToExecuteRemoteProcess t = new ThreadToExecuteRemoteProcess(odb, this.session, message, this.server.getConfig());
            t.start();
            RemoteProcessMessageResponse remoteProcessMessageResponse = new RemoteProcessMessageResponse(baseIdentifier, message.getSessionId(), new AsyncProcessReturn());
            Object var10_15 = null;
            if (mutex != null) {
                mutex.release("File");
            }
            this.session.endCurrentAction();
            return remoteProcessMessageResponse;
        }
        catch (Exception e) {
            try {
                String se = OdbString.exceptionToString(e, false);
                String msg = baseIdentifier + ":Error while executing remote process";
                DLogger.error(msg, e);
                RemoteProcessMessageResponse remoteProcessMessageResponse = new RemoteProcessMessageResponse(baseIdentifier, message.getSessionId(), msg + ":\n" + se);
                Object var10_16 = null;
                if (mutex != null) {
                    mutex.release("File");
                }
                this.session.endCurrentAction();
                return remoteProcessMessageResponse;
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                if (mutex != null) {
                    mutex.release("File");
                }
                this.session.endCurrentAction();
                throw throwable;
            }
        }
    }
}

