/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Query;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeDeletedObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.layers.layer4.IOSocketParameter;
import org.neodatis.odb.core.oid.sequential.CSSequentialOidGeneratorImpl;
import org.neodatis.odb.core.oid.sequential.SequentialOidGeneratorImpl;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.core.query.list.objects.LazySimpleListFromOid;
import org.neodatis.odb.core.query.list.objects.LazySimpleListOfAOI;
import org.neodatis.odb.core.query.list.objects.SimpleList;
import org.neodatis.odb.core.query.values.ValuesCriteriaQuery;
import org.neodatis.odb.core.server.ChangedValueProcessor;
import org.neodatis.odb.core.server.ClientStorageEngine;
import org.neodatis.odb.core.server.MessageStreamer;
import org.neodatis.odb.core.server.ReturnValue;
import org.neodatis.odb.core.server.ReturnValueProcessor;
import org.neodatis.odb.core.server.message.AddIndexMessage;
import org.neodatis.odb.core.server.message.AddIndexMessageResponse;
import org.neodatis.odb.core.server.message.CloseMessage;
import org.neodatis.odb.core.server.message.CloseMessageResponse;
import org.neodatis.odb.core.server.message.CommitMessage;
import org.neodatis.odb.core.server.message.CommitMessageResponse;
import org.neodatis.odb.core.server.message.ConnectMessage;
import org.neodatis.odb.core.server.message.ConnectMessageResponse;
import org.neodatis.odb.core.server.message.CountMessage;
import org.neodatis.odb.core.server.message.CountMessageResponse;
import org.neodatis.odb.core.server.message.DeleteObjectMessage;
import org.neodatis.odb.core.server.message.DeleteObjectMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectFromIdMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectFromOidMessage;
import org.neodatis.odb.core.server.message.GetObjectsMessage;
import org.neodatis.odb.core.server.message.GetObjectsMessageResponse;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.odb.core.server.message.RollbackMessage;
import org.neodatis.odb.core.server.message.RollbackMessageResponse;
import org.neodatis.odb.core.server.message.StoreClassInfoMessage;
import org.neodatis.odb.core.server.message.StoreClassInfoMessageResponse;
import org.neodatis.odb.core.server.message.StoreObjectMessage;
import org.neodatis.odb.core.server.message.StoreObjectMessageResponse;
import org.neodatis.odb.core.session.Cache;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngineImpl;
import org.neodatis.odb.core.session.cross.CacheFactory;
import org.neodatis.odb.core.session.cross.ICrossSessionCache;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.net.NeoDatisIpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSessionEngineImpl
extends SessionEngineImpl {
    protected MessageStreamer messageStreamer;
    protected IOdbList<OidAndBytes> pendingOabsForMetaModelDefinition;
    protected List<ReturnValueProcessor> returnValueProcessors;

    public ClientSessionEngineImpl(Session session) {
        super(session);
    }

    @Override
    protected void initLayer4() {
        IOSocketParameter parameters = null;
        try {
            String localhost = null;
            localhost = NeoDatisIpAddress.get("localhost");
            parameters = (IOSocketParameter)this.session.getBaseIdentification();
            this.messageStreamer = this.session.getConfig().getCoreProvider().getMessageStreamer(parameters.getDestinationHost(), parameters.getPort(), parameters.getBaseId());
            ConnectMessage msg = new ConnectMessage(parameters.getBaseId(), this.session.getId(), localhost, parameters.getUserName(), parameters.getPassword(), parameters.getConfig().isTransactional());
            msg.setUserInfo(this.session.getConfig().getUserInfo());
            ConnectMessageResponse rmsg = (ConnectMessageResponse)this.messageStreamer.sendAndReceive(msg);
            if (rmsg.hasError()) {
                throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while getting a connection from ODB Server").addParameter(rmsg.getError()));
            }
            String oidGeneratorClassName = rmsg.getOidGeneratorClassName();
            if (oidGeneratorClassName.equals(SequentialOidGeneratorImpl.class.getName())) {
                oidGeneratorClassName = CSSequentialOidGeneratorImpl.class.getName();
            }
            this.getSession().getConfig().setOidGeneratorClass(Class.forName(oidGeneratorClassName));
            this.pendingOabsForMetaModelDefinition = rmsg.getOabsOfMetaModel();
            this.session.setId(rmsg.getSessionId());
            this.storageEngine = new ClientStorageEngine(this.session, this.messageStreamer);
        }
        catch (Exception e) {
            String m = "While connecting to server ";
            if (parameters != null) {
                m = m + parameters.getDestinationHost();
            }
            throw new NeoDatisRuntimeException(e, m);
        }
    }

    protected List<ReturnValueProcessor> getReturnValuesProcessors() {
        if (this.returnValueProcessors == null) {
            this.returnValueProcessors = new ArrayList<ReturnValueProcessor>();
            this.returnValueProcessors.add(new ChangedValueProcessor(this.session.getEngine().getObjectIntrospector().getClassIntrospector()));
        }
        return this.returnValueProcessors;
    }

    @Override
    public OidAndBytes layer4ToLayer3(OID oid) {
        if (this.debug) {
            DLogger.debug("<start layer4 to layer3 oid=" + oid.oidToString() + ">");
        }
        OidAndBytes oab = this.storageEngine.read(oid, true);
        if (this.debug) {
            DLogger.debug("<end layer4 to layer3 oid=" + oid.oidToString() + ">");
        }
        return oab;
    }

    @Override
    public void storeClassInfos(ClassInfoList ciList) {
        Collection<ClassInfo> c = ciList.getClassInfos();
        OdbArrayList<OidAndBytes> oidsAndBytes = new OdbArrayList<OidAndBytes>();
        for (ClassInfo ci : c) {
            oidsAndBytes.addAll(this.layer3Writer.classInfoToBytes(ci));
        }
        this.layer3ToLayer4(oidsAndBytes);
    }

    @Override
    public OID layer3ToLayer4(IOdbList<OidAndBytes> oidsAndBytes) {
        OID oid = oidsAndBytes.get((int)0).oid;
        try {
            if (oid instanceof ObjectOid) {
                ObjectOid[] clientIds = new ObjectOid[oidsAndBytes.size()];
                for (int i = 0; i < clientIds.length; ++i) {
                    clientIds[i] = (ObjectOid)oidsAndBytes.get((int)i).oid;
                }
                StoreObjectMessage message = new StoreObjectMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), oidsAndBytes, clientIds);
                StoreObjectMessageResponse rmsg = (StoreObjectMessageResponse)this.messageStreamer.sendAndReceive(message);
                if (rmsg.hasError()) {
                    throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while storing object").addParameter(rmsg.getError()));
                }
                ObjectOid mainOid = this.synchronizeIds(clientIds, rmsg.getServerIds());
                for (ReturnValue rv : rmsg.getReturnValues()) {
                    for (ReturnValueProcessor rvp : this.getReturnValuesProcessors()) {
                        try {
                            rvp.process(rv, this.cache.getObjectWithOid(rv.getObjectOid()));
                        }
                        catch (Exception e) {
                            throw new NeoDatisRuntimeException(NeoDatisError.ERROR_IN_RETURN_VALUE_PROCESSOR.addParameter(rvp.getClass().getName()).addParameter(rv.toString()), (Throwable)e);
                        }
                    }
                }
                return mainOid;
            }
            if (oid instanceof ClassOid) {
                StoreClassInfoMessage message = new StoreClassInfoMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), oidsAndBytes);
                StoreClassInfoMessageResponse rmsg = (StoreClassInfoMessageResponse)this.messageStreamer.sendAndReceive(message);
                if (rmsg.hasError()) {
                    throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while storing classinfo").addParameter(rmsg.getError()));
                }
                return oidsAndBytes.get((int)0).oid;
            }
            throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("unknown Oid type"));
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "Layer3ToLayer4 on client side");
        }
    }

    private ObjectOid synchronizeIds(ObjectOid[] clientIds, ObjectOid[] serverIds) {
        if (clientIds.length != serverIds.length) {
            throw new NeoDatisRuntimeException(NeoDatisError.CLIENT_SERVER_SYNCHRONIZE_IDS.addParameter(serverIds.length).addParameter(clientIds.length));
        }
        Cache cache = this.getSession().getCache();
        ObjectOid clientOid = null;
        ObjectOid serverOid = null;
        Object o = null;
        ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.session.getBaseIdentification().getBaseId());
        for (int i = 0; i < clientIds.length; ++i) {
            clientOid = clientIds[i];
            serverOid = serverIds[i];
            if (serverOid == null || serverOid.isNull() || !clientOid.isNew() && serverOid.equals(clientOid)) continue;
            o = cache.getObjectWithOid(clientOid);
            cache.addObject(serverOid, o);
            if (!this.session.getConfig().reconnectObjectsToSession()) continue;
            crossSessionCache.addObject(o, serverOid);
        }
        ObjectOid mainOid = serverIds[0];
        if (mainOid == null || mainOid.isNull()) {
            mainOid = clientIds[0];
        }
        return mainOid;
    }

    @Override
    public void close() {
        super.close();
        CloseMessage msg = null;
        CloseMessageResponse rmsg = null;
        try {
            msg = new CloseMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId());
            rmsg = (CloseMessageResponse)this.messageStreamer.sendAndReceive(msg);
            this.messageStreamer.close();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "close on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while closing on server side").addParameter(rmsg.getError()));
        }
    }

    @Override
    public void commit() {
        CommitMessage msg = null;
        CommitMessageResponse rmsg = null;
        try {
            msg = new CommitMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId());
            rmsg = (CommitMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "commit on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while committing on server side").addParameter(rmsg.getError()));
        }
    }

    @Override
    public void rollback() {
        RollbackMessage msg = null;
        RollbackMessageResponse rmsg = null;
        try {
            msg = new RollbackMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId());
            rmsg = (RollbackMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "rollback on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while rollbacking on server side").addParameter(rmsg.getError()));
        }
    }

    @Override
    public <T> Objects<T> execute(InternalQuery query) {
        GetObjectsMessageResponse rmsg = null;
        if (query instanceof ValuesCriteriaQuery) {
            throw new NeoDatisRuntimeException(NeoDatisError.VALUES_QUERY_MUST_USE_GET_VALUES);
        }
        GetObjectsMessage msg = new GetObjectsMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), query);
        msg.setInMemory(query.getQueryParameters().isInMemory());
        msg.setStartIndex(query.getQueryParameters().getStartIndex());
        msg.setEndIndex(query.getQueryParameters().getEndIndex());
        try {
            rmsg = (GetObjectsMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "getObjects on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while getting objects on server side").addParameter(rmsg.getError()));
        }
        query.setExecutionPlan(rmsg.getPlan());
        if (rmsg.isOnlyOids()) {
            return new LazySimpleListFromOid<ObjectOid>(this, true, rmsg.getObjectOids(), query.getQueryParameters().getLoadDepth());
        }
        Collection<IOdbList<OidAndBytes>> listOfOabs = rmsg.getListOfOabs();
        if (this.session.getConfig().useLazyInstantiationInServerMode()) {
            LazySimpleListOfAOI oos = new LazySimpleListOfAOI(this.instanceBuilder, true, new InstanceBuilderContext(query.getQueryParameters().getLoadDepth()));
            for (IOdbList<OidAndBytes> oabs : listOfOabs) {
                oos.add(this.layer3ToLayer2(oabs, true, null, query.getQueryParameters().getLoadDepth()));
            }
            return oos;
        }
        SimpleList<Object> oos = new SimpleList<Object>();
        for (IOdbList<OidAndBytes> oabs : listOfOabs) {
            NonNativeObjectInfo nnoi = this.layer3ToLayer2(oabs, true, null, query.getQueryParameters().getLoadDepth());
            Object o = this.layer2ToLayer1(nnoi, new InstanceBuilderContext(true, null, query.getQueryParameters().getLoadDepth()));
            oos.add(o);
        }
        return oos;
    }

    @Override
    public NonNativeObjectInfo getMetaObjectFromOid(ObjectOid oid, boolean throwExceptionIfNotExist, InstanceBuilderContext context) {
        GetObjectFromIdMessageResponse rmsg = null;
        GetObjectFromOidMessage msg = new GetObjectFromOidMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), oid, context.depth);
        try {
            rmsg = (GetObjectFromIdMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "getObjectFromId on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while getting object from id on server side").addParameter(rmsg.getError()));
        }
        if (rmsg.getOabs() == null) {
            if (throwExceptionIfNotExist) {
                throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST.addParameter(oid.oidToString()));
            }
            return new NonNativeDeletedObjectInfo(oid);
        }
        NonNativeObjectInfo nnoi = this.layer3ToLayer2(rmsg.getOabs(), true, null, context.depth);
        return nnoi;
    }

    @Override
    public <T> Objects<T> getMetaObjects(InternalQuery query) {
        GetObjectsMessageResponse rmsg = null;
        if (query instanceof ValuesCriteriaQuery) {
            throw new NeoDatisRuntimeException(NeoDatisError.VALUES_QUERY_MUST_USE_GET_VALUES);
        }
        GetObjectsMessage msg = new GetObjectsMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), query);
        msg.setInMemory(query.getQueryParameters().isInMemory());
        msg.setStartIndex(query.getQueryParameters().getStartIndex());
        msg.setEndIndex(query.getQueryParameters().getEndIndex());
        try {
            rmsg = (GetObjectsMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "getObjects on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while getting objects on server side").addParameter(rmsg.getError()));
        }
        query.setExecutionPlan(rmsg.getPlan());
        if (rmsg.isOnlyOids()) {
            return new LazySimpleListFromOid<ObjectOid>(this, false, rmsg.getObjectOids(), query.getQueryParameters().getLoadDepth());
        }
        Collection<IOdbList<OidAndBytes>> listOfOabs = rmsg.getListOfOabs();
        LazySimpleListOfAOI oos = new LazySimpleListOfAOI(this.instanceBuilder, false, new InstanceBuilderContext(query.getQueryParameters().getLoadDepth()));
        for (IOdbList<OidAndBytes> oabs : listOfOabs) {
            oos.add(this.layer3ToLayer2(oabs, true, null, query.getQueryParameters().getLoadDepth()));
        }
        return oos;
    }

    @Override
    public MetaModel loadMetaModel(MetaModel metaModel) {
        ClassInfo ci;
        for (OidAndBytes oab : this.pendingOabsForMetaModelDefinition) {
            ci = this.classInfoFromBytes(oab, false);
            metaModel.addClass(ci, false);
        }
        for (OidAndBytes oab : this.pendingOabsForMetaModelDefinition) {
            ci = this.classInfoFromBytes(oab, true);
            metaModel.getClassInfoFromId(ci.getOid()).setAttributes(ci.getAttributes());
        }
        this.session.setMetaModel(metaModel);
        return metaModel;
    }

    @Override
    protected void internalDeleteObjectWithOid(ObjectOid oid, boolean cascade, boolean callTriggerAndIndex) {
        DeleteObjectMessage msg = new DeleteObjectMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), oid, cascade);
        DeleteObjectMessageResponse rmsg = null;
        try {
            rmsg = (DeleteObjectMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "Layer3ToLayer4 on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while deleting object with OID " + oid.oidToString()).addParameter(rmsg.getError()));
        }
        this.cache.remove(oid);
        if (callTriggerAndIndex) {
            boolean withIndex;
            ClassInfo ci = this.session.getMetaModel().getClassInfoFromId(oid.getClassOid());
            boolean bl = withIndex = !ci.getIndexes().isEmpty();
            if (withIndex) {
                NonNativeObjectInfo nnoi = this.getMetaObjectFromOid(oid, true, new InstanceBuilderContext(true, null, 1));
                this.indexManager.manageIndexesForDelete(oid, nnoi);
            }
            this.triggerManager.manageDeleteTriggerAfter(this.session.getMetaModel().getClassInfoFromId(oid.getClassOid()).getFullClassName(), null, oid);
        }
    }

    @Override
    public BigInteger count(Query query) {
        this.checkClose();
        if (!(query instanceof CriteriaQuery)) {
            throw new NeoDatisRuntimeException("count only works with Criteria queries for instance :-(");
        }
        CountMessage msg = new CountMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), (CriteriaQuery)query);
        CountMessageResponse rmsg = null;
        try {
            rmsg = (CountMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "count on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while count objects").addParameter(rmsg.getError()));
        }
        return rmsg.getNbObjects();
    }

    @Override
    public void addIndexOn(String className, String indexName, String[] indexFields, boolean verbose, boolean acceptMultipleValuesForSameKey) {
        this.checkClose();
        AddIndexMessage msg = new AddIndexMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId(), className, indexName, indexFields, acceptMultipleValuesForSameKey, verbose);
        AddIndexMessageResponse rmsg = null;
        try {
            rmsg = (AddIndexMessageResponse)this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "addIndex on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while adding index " + indexName).addParameter(rmsg.getError()));
        }
    }

    @Override
    public Message sendMessage(Message msg) {
        this.checkClose();
        Message rmsg = null;
        if (msg.getBaseIdentifier() == null) {
            msg.setBaseIdentifier(this.session.getBaseIdentification().getBaseId());
            msg.setSessionId(this.session.getId());
        }
        try {
            rmsg = this.messageStreamer.sendAndReceive(msg);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "sendMessage on client side");
        }
        if (rmsg.hasError()) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_SIDE_ERROR.addParameter("Error while sending message " + msg.getClass().getName()).addParameter(rmsg.getError()));
        }
        return rmsg;
    }
}

