/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.refactor;

import org.neodatis.odb.core.layers.layer2.instance.ClassPool;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.refactor.ClassInfoCompareResult;
import org.neodatis.tool.wrappers.list.OdbArrayList;

public class ClassInfoComparator {
    public ClassInfoCompareResult compare(ClassInfo ci1, ClassInfo ci2, boolean update, ClassPool classPool) {
        String attributeName = null;
        ClassAttributeInfo cai1 = null;
        ClassAttributeInfo cai2 = null;
        ClassInfoCompareResult result = new ClassInfoCompareResult(ci1.getFullClassName(), ci1, ci2);
        boolean isCompatible = true;
        OdbArrayList<ClassAttributeInfo> attributesToRemove = new OdbArrayList<ClassAttributeInfo>(10);
        OdbArrayList<ClassAttributeInfo> attributesToAdd = new OdbArrayList<ClassAttributeInfo>(10);
        int nbAttributes = ci1.getAttributes().size();
        for (int id = 0; id < nbAttributes; ++id) {
            cai1 = ci1.getAttributes().get(id);
            if (cai1 == null) continue;
            attributeName = cai1.getName();
            cai2 = ci2.getAttributeInfoFromId(cai1.getId());
            if (cai2 == null) {
                result.addCompatibleChange("Field '" + attributeName + "' has been removed");
                if (!update) continue;
                attributesToRemove.add(cai1);
                continue;
            }
            if (ODBType.typesAreCompatible(cai1.getAttributeType(), cai2.getAttributeType(), classPool)) continue;
            result.addIncompatibleChange("Type of Field '" + attributeName + "' has changed : old='" + cai1.getClassName() + "' - new='" + cai2.getClassName() + "'");
            isCompatible = false;
        }
        int nbNewAttributes = ci2.getAttributes().size();
        for (int id = 0; id < nbNewAttributes; ++id) {
            cai2 = ci2.getAttributes().get(id);
            if (cai2 == null) continue;
            attributeName = cai2.getName();
            cai1 = ci1.getAttributeInfoFromId(cai2.getId());
            if (cai1 != null) continue;
            result.addCompatibleChange("Field '" + attributeName + "' has been added");
            if (!update) continue;
            cai2.setId(ci1.getMaxAttributeId() + 1);
            ci1.setMaxAttributeId(ci1.getMaxAttributeId() + 1);
            attributesToAdd.add(cai2);
        }
        ci1.getAttributes().removeAll(attributesToRemove);
        ci1.getAttributes().addAll(attributesToAdd);
        ci1.fillAttributesMap();
        return result;
    }
}

