/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query;

import java.math.BigInteger;
import org.neodatis.OrderByConstants;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Query;
import org.neodatis.odb.QueryParameters;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.query.IQueryExecutionPlan;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.tool.wrappers.OdbString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery
implements InternalQuery {
    protected String[] orderByFields;
    protected OrderByConstants orderByType = OrderByConstants.ORDER_BY_NONE;
    protected transient SessionEngine engine;
    protected IQueryExecutionPlan executionPlan;
    protected boolean polymorphic = false;
    private boolean optimizeObjectComparison = true;
    protected ObjectOid oidOfObjectToQuery;
    protected QueryParameters queryParameters = new QueryParameters();

    @Override
    public Query orderByDesc(String fields) {
        this.orderByType = OrderByConstants.ORDER_BY_DESC;
        this.orderByFields = OdbString.split(fields, ",");
        return this;
    }

    @Override
    public Query orderByAsc(String fields) {
        this.orderByType = OrderByConstants.ORDER_BY_ASC;
        this.orderByFields = OdbString.split(fields, ",");
        return this;
    }

    @Override
    public String[] getOrderByFieldNames() {
        return this.orderByFields;
    }

    public void setOrderByFields(String[] orderByFields) {
        this.orderByFields = orderByFields;
    }

    @Override
    public OrderByConstants getOrderByType() {
        return this.orderByType;
    }

    public void setOrderByType(OrderByConstants orderByType) {
        this.orderByType = orderByType;
    }

    @Override
    public boolean hasOrderBy() {
        return !this.orderByType.isOrderByNone();
    }

    @Override
    public SessionEngine getSessionEngine() {
        return this.engine;
    }

    @Override
    public void setSessionEngine(SessionEngine engine) {
        this.engine = engine;
    }

    @Override
    public IQueryExecutionPlan getExecutionPlan() {
        if (this.executionPlan == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.EXECUTION_PLAN_IS_NULL_QUERY_HAS_NOT_BEEN_EXECUTED);
        }
        return this.executionPlan;
    }

    @Override
    public void setExecutionPlan(IQueryExecutionPlan plan) {
        this.executionPlan = plan;
    }

    @Override
    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    @Override
    public Query setPolymorphic(boolean yes) {
        this.polymorphic = yes;
        return this;
    }

    @Override
    public ObjectOid getOidOfObjectToQuery() {
        return this.oidOfObjectToQuery;
    }

    public void setOidOfObjectToQuery(ObjectOid oidOfObjectToQuery) {
        this.oidOfObjectToQuery = oidOfObjectToQuery;
    }

    @Override
    public boolean isForSingleOid() {
        return this.oidOfObjectToQuery != null;
    }

    @Override
    public boolean optimizeObjectComparison() {
        return this.optimizeObjectComparison;
    }

    @Override
    public Query setOptimizeObjectComparison(boolean yesNo) {
        this.optimizeObjectComparison = yesNo;
        return this;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public <T> Objects<T> objects() {
        return this.engine.execute(this);
    }

    @Override
    public BigInteger count() {
        return this.engine.count(this);
    }
}

