/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.oid.uuid;

import java.util.UUID;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.odb.core.oid.uuid.OIDImpl;

public class ClassOidImpl
extends OIDImpl
implements ClassOid {
    protected static DataConverter converter = new DataConverterImpl(false, null, NeoDatis.getConfig());
    protected UUID uuid;

    public ClassOidImpl() {
    }

    public ClassOidImpl(UUID uuid) {
        this.uuid = uuid;
    }

    public int getType() {
        return 3;
    }

    public String toString() {
        return this.oidToString();
    }

    public String oidToString() {
        if (this.isNull()) {
            return "__null__";
        }
        return this.uuid.toString();
    }

    public byte[] toByte() {
        long l = 0L;
        long m = 0L;
        byte[] b = new byte[16];
        if (this.uuid != null) {
            l = this.uuid.getLeastSignificantBits();
            m = this.uuid.getMostSignificantBits();
        }
        converter.longToByteArray(l, b, 0, "least");
        converter.longToByteArray(m, b, 8, "most");
        return b;
    }

    public boolean isNull() {
        return this.uuid == null;
    }

    public int hashCode() {
        if (this.uuid == null) {
            return -1;
        }
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassOidImpl)) {
            return false;
        }
        if (this.uuid == null || obj == null) {
            return false;
        }
        ClassOidImpl uuid2 = (ClassOidImpl)obj;
        return this.uuid.equals(uuid2.uuid);
    }

    public static ClassOid classOidfromString(String s) {
        UUID classUuid = UUID.fromString(s);
        return new ClassOidImpl(classUuid);
    }
}

