/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.oid.sequential;

import org.neodatis.odb.OID;
import org.neodatis.odb.core.oid.StringOid;
import org.neodatis.odb.core.oid.sequential.OIDImpl;

public class StringOidImpl
extends OIDImpl
implements StringOid {
    protected String s;

    public StringOidImpl(String s) {
        super(10);
        this.s = s;
    }

    public StringOidImpl(String prefix, OID oid) {
        super(10);
        this.s = new StringBuffer(prefix).append("-").append(oid.oidToString()).toString();
    }

    public String oidToString() {
        return new StringBuilder(15).append(this.type).append(".").append(this.s).toString();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof StringOidImpl)) {
            return -1000;
        }
        StringOidImpl so = (StringOidImpl)o;
        return this.s.compareTo(so.s);
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    public static OID oidFromString(String s) {
        String realString = s.substring(3);
        return new StringOidImpl(realString);
    }

    public boolean isNull() {
        return this.s == null || this.s.length() == 0;
    }

    public byte[] toByte() {
        return this.s.getBytes();
    }
}

