/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.oid.sequential;

import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.odb.core.oid.sequential.OIDImpl;

public class ClassOidImpl
extends OIDImpl
implements ClassOid {
    protected long classId;
    protected String full;
    protected static DataConverter converter = new DataConverterImpl(false, null, NeoDatis.getConfig());

    public ClassOidImpl(long classId) {
        super(3);
        this.classId = classId;
    }

    public String toString() {
        return this.oidToString();
    }

    public String oidToString() {
        if (this.full == null) {
            this.full = new StringBuilder(10).append(this.type).append(".").append(this.classId).toString();
        }
        return this.full;
    }

    public static ClassOid oidFromString(String s) {
        String[] tokens = s.split("\\.");
        if (tokens.length != 2) {
            throw new NeoDatisRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(s));
        }
        int type = Integer.parseInt(tokens[0]);
        if (type != 3) {
            throw new NeoDatisRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(s));
        }
        long classId = Long.parseLong(tokens[1]);
        return new ClassOidImpl(classId);
    }

    public long getId() {
        return this.classId;
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof ClassOidImpl)) {
            return -1000;
        }
        ClassOidImpl coi = (ClassOidImpl)obj;
        return (int)(this.classId - coi.classId) % Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassOidImpl)) {
            return false;
        }
        ClassOidImpl coi = (ClassOidImpl)obj;
        return this.classId == coi.classId;
    }

    public int hashCode() {
        return (int)(this.classId ^ this.classId >>> 32);
    }

    public boolean isNull() {
        return this.classId == -1L;
    }

    public byte[] toByte() {
        byte[] b = new byte[8];
        converter.longToByteArray(this.classId, b, 0, "coid");
        return b;
    }
}

