/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer4.plugin.jdbm;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.RecordManagerOptions;
import jdbm.helper.FastIterator;
import jdbm.htree.HTree;
import org.neodatis.odb.NeoDatisRuntimeException;

public class PHashMap {
    protected RecordManager recordManager;
    protected HTree hashtable;

    public PHashMap(String fileName) throws IOException {
        RecordManagerOptions.FILE_EXTENSION = "";
        Properties props = new Properties();
        props.setProperty("jdbm.disableTransactions", "TRUE");
        props.setProperty("jdbm.disableTransactions.syncOnClose", "TRUE");
        props.setProperty("none", "TRUE");
        File f = new File(fileName);
        if (!f.exists()) {
            f.createNewFile();
        }
        if (f.exists() && f.isDirectory()) {
            throw new NeoDatisRuntimeException(fileName + " is a directory, it must be a file");
        }
        this.recordManager = RecordManagerFactory.createRecordManager(fileName, props);
        long recid = this.recordManager.getNamedObject("objects");
        if (recid != 0L) {
            this.hashtable = HTree.load(this.recordManager, recid);
        } else {
            this.hashtable = HTree.createInstance(this.recordManager);
            this.recordManager.setNamedObject("objects", this.hashtable.getRecid());
        }
    }

    public void put(Object key, Object value) throws IOException {
        this.hashtable.put(key, value);
    }

    public Object get(Object key) throws IOException {
        return this.hashtable.get(key);
    }

    public void commit() throws IOException {
        this.recordManager.commit();
    }

    public void rollback() throws IOException {
        this.recordManager.rollback();
    }

    public FastIterator keys() throws IOException {
        return this.hashtable.keys();
    }

    public void remove(Object key) throws IOException {
        this.hashtable.remove(key);
    }

    public boolean containsKey(Object key) throws IOException {
        return this.hashtable.get(key) != null;
    }

    public void close() throws IOException {
        this.recordManager.close();
    }
}

