/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.odb.core.layers.layer3.ReadSize;

public class BytesHelper {
    protected Bytes bytes;
    protected DataConverter converter;
    protected ReadSize internalReadSize;

    public BytesHelper(Bytes bytes, boolean debug, String characterEncoding, NeoDatisConfig config) {
        this.bytes = bytes;
        this.converter = new DataConverterImpl(debug, characterEncoding, config);
        this.internalReadSize = new ReadSize();
    }

    public BytesHelper(Bytes bytes, boolean debug, NeoDatisConfig config) {
        this.bytes = bytes;
        this.converter = new DataConverterImpl(debug, null, config);
        this.internalReadSize = new ReadSize();
    }

    public BytesHelper(Bytes bytes, NeoDatisConfig config) {
        this.bytes = bytes;
        this.converter = new DataConverterImpl(false, null, config);
        this.internalReadSize = new ReadSize();
    }

    public void resetReadSize() {
        this.internalReadSize = new ReadSize();
    }

    public ReadSize getReadSize() {
        return this.internalReadSize;
    }

    public int writeBigDecimal(BigDecimal bigDecimal, int offset, String label) {
        return this.converter.bigDecimalToByteArray(bigDecimal, this.bytes, offset, label);
    }

    public int writeBigInteger(BigInteger bigInteger, int offset, String label) {
        return this.converter.bigIntegerToByteArray(bigInteger, this.bytes, offset, label);
    }

    public int writeBoolean(boolean b, int offset, String label) {
        return this.converter.booleanToByteArray(b, this.bytes, offset, label);
    }

    public BigDecimal readbigDecimal(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToBigDecimal(this.bytes, offset, readSize, label);
    }

    public BigDecimal readbigDecimal(int offset) {
        return this.converter.byteArrayToBigDecimal(this.bytes, offset, this.internalReadSize, "");
    }

    public BigInteger readBigInteger(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToBigInteger(this.bytes, offset, readSize, label);
    }

    public BigInteger readBigInteger(int offset) {
        return this.converter.byteArrayToBigInteger(this.bytes, offset, this.internalReadSize, "");
    }

    public boolean readBoolean(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToBoolean(this.bytes, offset, readSize, label);
    }

    public boolean readBoolean(int offset) {
        return this.converter.byteArrayToBoolean(this.bytes, offset, this.internalReadSize, "");
    }

    public byte readByte(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToByte(this.bytes, offset, readSize, label);
    }

    public byte readByte(int offset) {
        return this.converter.byteArrayToByte(this.bytes, offset, this.internalReadSize, "");
    }

    public char readChar(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToChar(this.bytes, offset, readSize, label);
    }

    public char readChar(int offset) {
        return this.converter.byteArrayToChar(this.bytes, offset, this.internalReadSize, "");
    }

    public ClassOid readClassOid(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToClassOid(this.bytes, offset, readSize, label);
    }

    public ClassOid readClassOid(int offset) {
        return this.converter.byteArrayToClassOid(this.bytes, offset, this.internalReadSize, "");
    }

    public Date readDate(int offset) {
        return this.converter.byteArrayToDate(this.bytes, offset, this.internalReadSize, "");
    }

    public Date readDate(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToDate(this.bytes, offset, readSize, label);
    }

    public double readDouble(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToDouble(this.bytes, offset, readSize, label);
    }

    public double readDouble(int offset) {
        return this.converter.byteArrayToDouble(this.bytes, offset, this.internalReadSize, "");
    }

    public float readFloat(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToFloat(this.bytes, offset, readSize, label);
    }

    public float readFloat(int offset) {
        return this.converter.byteArrayToFloat(this.bytes, offset, this.internalReadSize, "");
    }

    public int readInt(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToInt(this.bytes, offset, readSize, label);
    }

    public int readInt(int offset) {
        return this.converter.byteArrayToInt(this.bytes, offset, this.internalReadSize, "");
    }

    public long readLong(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToLong(this.bytes, offset, readSize, label);
    }

    public long readLong(int offset) {
        return this.converter.byteArrayToLong(this.bytes, offset, this.internalReadSize, "");
    }

    public ObjectOid readObjectoid(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToObjectOid(this.bytes, offset, readSize, label);
    }

    public ObjectOid readObjectoid(int offset) {
        return this.converter.byteArrayToObjectOid(this.bytes, offset, this.internalReadSize, "");
    }

    public short readShort(int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToShort(this.bytes, offset, readSize, label);
    }

    public short readShort(int offset) {
        return this.converter.byteArrayToShort(this.bytes, offset, this.internalReadSize, "");
    }

    public String readString(boolean useEncoding, int offset, ReadSize readSize, String label) {
        return this.converter.byteArrayToString(this.bytes, useEncoding, offset, readSize, label);
    }

    public String readString(boolean useEncoding, int offset) {
        return this.converter.byteArrayToString(this.bytes, useEncoding, offset, this.internalReadSize, "");
    }

    public int writeByte(byte b, int offset, String label) {
        return this.converter.byteToByteArray(b, this.bytes, offset, label);
    }

    public int writeChar(char c, int offset, String label) {
        return this.converter.charToByteArray(c, this.bytes, offset, label);
    }

    public int writeClassOid(ClassOid coid, int offset, String label) {
        return this.converter.classOidToByteArray(coid, this.bytes, offset, label);
    }

    public int writeDate(Date date, int offset, String label) {
        return this.converter.dateToByteArray(date, this.bytes, offset, label);
    }

    public int writeDouble(double d, int offset, String label) {
        return this.converter.doubleToByteArray(d, this.bytes, offset, label);
    }

    public int writeFloat(float f, int offset, String label) {
        return this.converter.floatToByteArray(f, this.bytes, offset, label);
    }

    public int writeInt(int l, int offset, String label) {
        return this.converter.intToByteArray(l, this.bytes, offset, label);
    }

    public int writeLong(long l, int offset, String label) {
        return this.converter.longToByteArray(l, this.bytes, offset, label);
    }

    public int writeObjectOid(ObjectOid ooid, int offset, String label) {
        return this.converter.objectOidToByteArray(ooid, this.bytes, offset, label);
    }

    public int writeShort(short s, int offset, String lable) {
        return this.converter.shortToByteArray(s, this.bytes, offset, lable);
    }

    public int writeString(String s, boolean withEncoding, int offset, String label) {
        return this.converter.stringToByteArray(s, withEncoding, this.bytes, offset, label);
    }

    public Bytes getBytes() {
        return this.bytes;
    }

    public int writeBytes(Bytes bytes2Copy, int offset, String label) {
        this.bytes.set(offset, bytes2Copy.getByteArray());
        return bytes2Copy.getRealSize();
    }

    public Bytes readBytes(int offset, int size, ReadSize readSize, String string) {
        byte[] nbytes = this.bytes.extract(offset, size);
        readSize.add(size);
        return BytesFactory.getBytes(nbytes);
    }

    public int appendByteArray(byte[] b, int size) {
        byte[] b2 = b;
        if (size != b.length) {
            b2 = new byte[size];
            System.arraycopy(b, 0, b2, 0, size);
        }
        this.bytes.append(b2);
        return this.bytes.getRealSize();
    }
}

