/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.instance;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neodatis.odb.NeoDatisObject;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.context.NeoDatisContextImpl;
import org.neodatis.odb.core.layers.layer1.ClassIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.ClassPool;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilder;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.LazyObjectReference;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.session.Cache;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.cross.CacheFactory;
import org.neodatis.odb.core.session.cross.ICrossSessionCache;
import org.neodatis.odb.core.trigger.TriggerManager;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class InstanceBuilderImpl
implements InstanceBuilder {
    private static final String LOG_ID = "InstanceBuilder";
    private static final String LOG_ID_DEBUG = "InstanceBuilder.debug";
    private TriggerManager triggerManager;
    private ClassIntrospector classIntrospector;
    private ClassPool classPool;
    protected Session session;
    private Map<OID, Object> localCache;

    public InstanceBuilderImpl(Session session, ClassIntrospector classIntrospector, TriggerManager triggerManager) {
        this.session = session;
        this.triggerManager = triggerManager;
        this.classIntrospector = classIntrospector;
        this.classPool = classIntrospector.getClassPool();
        this.localCache = new OdbHashMap<OID, Object>(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildOneInstance(NonNativeObjectInfo objectInfo, InstanceBuilderContext context) {
        try {
            Object object = this.internalBuildOneInstance(objectInfo, context, 1);
            return object;
        }
        finally {
            this.localCache.clear();
        }
    }

    protected Object internalBuildOneInstance(AbstractObjectInfo objectInfo, InstanceBuilderContext context, int depth) {
        Object object = null;
        if (objectInfo instanceof NonNativeNullObjectInfo) {
            return null;
        }
        object = objectInfo.isNonNativeObject() ? this.internalBuildOneInstance((NonNativeObjectInfo)objectInfo, context, depth) : this.internalBuildOneInstance((NativeObjectInfo)objectInfo, null, context, depth);
        return object;
    }

    protected Object internalBuildCollectionInstance(CollectionObjectInfo coi, InstanceBuilderContext context, int depth) {
        Collection newCollection = null;
        try {
            newCollection = (Collection)this.classPool.getClass(coi.getRealCollectionClassName()).newInstance();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.COLLECTION_INSTANCIATION_ERROR.addParameter(coi.getRealCollectionClassName()), (Throwable)e);
        }
        Iterator<AbstractObjectInfo> iterator = coi.getCollection().iterator();
        AbstractObjectInfo aoi = null;
        while (iterator.hasNext()) {
            aoi = iterator.next();
            if (aoi.isDeletedObject()) continue;
            newCollection.add(this.internalBuildOneInstance(aoi, context, depth));
        }
        return newCollection;
    }

    protected Object internalBuildEnumInstance(EnumNativeObjectInfo enoi) {
        String className = this.session.getMetaModel().getClassInfoFromId(enoi.getEnumClassOid()).getFullClassName();
        Class clazz = this.classPool.getClass(className);
        Object theEnum = Enum.valueOf(clazz, enoi.getEnumName());
        return theEnum;
    }

    protected Object internalBuildArrayInstance(ArrayObjectInfo aoi, InstanceBuilderContext context, int depth) {
        ODBType type = ODBType.getFromName(aoi.getRealArrayComponentClassName());
        Class arrayClazz = type.getNativeClass(this.classPool);
        Object array = Array.newInstance(arrayClazz, aoi.getArray().length);
        Object object = null;
        AbstractObjectInfo aboi = null;
        for (int i = 0; i < aoi.getArrayLength(); ++i) {
            aboi = aoi.getArray()[i];
            if (aboi == null || aboi.isDeletedObject() || aboi.isNull()) continue;
            object = this.internalBuildOneInstance(aboi, context, depth);
            Array.set(array, i, object);
        }
        return array;
    }

    protected Map internalBuildMapInstance(MapObjectInfo mapObjectInfo, InstanceBuilderContext context, int depth) {
        Map newMap;
        Map<AbstractObjectInfo, AbstractObjectInfo> map = mapObjectInfo.getMap();
        try {
            newMap = (Map)this.classPool.getClass(mapObjectInfo.getRealMapClassName()).newInstance();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.MAP_INSTANCIATION_ERROR.addParameter(map.getClass().getName()));
        }
        Iterator<AbstractObjectInfo> iterator = map.keySet().iterator();
        AbstractObjectInfo key = null;
        while (iterator.hasNext()) {
            key = iterator.next();
            Object realKey = this.internalBuildOneInstance(key, context, depth);
            Object realValue = this.internalBuildOneInstance(map.get(key), context, depth);
            newMap.put(realKey, realValue);
        }
        return newMap;
    }

    protected Object internalBuildOneInstance(NonNativeObjectInfo objectInfo, InstanceBuilderContext context, int depth) {
        Cache cache = this.session.getCache();
        if (objectInfo.isDeletedObject()) {
            throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_IS_MARKED_AS_DELETED_FOR_OID.addParameter(objectInfo.getOid()));
        }
        Object o = null;
        if (context.useCache) {
            o = cache.getObjectWithOid(objectInfo.getOid());
            if (o != null) {
                return o;
            }
            o = this.localCache.get(objectInfo.getOid());
            if (o != null) {
                return o;
            }
        }
        Class instanceClazz = null;
        String className = objectInfo.getClassInfo().getFullClassName();
        instanceClazz = this.classPool.getClass(className);
        if (context.existingObject == null) {
            try {
                o = this.classIntrospector.newInstanceOf(instanceClazz);
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.INSTANCIATION_ERROR.addParameter(className), (Throwable)e);
            }
        } else {
            o = context.existingObject;
        }
        if (o == null) {
            return null;
        }
        this.localCache.put(objectInfo.getOid(), o);
        if (o instanceof NeoDatisObject && this.session.getConfig().reconnectObjectsToSession()) {
            NeoDatisObject no = (NeoDatisObject)o;
            no.setNeoDatisContext(new NeoDatisContextImpl(objectInfo.getOid()));
        }
        if (objectInfo instanceof LazyObjectReference) {
            cache.addObject(objectInfo.getOid(), o);
            return o;
        }
        ClassInfo ci = objectInfo.getClassInfo();
        IOdbList<Field> fields = this.classIntrospector.getAllFields(className);
        Field field = null;
        AbstractObjectInfo aoi = null;
        Object value = null;
        for (int i = 0; i < fields.size(); ++i) {
            field = (Field)fields.get(i);
            int attributeId = ci.getAttributeId(field.getName());
            if (attributeId == -1) {
                throw new NeoDatisRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(ci.getFullClassName()).addParameter(field.getName()));
            }
            aoi = objectInfo.getAttributeValueFromId(attributeId);
            if (aoi == null || aoi.isNull()) continue;
            if (aoi.isNative()) {
                value = this.internalBuildOneInstance((NativeObjectInfo)aoi, field.getType(), context, depth);
            } else if (aoi.isNonNativeObject()) {
                if (aoi.isDeletedObject()) {
                    if (this.session.getConfig().displayWarnings()) {
                        IError warning = NeoDatisError.ATTRIBUTE_REFERENCES_A_DELETED_OBJECT.addParameter(className).addParameter(objectInfo.getOid()).addParameter(field.getName());
                        DLogger.info(warning.toString());
                    }
                    value = null;
                } else {
                    value = this.internalBuildOneInstance((NonNativeObjectInfo)aoi, context, depth + 1);
                }
            }
            if (value == null) continue;
            try {
                field.set(o, value);
                continue;
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.INSTANCE_BUILDER_WRONG_OBJECT_CONTAINER_TYPE.addParameter(objectInfo.getClassInfo().getFullClassName()).addParameter(value.getClass().getName()).addParameter(field.getType().getName()).addParameter(field.getName()), (Throwable)e);
            }
        }
        if (o != null && !o.getClass().getName().equals(objectInfo.getClassInfo().getFullClassName())) {
            new NeoDatisRuntimeException(NeoDatisError.INSTANCE_BUILDER_WRONG_OBJECT_TYPE.addParameter(objectInfo.getClassInfo().getFullClassName()).addParameter(o.getClass().getName()));
        }
        cache.addObject(objectInfo.getOid(), o);
        if (this.triggerManager != null) {
            this.triggerManager.manageSelectTriggerAfter(objectInfo.getClassInfo().getFullClassName(), objectInfo, objectInfo.getOid());
        }
        if (this.session.getConfig().reconnectObjectsToSession()) {
            ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.session.getBaseIdentification().getBaseId());
            crossSessionCache.addObject(o, objectInfo.getOid());
        }
        return o;
    }

    protected Object internalBuildOneInstance(NativeObjectInfo objectInfo, Class fieldType, InstanceBuilderContext context, int depth) {
        if (objectInfo.isNull()) {
            return null;
        }
        if (objectInfo.isAtomicNativeObject()) {
            return objectInfo.getObject();
        }
        if (objectInfo.isCollectionObject()) {
            HashSet value = this.internalBuildCollectionInstance((CollectionObjectInfo)objectInfo, context, depth);
            if (fieldType == null) {
                fieldType = objectInfo.getObject().getClass();
            }
            if (Set.class.isAssignableFrom(fieldType) && Collection.class.isAssignableFrom(value.getClass())) {
                HashSet s = new HashSet();
                s.addAll(value);
                value = s;
            }
            return value;
        }
        if (objectInfo.isArrayObject()) {
            return this.internalBuildArrayInstance((ArrayObjectInfo)objectInfo, context, depth);
        }
        if (objectInfo.isMapObject()) {
            return this.internalBuildMapInstance((MapObjectInfo)objectInfo, context, depth);
        }
        if (objectInfo.isEnumObject()) {
            EnumNativeObjectInfo enoi = (EnumNativeObjectInfo)objectInfo;
            return this.internalBuildEnumInstance((EnumNativeObjectInfo)objectInfo);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.INSTANCE_BUILDER_NATIVE_TYPE.addParameter(ODBType.getNameFromId(objectInfo.getOdbTypeId())));
    }

    public String getSessionId() {
        return this.session.getId();
    }

    public boolean isLocal() {
        return this.session.isLocal();
    }
}

