/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer1;

import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.context.ObjectReconnector;
import org.neodatis.odb.core.layers.layer1.IntrospectionCallback;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.cross.CacheFactory;
import org.neodatis.odb.core.session.cross.ICrossSessionCache;
import org.neodatis.odb.core.trigger.TriggerManager;

public class DefaultInstrospectionCallbackForStore
implements IntrospectionCallback {
    protected TriggerManager triggerManager;
    protected ICrossSessionCache crossSessionCache;
    protected Session session;
    protected ObjectReconnector objectReconnector;

    public DefaultInstrospectionCallbackForStore(Session session, TriggerManager triggerManager) {
        this.session = session;
        this.triggerManager = triggerManager;
        if (session != null) {
            this.crossSessionCache = CacheFactory.getCrossSessionCache(session.getBaseIdentification().toString());
        }
        if (session.getConfig().reconnectObjectsToSession()) {
            this.objectReconnector = new ObjectReconnector();
        }
    }

    public boolean objectFound(Object object, ObjectOid oid) {
        boolean isUpdate;
        boolean bl = isUpdate = !oid.isNew();
        if (this.session.getConfig().reconnectObjectsToSession()) {
            isUpdate = this.checkIfObjectMustBeReconnected(object);
        }
        if (!isUpdate) {
            if (this.triggerManager != null) {
                this.triggerManager.manageInsertTriggerBefore(object.getClass().getName(), object);
            }
        } else if (this.triggerManager != null) {
            this.triggerManager.manageUpdateTriggerBefore(object.getClass().getName(), null, object, null);
        }
        if (this.objectReconnector != null) {
            this.objectReconnector.tryToAttachNeoDatisContext(object, oid);
        }
        return true;
    }

    private boolean checkIfObjectMustBeReconnected(Object o) {
        if (this.session == null) {
            return false;
        }
        if (this.session.getCache().existObject(o)) {
            return true;
        }
        OID oidCrossSession = this.crossSessionCache.getOid(o);
        if (oidCrossSession != null) {
            ObjectInfoHeader oih = this.session.getObjectInfoHeaderFromOid(oidCrossSession, true);
            this.session.addObjectToCache(oidCrossSession, o, oih);
            return true;
        }
        return false;
    }
}

