/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.NeoDatisEventType;
import org.neodatis.odb.core.event.EventManager;
import org.neodatis.odb.core.event.EventResult;
import org.neodatis.odb.core.event.NeoDatisEvent;
import org.neodatis.odb.core.event.NeoDatisEventListener;

public class EventManagerImpl
implements EventManager {
    protected Map<NeoDatisEventType, List<NeoDatisEventListener>> eventListeners = new HashMap<NeoDatisEventType, List<NeoDatisEventListener>>();

    public void addEventListener(NeoDatisEventType neoDatisEventType, NeoDatisEventListener eventListener) {
        List<NeoDatisEventListener> listeners = this.eventListeners.get(neoDatisEventType);
        if (listeners == null) {
            listeners = new ArrayList<NeoDatisEventListener>();
            this.eventListeners.put(neoDatisEventType, listeners);
        }
        listeners.add(eventListener);
    }

    public EventResult fireEvent(NeoDatisEvent event) {
        NeoDatisEventType type = event.getNeoDatisEventType();
        List<NeoDatisEventListener> l = this.eventListeners.get(type);
        if (l == null || l.isEmpty()) {
            return new EventResult(true);
        }
        for (NeoDatisEventListener listener : l) {
            listener.onEvent(event);
        }
        return new EventResult(true);
    }
}

