/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.btree.nativ;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreePersister;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.btree.nativ.NativeBTree;
import org.neodatis.odb.core.btree.nativ.NativeNode;
import org.neodatis.odb.core.btree.nativ.Position;
import org.neodatis.odb.core.btree.nativ.SplitRafResult;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.odb.core.layers.layer3.ReadSize;

public class NativeBTreePersisterWithSplit
implements IBTreePersister {
    protected String fileName;
    protected long maxFileSize;
    protected int btreeDegree;
    protected int nodeSize;
    protected DataConverter converter;
    protected IBTree btree;
    protected int HEADER_OFFSET = 36;
    protected Map<Long, IBTreeNode> nodes;
    protected Map<Long, IBTreeNode> modifiedNodes;
    protected boolean commit;
    protected boolean withCacheForRead;
    protected boolean withCacheForWrite;
    protected Map<Long, RandomAccessFile> rafs;
    protected boolean debug;
    protected String characterEncoding;

    public NativeBTreePersisterWithSplit(String fileName, long maxFileSize, int degree, boolean debug, String characterEncoding, NeoDatisConfig config) {
        System.out.println("SplitPersister");
        this.nodes = new HashMap<Long, IBTreeNode>();
        this.modifiedNodes = new TreeMap<Long, IBTreeNode>();
        this.fileName = fileName;
        this.maxFileSize = maxFileSize;
        this.btreeDegree = degree;
        this.converter = new DataConverterImpl(debug, characterEncoding, config);
        this.computeNodeSize();
        this.initRafs();
        this.withCacheForRead = true;
        this.withCacheForWrite = true;
    }

    private void initRafs() {
        try {
            this.rafs = new HashMap<Long, RandomAccessFile>();
            String fileId = this.fileName + "0";
            new File(fileId).getParentFile().mkdirs();
            RandomAccessFile raf = new RandomAccessFile(fileId, "rw");
            this.rafs.put(new Long(0L), raf);
        }
        catch (Exception e) {
            throw new BTreeException("Error while initializing RAFs", e);
        }
    }

    protected SplitRafResult getRafForPosition(long position) {
        long id = position / this.maxFileSize;
        long adjustedPosition = position - id * this.maxFileSize;
        try {
            Long lid = new Long(id);
            RandomAccessFile raf = this.rafs.get(lid);
            if (raf == null) {
                String fileId = this.fileName + id;
                new File(fileId).getParentFile().mkdirs();
                raf = new RandomAccessFile(fileId, "rw");
                this.rafs.put(lid, raf);
                System.out.println("Creating file " + fileId);
            }
            return new SplitRafResult(adjustedPosition, raf);
        }
        catch (Exception e) {
            throw new BTreeException("Error while getting raf for id " + id, e);
        }
    }

    private void computeNodeSize() {
        int size = 2 * this.btreeDegree - 1;
        this.nodeSize = 20 + size * 8 + size * 20 + (size + 1) * 8;
    }

    public void clear() {
    }

    public void close() throws Exception {
        this.commit = true;
        this.saveBTree(this.btree, true);
        this.saveModifiedNodes();
        Iterator<RandomAccessFile> iterator = this.rafs.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
        }
    }

    private void saveModifiedNodes() throws IOException {
        Iterator<IBTreeNode> mnodes = this.modifiedNodes.values().iterator();
        System.out.println("Saving " + this.modifiedNodes.size() + " nodes");
        while (mnodes.hasNext()) {
            IBTreeNode node = mnodes.next();
            this.saveNode(node);
        }
    }

    private void saveModifiedNodes2() throws IOException {
        Iterator<IBTreeNode> mnodes = this.modifiedNodes.values().iterator();
        System.out.println("Saving " + this.modifiedNodes.size() + " nodes");
        boolean i = false;
        long id1 = 0L;
        long id2 = 0L;
        int nbConcat = -1;
        Bytes mainBytes = null;
        long initPosition = this.HEADER_OFFSET;
        boolean firstTime = true;
        while (mnodes.hasNext()) {
            boolean canConcat;
            IBTreeNode node = mnodes.next();
            Bytes bytes = this.buildBytesForNode(node);
            id2 = (Long)node.getId();
            boolean bl = canConcat = id1 != 0L && id1 == id2 - 1L;
            if (!firstTime && canConcat && initPosition != -1L) {
                ++nbConcat;
                mainBytes.append(bytes);
            } else {
                initPosition = (long)this.HEADER_OFFSET + (id2 - 1L) * (long)this.nodeSize;
                mainBytes = bytes;
                nbConcat = 0;
            }
            if (!firstTime && !canConcat || nbConcat > 40) {
                SplitRafResult result = this.getRafForPosition(initPosition);
                RandomAccessFile raf = result.raf;
                raf.seek(result.adjustedPosition);
                raf.write(mainBytes.getByteArray());
                id1 = -1L;
                mainBytes = null;
                initPosition = -1L;
            }
            firstTime = false;
            id1 = id2;
        }
    }

    public Object deleteNode(IBTreeNode node) {
        System.out.println("Deleting node with id " + node.getId());
        return null;
    }

    public void flush() {
    }

    public IBTree loadBTree(Object id) {
        if (this.btree != null) {
            return this.btree;
        }
        System.out.println("Loading Btree with id " + id);
        Long nid = (Long)id;
        byte[] bbytes = new byte[this.HEADER_OFFSET];
        int arraySize = 0;
        try {
            RandomAccessFile raf = this.getRafForPosition((long)0L).raf;
            raf.seek(0L);
            arraySize = raf.read(bbytes);
        }
        catch (Exception e) {
            throw new BTreeException("Error while loading btree with id " + id.toString(), e);
        }
        if (arraySize != this.HEADER_OFFSET) {
            throw new BTreeException("Error while reading btree header, different size, expected " + this.HEADER_OFFSET + ", found " + arraySize);
        }
        Bytes bytes = BytesFactory.getBytes(bbytes);
        ReadSize readSize = new ReadSize();
        long nid2 = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree id");
        int degree = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "btree degree");
        long size = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree size");
        long rootId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree root id");
        long nextNodeId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree next node id");
        NativeBTree nbtree = new NativeBTree(new Long(nid2), degree, this, new Long(nextNodeId));
        nbtree.setSize(size);
        IBTreeNode root = this.loadNodeById(rootId);
        nbtree.setRoot(root);
        return nbtree;
    }

    public OID saveBTree(IBTree tree) {
        return null;
    }

    public OID saveBTree(IBTree tree, boolean force) {
        if (tree.getId() == null) {
            return null;
        }
        NativeBTree nbtree = (NativeBTree)tree;
        Bytes bytes = BytesFactory.getBytes();
        int objectSize = this.converter.longToByteArray((long)((Long)tree.getId()), bytes, 0, "btree id");
        objectSize += this.converter.intToByteArray(tree.getDegree(), bytes, objectSize, "btree degree");
        objectSize += this.converter.longToByteArray(tree.getSize(), bytes, objectSize, "btree size");
        objectSize += this.converter.longToByteArray((long)((Long)tree.getRoot().getId()), bytes, objectSize, "btree root id");
        objectSize += this.converter.longToByteArray((long)nbtree.getNextNodeId(), bytes, objectSize, "btree next node id");
        try {
            SplitRafResult result = this.getRafForPosition(0L);
            RandomAccessFile raf = result.raf;
            raf.seek(result.adjustedPosition);
            raf.write(bytes.getByteArray());
            return null;
        }
        catch (IOException e) {
            throw new BTreeException("Error while saving btree with id " + tree.getId(), e);
        }
    }

    public IBTreeNode loadNodeById(Object id) {
        if (this.withCacheForRead) {
            IBTreeNode nodeFromCache = this.nodes.get(id);
            if (nodeFromCache != null) {
                return nodeFromCache;
            }
            nodeFromCache = this.modifiedNodes.get((Comparable)id);
            if (nodeFromCache != null) {
                return nodeFromCache;
            }
        }
        Long nid = (Long)id;
        byte[] bbytes = new byte[this.nodeSize];
        int arraySize = 0;
        try {
            long position = (long)this.HEADER_OFFSET + (nid - 1L) * (long)this.nodeSize;
            SplitRafResult result = this.getRafForPosition(position);
            RandomAccessFile raf = result.raf;
            raf.seek(result.adjustedPosition);
            arraySize = raf.read(bbytes);
        }
        catch (Exception e) {
            throw new BTreeException("Error while loading node with id " + id, e);
        }
        Bytes bytes = BytesFactory.getBytes(bbytes);
        ReadSize readSize = new ReadSize();
        long nodeId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "id");
        long parentId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "parent id");
        int size = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "size");
        Long[] keys = new Long[size];
        int nbKeys = 0;
        for (int i = 0; i < size; ++i) {
            keys[i] = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "key");
            if (keys[i] == -1L) continue;
            ++nbKeys;
        }
        Position[] positions = new Position[size];
        for (int i = 0; i < size; ++i) {
            Position p;
            long fileId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "file id");
            long blockId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "block id");
            int offset = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "offset");
            positions[i] = p = new Position(fileId, blockId, offset);
        }
        Long[] childrens = new Long[size + 1];
        int nbChildren = 0;
        for (int i = 0; i < size + 1; ++i) {
            childrens[i] = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "child");
            if (childrens[i] == -1L) continue;
            ++nbChildren;
        }
        NativeNode node = new NativeNode(this.btree, nid, parentId, size, keys, positions, childrens, nbKeys, nbChildren);
        if (this.withCacheForRead) {
            this.nodes.put(nid, node);
        }
        return node;
    }

    public Object saveNode(IBTreeNode node) {
        int i;
        if (!this.commit && this.withCacheForWrite) {
            this.modifiedNodes.put((Long)node.getId(), node);
            return null;
        }
        Bytes bytes = BytesFactory.getBytes();
        long id = (Long)node.getId();
        long parentId = node.getParentId() == null ? -1L : (Long)node.getParentId();
        int size = 2 * this.btreeDegree - 1;
        int objectSize = 0;
        objectSize += this.converter.longToByteArray(id, bytes, objectSize, "id");
        objectSize += this.converter.longToByteArray(parentId, bytes, objectSize, "parent id");
        objectSize += this.converter.intToByteArray(size, bytes, objectSize, "size");
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                objectSize += this.converter.longToByteArray((long)((Long)node.getKeyAt(i)), bytes, objectSize, "key");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
        }
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                Position p = (Position)node.getValueAsObjectAt(i);
                objectSize += this.converter.longToByteArray(p.fileId, bytes, objectSize, "file id");
                objectSize += this.converter.longToByteArray(p.blockId, bytes, objectSize, "block id");
                objectSize += this.converter.intToByteArray(p.offset, bytes, objectSize, "ofsset");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.intToByteArray(-1, bytes, objectSize, "key");
        }
        for (i = 0; i < size + 1; ++i) {
            if (i < node.getNbChildren()) {
                Long childId = (Long)node.getChildIdAt(i, false);
                if (childId == null) {
                    System.out.println("null");
                }
                objectSize += this.converter.longToByteArray((long)childId, bytes, objectSize, "childId");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "childId");
        }
        try {
            long position = (long)this.HEADER_OFFSET + (id - 1L) * (long)this.nodeSize;
            SplitRafResult result = this.getRafForPosition(position);
            RandomAccessFile raf = result.raf;
            raf.seek(result.adjustedPosition);
            raf.write(bytes.getByteArray());
            if (this.withCacheForRead && !this.commit) {
                this.nodes.put(id, node);
            }
            return node.getId();
        }
        catch (IOException e) {
            throw new BTreeException("Error while saving node with id " + id, e);
        }
    }

    public Bytes buildBytesForNode(IBTreeNode node) {
        int i;
        Bytes bytes = BytesFactory.getBytes();
        long id = (Long)node.getId();
        long parentId = node.getParentId() == null ? -1L : (Long)node.getParentId();
        int size = 2 * this.btreeDegree - 1;
        int objectSize = 0;
        objectSize += this.converter.longToByteArray(id, bytes, objectSize, "id");
        objectSize += this.converter.longToByteArray(parentId, bytes, objectSize, "parent id");
        objectSize += this.converter.intToByteArray(size, bytes, objectSize, "size");
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                objectSize += this.converter.longToByteArray((long)((Long)node.getKeyAt(i)), bytes, objectSize, "key");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
        }
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                Position p = (Position)node.getValueAsObjectAt(i);
                objectSize += this.converter.longToByteArray(p.fileId, bytes, objectSize, "file id");
                objectSize += this.converter.longToByteArray(p.blockId, bytes, objectSize, "block id");
                objectSize += this.converter.intToByteArray(p.offset, bytes, objectSize, "ofsset");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.intToByteArray(-1, bytes, objectSize, "key");
        }
        for (i = 0; i < size + 1; ++i) {
            if (i < node.getNbChildren()) {
                Long childId = (Long)node.getChildIdAt(i, false);
                if (childId == null) {
                    System.out.println("null");
                }
                objectSize += this.converter.longToByteArray((long)childId, bytes, objectSize, "childId");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "childId");
        }
        return bytes;
    }

    public void setBTree(IBTree tree) {
        this.btree = tree;
    }
}

