/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb;

import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisGlobalConfig;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBServer;
import org.neodatis.odb.Release;
import org.neodatis.odb.core.config.NeoDatisConfigImpl;
import org.neodatis.odb.core.server.ODBSSLServerImpl;
import org.neodatis.odb.core.server.ODBServerImpl;
import org.neodatis.odb.core.server.SSLMessageStreamerImpl;
import org.neodatis.odb.main.LocalODB;
import org.neodatis.odb.main.RemoteODBClient;

public class NeoDatis {
    private NeoDatis() {
    }

    public static ODB open(String fileName, String user, String password) {
        NeoDatisConfig config = NeoDatis.getConfig();
        if (user != null && password != null) {
            config.setUser(user);
            config.setPassword(password);
        }
        LocalODB odBase = LocalODB.getInstance(fileName, config);
        return odBase;
    }

    public static ODB open(String fileName, String user, String password, NeoDatisConfig config) {
        if (user != null && password != null) {
            config.setUser(user);
            config.setPassword(password);
        }
        LocalODB odBase = LocalODB.getInstance(fileName, config);
        return odBase;
    }

    public static ODB open(String fileName) {
        LocalODB odBase = LocalODB.getInstance(fileName, NeoDatis.getConfig());
        return odBase;
    }

    public static ODB open(String fileName, NeoDatisConfig config) {
        LocalODB odBase = LocalODB.getInstance(fileName, config);
        return odBase;
    }

    public static ODBServer openServer(int port) {
        return new ODBServerImpl(port, NeoDatis.getConfig());
    }

    public static ODBServer openServer(int port, NeoDatisConfig config) {
        return new ODBServerImpl(port, config);
    }

    public static ODBServer openSSLServer(int port) {
        return new ODBSSLServerImpl(port, NeoDatis.getConfig());
    }

    public static ODBServer openSSLServer(int port, NeoDatisConfig config) {
        return new ODBSSLServerImpl(port, config);
    }

    public static ODB openClient(String hostName, int port, String baseIdentifier) {
        NeoDatisConfig config = NeoDatis.getConfig().setHostAndPort(hostName, port);
        return new RemoteODBClient(baseIdentifier, config);
    }

    public static ODB openClient(String baseIdentifier, NeoDatisConfig config) {
        return new RemoteODBClient(baseIdentifier, config);
    }

    public static ODB openSSLClient(String hostName, int port, String baseIdentifier) {
        NeoDatisConfig config = NeoDatis.getConfig().setHostAndPort(hostName, port);
        config.setMessageStreamerClass(SSLMessageStreamerImpl.class);
        return new RemoteODBClient(baseIdentifier, config);
    }

    public static ODB openSSLClient(String baseIdentifier, NeoDatisConfig config) {
        config.setMessageStreamerClass(SSLMessageStreamerImpl.class);
        return new RemoteODBClient(baseIdentifier, config);
    }

    public static NeoDatisConfig getConfig() {
        return new NeoDatisConfigImpl(true);
    }

    public static NeoDatisConfig getGlobalConfig() {
        return NeoDatisGlobalConfig.get();
    }

    public static NeoDatisConfig getConfigFromFile() throws Exception {
        return NeoDatis.getConfigFromFile("neodatis.properties");
    }

    public static NeoDatisConfig getConfigFromFile(String fileName) throws Exception {
        NeoDatisConfigImpl config = new NeoDatisConfigImpl(true);
        config.updateFromFile(fileName);
        return config;
    }

    public static String version() {
        return Release.RELEASE_NUMBER + " (" + Release.RELEASE_DATE + ")";
    }
}

