/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.io;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.fs.Block;
import org.neodatis.fs.NDFS;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.io.BlockReader;
import org.neodatis.fs.io.OneSplitFileResult;
import org.neodatis.fs.io.SplitFiles;
import org.neodatis.fs.memory.FileAndBlockKey;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.tool.DLogger;

public class SplittedNDFSFileImpl
implements NdfsFile {
    protected long id;
    protected String directory;
    protected String name;
    protected String fullName;
    protected NDFS ndfs;
    protected NdfsTransaction transaction;
    protected long blockSize;
    protected long oneFileSize;
    protected boolean debug;
    protected Map<Long, NdfsFile> filesById;
    protected Map<Long, BlockReader> blockReadersbyId;
    protected int maxNbBlockPerFile;

    public SplittedNDFSFileImpl(NDFS ndfs, long id, String fullName, int maxNbBlockPerFile) {
        File file = new File(new File(fullName).getAbsolutePath());
        String directory = null;
        String name = file.getName();
        this.maxNbBlockPerFile = maxNbBlockPerFile;
        this.init(ndfs, id, directory, name);
    }

    private void init(NDFS ndfs, long id, String directory, String name) {
        this.debug = ndfs.getConfig().debug();
        this.filesById = new HashMap<Long, NdfsFile>();
        this.blockReadersbyId = new HashMap<Long, BlockReader>();
        this.ndfs = ndfs;
        this.id = id;
        this.transaction = null;
        this.directory = directory;
        this.name = name;
        this.fullName = directory == null ? new File(new StringBuffer(ndfs.getConfig().getBaseDirectory()).append("/").append(name).toString()).getAbsolutePath() : new File(new StringBuffer(ndfs.getConfig().getBaseDirectory()).append("/").append(directory).append("/").append(name).toString()).getAbsolutePath();
        this.blockSize = ndfs.getConfig().getBlockSize();
        this.oneFileSize = (long)this.maxNbBlockPerFile * this.blockSize;
    }

    public SplittedNDFSFileImpl(NDFS ndfs, long id, String directory, String name, int maxNbBlockPerFile) {
        this.maxNbBlockPerFile = maxNbBlockPerFile;
        this.init(ndfs, id, directory, name);
    }

    public SplittedNDFSFileImpl(NdfsTransaction transaction, long id, String directory, String name, int maxNbBlockPerFile) {
        this(transaction.getNdfs(), id, directory, name, maxNbBlockPerFile);
        this.transaction = transaction;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void createDirectory() {
        new File(this.directory).mkdirs();
    }

    public Bytes read(long position, long length) {
        SplitFiles result = this.getFileForPosition(new SplitFiles(), position, length);
        Bytes bytes = null;
        List<OneSplitFileResult> splits = result.getSplits();
        for (int i = 0; i < splits.size(); ++i) {
            OneSplitFileResult r = splits.get(i);
            for (long positionInFile = r.startPositionInFile; positionInFile < r.endPositionInFile; positionInFile += this.blockSize) {
                System.out.println(positionInFile + " -> " + (positionInFile + this.blockSize));
                Block block = this.readOneBlock(r.fileId, r.file, positionInFile - r.startPositionInFile);
                if (bytes == null) continue;
                bytes.append(block.bytes);
            }
        }
        return bytes;
    }

    protected Block readOneBlock(long fileId, NdfsFile file, long adjustedPosition) {
        long blockId = adjustedPosition / this.blockSize;
        FileAndBlockKey key = new FileAndBlockKey(file, blockId);
        byte[] bytes = this.tryToGetFromMemory(key);
        if (bytes == null) {
            bytes = this.getBlockReader((long)fileId, (NdfsFile)file).readBlock((long)blockId).bytes;
            if (this.debug) {
                DLogger.debug("NdfsFile: file " + file.getName() + " : Reading block id " + blockId + " with size = " + bytes.length);
            }
            if (this.transaction != null) {
                this.transaction.getTma().getByteArrayByBlockId().put(key, bytes);
            }
        }
        return new Block(file, blockId, bytes);
    }

    private BlockReader getBlockReader(long fileId, NdfsFile file) {
        Long key = new Long(fileId);
        BlockReader reader = this.blockReadersbyId.get(key);
        if (reader != null) {
            return reader;
        }
        reader = new BlockReader(file);
        this.blockReadersbyId.put(key, reader);
        return reader;
    }

    private SplitFiles getFileForPosition(SplitFiles splits, long position, long length) {
        long maxPosition = position + length - 1L;
        long blockId = position / this.blockSize;
        long lfileId = blockId / (long)this.maxNbBlockPerFile;
        long fileStartPosition = lfileId * this.oneFileSize;
        long fileEndPosition = (lfileId + 1L) * this.oneFileSize - 1L;
        long adjustedPosition = position - fileStartPosition;
        try {
            Long lid = new Long(lfileId);
            NdfsFile file = this.getFile(lid);
            if (maxPosition <= fileEndPosition) {
                OneSplitFileResult result = new OneSplitFileResult(lfileId, adjustedPosition, adjustedPosition + length, file, blockId);
                splits.addSplit(result);
                return splits;
            }
            OneSplitFileResult result = new OneSplitFileResult(lfileId, position, fileEndPosition, file, blockId);
            System.out.println("Split start=" + result.startPositionInFile + "  -end=" + result.endPositionInFile + " - file=" + file.getName());
            splits.addSplit(result);
            length -= fileEndPosition - position + 1L;
            position = fileStartPosition + this.oneFileSize;
            return this.getFileForPosition(splits, position, length);
        }
        catch (Exception e) {
            throw new BTreeException("Error while getting file for id " + this.id, e);
        }
    }

    private NdfsFile getFile(Long lid) {
        NdfsFile file = this.filesById.get(lid);
        if (file == null) {
            String fileId = new StringBuffer(this.name).append(".").append(lid).toString();
            file = this.transaction.getFile(this.directory, fileId);
            this.filesById.put(lid, file);
            System.out.println("Creating file " + fileId);
        }
        return file;
    }

    public byte[] tryToGetFromMemory(FileAndBlockKey key) {
        if (this.transaction == null) {
            return null;
        }
        byte[] bytes = this.transaction.getTma().getByteArrayByBlockId().get(key);
        if (bytes != null) {
            return bytes;
        }
        bytes = this.transaction.getGma().getByteArrayByBlockId().get(key);
        return bytes;
    }

    public void write(Bytes bytes) {
        if (this.transaction != null) {
            int lenght;
            long position = bytes.getOffset();
            SplitFiles result = this.getFileForPosition(new SplitFiles(), position, lenght = bytes.getRealSize());
            List<OneSplitFileResult> splits = result.getSplits();
            if (splits.size() == 1) {
                OneSplitFileResult r = result.getSplits().get(0);
                bytes.setOffset(r.startPositionInFile);
                this.transaction.writeTo(r.file, bytes);
            } else {
                int localOffset = 0;
                for (int i = 0; i < splits.size(); ++i) {
                    OneSplitFileResult r = result.getSplits().get(i);
                    int start = localOffset;
                    int len = (int)(r.endPositionInFile - r.startPositionInFile) + 1;
                    byte[] b = bytes.extract(start, len);
                    localOffset += len;
                }
            }
        } else {
            this.writeDirect(bytes);
        }
    }

    public void writeDirect(Bytes bytes) {
        int lenght;
        long position = bytes.getOffset();
        SplitFiles result = this.getFileForPosition(new SplitFiles(), position, lenght = bytes.getRealSize());
        List<OneSplitFileResult> splits = result.getSplits();
        if (splits.size() == 1) {
            OneSplitFileResult r = result.getSplits().get(0);
            bytes.setOffset(r.startPositionInFile);
            this.ndfs.getSyncWriter(this).writeTo(bytes);
        } else {
            for (int i = 0; i < splits.size(); ++i) {
                OneSplitFileResult r = result.getSplits().get(i);
                byte[] b = bytes.extract((int)r.startPositionInFile, (int)(r.endPositionInFile - r.startPositionInFile));
            }
        }
    }

    public long getSize() {
        return new File(this.getFullName()).length();
    }

    public String toString() {
        return this.fullName + " - fid=" + this.id;
    }

    public NDFS getNdfs() {
        return this.ndfs;
    }

    public long append(Bytes bytes) {
        throw new RuntimeException("not yet suported");
    }

    public long appendDirect(Bytes bytes) {
        throw new RuntimeException("not yet suported");
    }

    public Bytes readAll() {
        return this.read(0L, this.getSize());
    }

    public void close() {
    }

    public long getLength() {
        return 0L;
    }
}

