/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs;

import org.neodatis.fs.NdfsFile;

public class Block {
    protected NdfsFile owner;
    public byte[] bytes;
    public long id;
    protected int blockSize;

    public Block(NdfsFile file, long id) {
        this.owner = file;
        this.id = id;
        this.blockSize = this.owner.getNdfs().getConfig().getBlockSize();
        this.clear();
    }

    public Block(NdfsFile file, long blockId, byte[] bytes2) {
        this.owner = file;
        this.id = blockId;
        this.bytes = bytes2;
    }

    public Block initWith(byte b) {
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = b;
        }
        return this;
    }

    public long getPosition() {
        return (this.id - 1L) * (long)this.blockSize;
    }

    public void clear() {
        this.bytes = new byte[this.blockSize];
    }
}

