/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.UnsupportedEncodingException;

public class Conversion {
    public static final long MAX_PACKEDLONGVALUE = 0x3FFFFFFFFFFFFFFFL;

    public static byte[] convertToByteArray(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new Error("Platform doesn't support UTF8 encoding");
        }
    }

    public static byte[] convertToByteArray(byte n) {
        n = (byte)(n ^ 0xFFFFFF80);
        return new byte[]{n};
    }

    public static byte[] convertToByteArray(short n) {
        n = (short)(n ^ Short.MIN_VALUE);
        byte[] key = new byte[2];
        Conversion.pack2(key, 0, n);
        return key;
    }

    public static byte[] convertToByteArray(int n) {
        byte[] key = new byte[4];
        Conversion.pack4(key, 0, n ^= Integer.MIN_VALUE);
        return key;
    }

    public static byte[] convertToByteArray(long n) {
        byte[] key = new byte[8];
        Conversion.pack8(key, 0, n ^= Long.MIN_VALUE);
        return key;
    }

    public static String convertToString(byte[] buf) {
        return Conversion.convertToString(buf, 0, buf.length);
    }

    public static String convertToString(byte[] buf, int off, int len) {
        try {
            return new String(buf, off, len, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new Error("Platform doesn't support UTF8 encoding");
        }
    }

    public static short convertToShort(byte[] buf) {
        short value = Conversion.unpack2(buf, 0);
        value = (short)(value ^ 0x8000);
        return value;
    }

    public static int convertToInt(byte[] buf) {
        int value = Conversion.unpack4(buf, 0);
        return value ^= Integer.MIN_VALUE;
    }

    public static long convertToLong(byte[] buf) {
        long value = ((long)Conversion.unpack4(buf, 0) << 32) + ((long)Conversion.unpack4(buf, 4) & 0xFFFFFFFFL);
        return value ^= Long.MIN_VALUE;
    }

    static final short unpack2(byte[] buf, int offset) {
        short val = (short)(buf[offset] << 8 | buf[offset + 1] << 0 & 0xFF);
        return val;
    }

    static int unpack4(byte[] buf, int offset) {
        int value = buf[offset] << 24 | buf[offset + 1] << 16 & 0xFF0000 | buf[offset + 2] << 8 & 0xFF00 | buf[offset + 3] << 0 & 0xFF;
        return value;
    }

    public static long unpack8(byte[] buf, int offset) {
        long value = ((long)Conversion.unpack4(buf, offset) << 32) + ((long)Conversion.unpack4(buf, offset + 4) & 0xFFFFFFFFL);
        return value ^= Long.MIN_VALUE;
    }

    static final void pack2(byte[] data, int offs, int val) {
        data[offs++] = (byte)(val >> 8);
        data[offs++] = (byte)val;
    }

    static final void pack4(byte[] data, int offs, int val) {
        data[offs++] = (byte)(val >> 24);
        data[offs++] = (byte)(val >> 16);
        data[offs++] = (byte)(val >> 8);
        data[offs++] = (byte)val;
    }

    static final void pack8(byte[] data, int offs, long val) {
        Conversion.pack4(data, offs, (int)(val >> 32));
        Conversion.pack4(data, offs + 4, (int)val);
    }

    public static final int getRequiredPackedBufferSize(long n) {
        if (n <= 32767L) {
            return 2;
        }
        if (n <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }

    public static int getPackedByteCount(byte first) {
        if ((0x80 & first) == 0) {
            return 2;
        }
        if ((0xC0 & first) == 128) {
            return 4;
        }
        return 8;
    }

    public static final int convertToPackedByteArray(long n, byte[] out, int start) {
        if (n < 0L || n > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Stored long value " + n + " is not >=0 and <= " + 0x3FFFFFFFFFFFFFFFL);
        }
        if (n <= 32767L) {
            Conversion.pack2(out, start, (short)n);
            return 2;
        }
        if (n <= 0x3FFFFFFFL) {
            Conversion.pack4(out, start, Integer.MIN_VALUE | (int)n);
            return 4;
        }
        Conversion.pack8(out, start, 0xC000000000000000L | n);
        return 8;
    }

    public static final byte[] convertToPackedByteArray(long n) {
        int siz = Conversion.getRequiredPackedBufferSize(n);
        byte[] buf = new byte[siz];
        Conversion.convertToPackedByteArray(n, buf, 0);
        return buf;
    }

    public static final long recoverLongFromPacked(byte[] b) {
        return Conversion.recoverLongFromPacked(b, 0);
    }

    public static final long recoverLongFromPacked(byte[] b, int start) {
        byte first = b[start];
        if ((0x80 & first) == 0) {
            return Short.MAX_VALUE & Conversion.unpack2(b, start);
        }
        if ((0xC0 & first) == 128) {
            return 0x3FFFFFFF & Conversion.unpack4(b, start);
        }
        return 0x3FFFFFFFFFFFFFFFL & Conversion.unpack8(b, start);
    }
}

