/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.plugin.idf.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.oid.sequential.ClassOidImpl;
import org.neodatis.odb.core.oid.sequential.ObjectOidImpl;
import org.neodatis.odb.plugin.idf.Indexer;
import org.neodatis.odb.plugin.idf.ObjectLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndex
implements Indexer {
    protected String id;
    protected String baseDir;
    protected String keyName;
    protected IndexWriter indexWriter;
    protected IndexReader indexReader;
    protected Directory directory;
    protected Analyzer analyzer;

    public LuceneIndex(String id, String baseDir, String keyName) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.id = id;
        this.baseDir = baseDir;
        this.keyName = keyName;
        this.init();
    }

    private void init() throws CorruptIndexException, LockObtainFailedException, IOException {
        this.directory = FSDirectory.open((File)this.getFullIndexPath());
        this.analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
        this.indexWriter = new IndexWriter(this.directory, this.analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
        this.indexReader = IndexReader.open((Directory)this.directory, (boolean)false);
    }

    private File getFullIndexPath() {
        return new File(this.baseDir + "/" + this.id);
    }

    @Override
    public void put(OID oid, ObjectLocation objectLocation) throws CorruptIndexException, IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field(this.keyName, oid.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        byte[] bytes = objectLocation.toBytes();
        doc.add((Fieldable)new Field("file-id", bytes, Field.Store.YES));
        this.indexWriter.addDocument(doc);
    }

    public void commitWriter() throws CorruptIndexException, IOException {
        this.indexWriter.commit();
    }

    private void refreshReader() throws CorruptIndexException, IOException {
        this.indexReader.close();
        this.indexReader = IndexReader.open((Directory)this.directory, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectLocation get(OID oid) throws ParseException, IOException {
        long t0;
        block3: {
            ObjectLocation objectLocation;
            t0 = System.currentTimeMillis();
            try {
                ObjectLocation ol;
                IndexSearcher searcher = new IndexSearcher(this.indexReader);
                QueryParser parser = new QueryParser(Version.LUCENE_CURRENT, this.keyName, this.analyzer);
                Query query = parser.parse(oid.toString());
                int hitsPerPage = 5;
                TopScoreDocCollector collector = TopScoreDocCollector.create((int)hitsPerPage, (boolean)true);
                searcher.search(query, (Collector)collector);
                ScoreDoc[] hits = collector.topDocs().scoreDocs;
                System.out.println("Found " + hits.length + " hits.");
                int i = 0;
                if (i >= hits.length) break block3;
                int docId = hits[i].doc;
                Document d = searcher.doc(docId);
                byte[] bytes = d.getBinaryValue("file-id");
                objectLocation = ol = ObjectLocation.fromBytes(bytes);
                Object var17_16 = null;
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                long t1 = System.currentTimeMillis();
                System.out.println(t1 - t0 + "ms");
                throw throwable;
            }
            long t1 = System.currentTimeMillis();
            System.out.println(t1 - t0 + "ms");
            return objectLocation;
        }
        ObjectLocation objectLocation = null;
        Object var17_17 = null;
        long t1 = System.currentTimeMillis();
        System.out.println(t1 - t0 + "ms");
        return objectLocation;
    }

    @Override
    public void close() throws IOException {
        this.indexWriter.close();
        this.indexReader.close();
        this.directory.close();
    }

    public static void main(String[] args) throws CorruptIndexException, LockObtainFailedException, IOException, ParseException {
        LuceneIndex li = new LuceneIndex("1" + System.currentTimeMillis(), "unit-test-data", "oid");
        ObjectOidImpl oid = new ObjectOidImpl(new ClassOidImpl(1L), 1L);
        int size = 1000000;
        for (int i = 0; i < size; ++i) {
            oid = new ObjectOidImpl(new ClassOidImpl(1L), i + 1);
            li.put(oid, new ObjectLocation(1, i + 1, i));
            if (i % 10 != 0) continue;
            System.out.println(i);
        }
        li.commitWriter();
        li.refreshReader();
        ObjectLocation ol = li.get(new ObjectOidImpl(new ClassOidImpl(1L), 9999L));
        System.out.println(ol);
        li.close();
    }

    @Override
    public void init(String id, String baseDirectory) {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public ObjectLocation delete(OID oid) {
        return null;
    }

    @Override
    public boolean existKey(OID oid) {
        return false;
    }

    public Iterator<OID> iterator() {
        return null;
    }

    @Override
    public ClassOidIterator getClassOidIterator() {
        return null;
    }

    @Override
    public ObjectOidIterator getObjectOidIterator() {
        return null;
    }

    @Override
    public void setDebug(boolean yes) {
    }
}

