/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.plugin.idf.jdbm;

import java.io.IOException;
import java.util.Iterator;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.layers.layer4.OidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmObjectOidIterator
implements ObjectOidIterator {
    protected BTree btree;
    protected TupleBrowser browser;
    protected Tuple<byte[], Object> tuple;
    protected ObjectOidIterator.Way way;
    protected OidGenerator oidGenerator;

    public JdbmObjectOidIterator(BTree btree, ObjectOidIterator.Way way, OidGenerator generator) {
        this.oidGenerator = generator;
        this.btree = btree;
        try {
            this.browser = this.btree.browse();
        }
        catch (IOException e) {
            throw new NeoDatisRuntimeException(e);
        }
        this.way = way;
        this.tuple = new Tuple();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.browser.getNext(this.tuple);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e);
        }
    }

    @Override
    public ObjectOid next() {
        byte[] o = this.tuple.getKey();
        if (o instanceof ObjectOid) {
            return (ObjectOid)o;
        }
        return this.oidGenerator.buildObjectOID(o);
    }

    @Override
    public void reset() {
        try {
            this.browser = this.btree.browse();
        }
        catch (IOException e) {
            throw new NeoDatisRuntimeException(e);
        }
        this.tuple = null;
    }

    public Iterator<ObjectOid> iterator() {
        return (Iterator)((Object)this);
    }

    @Override
    public void startAtTheBeginning() {
    }

    @Override
    public void startAtTheEnd() {
    }
}

