/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.UUID;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisEventType;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.TransactionId;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.event.EventManager;
import org.neodatis.odb.core.event.EventManagerImpl;
import org.neodatis.odb.core.event.NeoDatisEventListener;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.MetaModelImpl;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer4.BaseIdentification;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.oid.DatabaseIdImpl;
import org.neodatis.odb.core.oid.TransactionIdImpl;
import org.neodatis.odb.core.session.Cache;
import org.neodatis.odb.core.session.CacheImpl;
import org.neodatis.odb.core.session.DatabaseInfo;
import org.neodatis.odb.core.session.LockTimeOutException;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.core.session.SessionEngineImpl;
import org.neodatis.odb.core.trigger.CloseListener;
import org.neodatis.odb.core.trigger.CommitListener;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.mutex.Mutex;
import org.neodatis.tool.mutex.MutexFactory;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements Session {
    public static final String LOG_ID = "SessionImpl";
    protected BaseIdentification identification;
    protected SessionEngine engine;
    protected MetaModel metaModel;
    protected Cache cache;
    protected String id;
    protected DatabaseId databaseId;
    protected TransactionId transactionId;
    protected boolean isClosed;
    protected boolean isRollbacked;
    protected IOdbList<CommitListener> commitListeners;
    protected IOdbList<CloseListener> closeListeners;
    protected boolean isCommitted;
    protected Map<OID, Mutex> lockedOids;
    protected Map<String, Mutex> lockedClasses;
    protected EventManager eventManager;
    protected NeoDatisConfig config;
    protected OidGenerator oidGenerator;
    protected Map<String, Object> userParameters;

    public SessionImpl(BaseIdentification parameter) {
        this.init(parameter, null);
    }

    public SessionImpl(BaseIdentification parameter, String sessionId) {
        this.init(parameter, sessionId);
    }

    protected void init(BaseIdentification baseIdentification, String sessionId) {
        this.config = baseIdentification.getConfig();
        this.identification = baseIdentification;
        this.eventManager = new EventManagerImpl();
        this.lockedOids = new OdbHashMap<OID, Mutex>();
        this.lockedClasses = new OdbHashMap<String, Mutex>();
        this.id = sessionId != null ? sessionId : new StringBuffer(baseIdentification.getBaseId()).append(System.currentTimeMillis()).toString();
        this.cache = new CacheImpl();
        this.engine = this.buildSessionEngine();
        this.transactionId = new TransactionIdImpl(this.id);
        this.isClosed = false;
        this.isRollbacked = false;
        this.isCommitted = false;
        this.commitListeners = new OdbArrayList<CommitListener>();
        this.closeListeners = new OdbArrayList<CloseListener>();
        this.oidGenerator = this.config.getCoreProvider().getOidGenerator();
        this.initDatabase();
    }

    protected SessionEngine buildSessionEngine() {
        return new SessionEngineImpl(this);
    }

    protected void initDatabase() {
        if (this.engine.isNewDatabase()) {
            this.writeNewDatabaseHeader();
        } else {
            this.readDatabaseHeader();
        }
        this.initMetaModel();
    }

    private void readDatabaseHeader() {
    }

    private void writeNewDatabaseHeader() {
        this.databaseId = DatabaseIdImpl.fromString(UUID.randomUUID().toString());
        DatabaseInfo di = new DatabaseInfo(this.databaseId, false, null, 200, this.getConfig().getDatabaseCharacterEncoding(), this.getOidGenerator().getClass().getName());
        this.engine.writeDatabaseHeader(di);
    }

    protected void initMetaModel() {
        this.metaModel = new MetaModelImpl(this.getConfig());
        this.engine.loadMetaModel(this.metaModel);
    }

    @Override
    public ClassInfoList addClasses(ClassInfoList ciList) {
        this.metaModel.addClasses(ciList);
        this.engine.storeClassInfos(ciList);
        return ciList;
    }

    @Override
    public void addObjectToCache(OID oidCrossSession, Object o, ObjectInfoHeader oih) {
    }

    @Override
    public void close() {
        if (this.config.isSessionAutoCommit()) {
            if (!this.isRollbacked) {
                this.commit();
            }
        } else if (!this.isCommitted) {
            this.rollback();
        }
        this.engine.close();
        this.isClosed = true;
        this.manageCloseListenersAfter();
    }

    @Override
    public void commit() {
        if (this.isRollbacked) {
            return;
        }
        if (this.isCommitted) {
            return;
        }
        this.manageCommitListenersBefore();
        this.engine.commit();
        this.manageCommitListenersAfter();
        this.isCommitted = true;
        this.unlockObjectsAndClasses();
    }

    @Override
    public BaseIdentification getBaseIdentification() {
        return this.identification;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public ClassInfo getClassInfo(String fullClassName) {
        if (ODBType.getFromName(fullClassName).isNative()) {
            return null;
        }
        MetaModel metaModel = this.getMetaModel();
        if (metaModel.existClass(fullClassName)) {
            return metaModel.getClassInfo(fullClassName, true);
        }
        ClassInfo ci = null;
        ClassInfoList ciList = null;
        ciList = this.engine.introspectClass(fullClassName);
        this.addClasses(ciList);
        ci = metaModel.getClassInfo(fullClassName, true);
        return ci;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    @Override
    public ObjectInfoHeader getObjectInfoHeaderFromOid(OID oidCrossSession, boolean b) {
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getExecutionType() {
        return 11;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isRollbacked() {
        return this.isRollbacked;
    }

    @Override
    public void rollback() {
        this.engine.rollback();
        this.isRollbacked = true;
        this.unlockObjectsAndClasses();
    }

    @Override
    public SessionEngine getEngine() {
        return this.engine;
    }

    @Override
    public TransactionId getCurrentTransactionId() {
        return this.transactionId;
    }

    @Override
    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public void update(Observable o, Object arg) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    @Override
    public void addCommitListener(CommitListener commitListener) {
        this.commitListeners.add(commitListener);
    }

    public IOdbList<CommitListener> getCommitListeners() {
        return this.commitListeners;
    }

    public IOdbList<CloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    private void manageCommitListenersAfter() {
        if (this.commitListeners == null || this.commitListeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.commitListeners.iterator();
        CommitListener commitListener = null;
        while (iterator.hasNext()) {
            commitListener = (CommitListener)iterator.next();
            commitListener.afterCommit();
        }
    }

    private void manageCloseListenersAfter() {
        if (this.closeListeners == null || this.closeListeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.closeListeners.iterator();
        CloseListener closeListener = null;
        while (iterator.hasNext()) {
            closeListener = (CloseListener)iterator.next();
            closeListener.afterClose();
        }
    }

    private void manageCommitListenersBefore() {
        if (this.commitListeners == null || this.commitListeners.isEmpty()) {
            return;
        }
        Iterator iterator = this.commitListeners.iterator();
        CommitListener commitListener = null;
        while (iterator.hasNext()) {
            commitListener = (CommitListener)iterator.next();
            commitListener.beforeCommit();
        }
    }

    @Override
    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
        for (ClassInfo ci : metaModel.getAllClasses()) {
            this.engine.storeClassInfo(ci);
        }
    }

    @Override
    public boolean transactionIsPending() {
        return false;
    }

    public void endCurrentAction() {
    }

    public void setCurrentAction(int action) {
    }

    @Override
    public void setId(String sessionId) {
        this.id = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void lockOidForSession(OID oid, long timeout) throws InterruptedException {
        boolean locked = false;
        long start = OdbTime.getCurrentTimeInMs();
        if (this.config.isDebugEnabled(LOG_ID)) {
            start = OdbTime.getCurrentTimeInMs();
            DLogger.debug("Trying to lock object with oid " + oid + " - session id=" + this.getId() + " - Thread = " + OdbThread.getCurrentThreadName());
        }
        try {
            Mutex mutex = this.lockedOids.get(oid);
            if (mutex == null) {
                mutex = MutexFactory.get(this.getBaseIdentification().getBaseId() + oid.oidToString());
                locked = mutex.attempt(this.config.getTimeoutToAcquireMutex());
                if (!locked) {
                    throw new LockTimeOutException("Object with oid " + oid.oidToString() + " - session id " + this.getId() + " - Thread = " + OdbThread.getCurrentThreadName());
                }
                this.lockedOids.put(oid, mutex);
                return;
            }
        }
        finally {
            if (locked && this.config.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Object with oid " + oid + " locked (" + (OdbTime.getCurrentTimeInMs() - start) + "ms) - " + this.getId() + " - Thread = " + OdbThread.getCurrentThreadName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void lockClassForSession(String fullClassName, long timeout) throws InterruptedException {
        block6: {
            long start = OdbTime.getCurrentTimeInMs();
            boolean locked = false;
            if (this.config.isDebugEnabled(LOG_ID)) {
                start = OdbTime.getCurrentTimeInMs();
                DLogger.debug(String.format("CM:Trying to lock class %s - id=%s", fullClassName, this.getId()));
            }
            try {
                Mutex mutex = this.lockedClasses.get(fullClassName);
                if (mutex != null) {
                    mutex = MutexFactory.get(this.getBaseIdentification().getBaseId() + fullClassName);
                    locked = mutex.attempt(timeout);
                    if (!locked) {
                        throw new LockTimeOutException("Class with name " + fullClassName);
                    }
                    this.lockedClasses.put(fullClassName, mutex);
                }
                if (!this.config.isDebugEnabled(LOG_ID)) break block6;
            }
            catch (Throwable throwable) {
                if (this.config.isDebugEnabled(LOG_ID)) {
                    DLogger.debug(String.format("Class %s locked (%dms) - %s", fullClassName, OdbTime.getCurrentTimeInMs() - start, this.getId()));
                }
                throw throwable;
            }
            DLogger.debug(String.format("Class %s locked (%dms) - %s", fullClassName, OdbTime.getCurrentTimeInMs() - start, this.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unlockOidForSession(OID oid) throws InterruptedException {
        long start = OdbTime.getCurrentTimeInMs();
        if (this.config.isDebugEnabled(LOG_ID)) {
            start = OdbTime.getCurrentTimeInMs();
            DLogger.debug("Trying to unlock lock object with oid " + oid + " - id=" + this.getId());
        }
        try {
            Mutex mutex = this.lockedOids.get(oid);
            if (mutex != null) {
                mutex.release(this.getId());
                this.lockedOids.remove(oid);
            }
        }
        finally {
            if (this.config.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Object with oid " + oid + " unlocked (" + (OdbTime.getCurrentTimeInMs() - start) + "ms) - " + this.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unlockClass(String fullClassName) throws InterruptedException {
        long start = OdbTime.getCurrentTimeInMs();
        if (this.config.isDebugEnabled(LOG_ID)) {
            start = OdbTime.getCurrentTimeInMs();
            DLogger.debug("Trying to unlock class " + fullClassName + " - id=" + this.getId());
        }
        try {
            Mutex mutex = this.lockedClasses.get(fullClassName);
            if (mutex != null) {
                mutex.release(this.getId());
                this.lockedClasses.remove(fullClassName);
            }
        }
        finally {
            if (this.config.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Class  " + fullClassName + " unlocked (" + (OdbTime.getCurrentTimeInMs() - start) + "ms) - " + this.getId());
            }
        }
    }

    @Override
    public void unlockObjectsAndClasses() {
        Iterator<Mutex> objectMutexes = this.lockedOids.values().iterator();
        while (objectMutexes.hasNext()) {
            objectMutexes.next().release(this.getId());
        }
        Iterator<Mutex> classMutexes = this.lockedClasses.values().iterator();
        while (classMutexes.hasNext()) {
            classMutexes.next().release(this.getId());
        }
    }

    @Override
    public void registerEventListenerFor(NeoDatisEventType neoDatisEventType, NeoDatisEventListener eventListener) {
        this.eventManager.addEventListener(neoDatisEventType, eventListener);
    }

    @Override
    public void updateMetaModel() {
        MetaModel metaModel = this.getMetaModel();
        DLogger.info("Automatic refactoring : updating meta model");
        ArrayList<ClassInfo> userClasses = new ArrayList<ClassInfo>(metaModel.getUserClasses());
        Iterator<Object> iterator = userClasses.iterator();
        while (iterator.hasNext()) {
            this.engine.storeClassInfo((ClassInfo)iterator.next());
        }
        iterator = metaModel.getSystemClasses().iterator();
        while (iterator.hasNext()) {
            this.engine.storeClassInfo((ClassInfo)iterator.next());
        }
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public NeoDatisConfig getConfig() {
        return this.config;
    }

    @Override
    public OidGenerator getOidGenerator() {
        return this.oidGenerator;
    }

    @Override
    public void addCloseListener(CloseListener closeListener) {
        this.closeListeners.add(closeListener);
    }

    @Override
    public Object getUserParameter(String name, boolean remove) {
        if (this.userParameters == null) {
            return null;
        }
        Object o = this.userParameters.get(name);
        if (o != null && remove) {
            this.userParameters.remove(o);
        }
        return o;
    }

    @Override
    public synchronized void setUserParameter(String name, Object object) {
        if (this.userParameters == null) {
            this.userParameters = new HashMap<String, Object>();
        }
        this.userParameters.put(name, object);
    }
}

