/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.session;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.session.Cache;

public class CacheImpl
implements Cache {
    private Map<Object, ObjectOid> objects;
    protected Map<ObjectOid, WeakReference<Object>> oids;

    public CacheImpl() {
        this.init();
    }

    private void init() {
        this.objects = Collections.synchronizedMap(new WeakHashMap());
        this.oids = Collections.synchronizedMap(new WeakHashMap());
    }

    public boolean existObject(Object object) {
        return this.objects.containsKey(object);
    }

    public ObjectInfoHeader getObjectInfoHeaderFromOid(OID oid, boolean throwExceptionIfNotFound) {
        return null;
    }

    public void addObject(ObjectOid oid, Object o) {
        if (o == null) {
            return;
        }
        try {
            this.objects.put(o, oid);
            this.oids.put(oid, new WeakReference<Object>(o));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Object getObjectWithOid(ObjectOid oid) {
        WeakReference<Object> wr = this.oids.get(oid);
        if (wr == null) {
            return null;
        }
        return wr.get();
    }

    public ObjectOid getOid(Object object, boolean throwExceptionIfNotFound) {
        ObjectOid oid = this.objects.get(object);
        if (oid == null) {
            if (throwExceptionIfNotFound) {
                throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE);
            }
            return null;
        }
        return oid;
    }

    public int getSize() {
        return this.objects.size();
    }

    public void clear() {
        this.objects.clear();
        this.oids.clear();
    }

    public void remove(Object o, ObjectOid oid) {
        this.objects.remove(o);
        this.oids.remove(oid);
    }

    public void remove(ObjectOid oid) {
        WeakReference<Object> ref = this.oids.remove(oid);
        if (ref != null) {
            Object o = ref.get();
            this.objects.remove(o);
        }
    }
}

