/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.oid;

import org.neodatis.odb.ClassOid;
import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ExternalOID;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.layers.layer4.StorageEngine;
import org.neodatis.odb.core.server.MessageStreamer;
import org.neodatis.odb.core.server.message.NextClassInfoOidMessage;
import org.neodatis.odb.core.server.message.NextClassInfoOidResponseMessage;
import org.neodatis.odb.core.server.oid.ClientOidGenerator;
import org.neodatis.odb.core.session.Session;

public class ClientOidGeneratorImpl
implements ClientOidGenerator {
    protected Session session;
    protected MessageStreamer messageStreamer;
    protected long nextOid = -1L;
    protected OidGenerator oidGenerator;

    public void set(OidGenerator generator, Session session, MessageStreamer streamer) {
        this.oidGenerator = generator;
        this.session = session;
        this.messageStreamer = streamer;
    }

    public ClassOid buildClassOID(byte[] bb) {
        return this.oidGenerator.buildClassOID(bb);
    }

    public ObjectOid buildObjectOID(byte[] bb) {
        return this.oidGenerator.buildObjectOID(bb);
    }

    public OID buildStringOid(String s) {
        return this.oidGenerator.buildStringOid(s);
    }

    public ClassOid getNullClassOid() {
        return this.oidGenerator.getNullClassOid();
    }

    public ObjectOid getNullObjectOid() {
        return this.oidGenerator.getNullObjectOid();
    }

    public ExternalOID toExternalOid(ObjectOid oid, DatabaseId databaseId) {
        return this.oidGenerator.toExternalOid(oid, databaseId);
    }

    public void commit() {
    }

    public ClassOid createClassOid() {
        NextClassInfoOidMessage message = new NextClassInfoOidMessage(this.session.getBaseIdentification().getBaseId(), this.session.getId());
        try {
            NextClassInfoOidResponseMessage rmsg = (NextClassInfoOidResponseMessage)this.messageStreamer.sendAndReceive(message);
            return rmsg.getCoid();
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(e, "getNextClassOid");
        }
    }

    public ObjectOid createObjectOid(ClassOid classOid) {
        return this.oidGenerator.createObjectOid(classOid);
    }

    public void init(StorageEngine engine, boolean useCache) {
    }

    public ClassOid classOidFromString(String s) {
        return this.oidGenerator.classOidFromString(s);
    }

    public ObjectOid objectOidFromString(String s) {
        return this.oidGenerator.objectOidFromString(s);
    }

    public String getSimpleName() {
        return this.oidGenerator.getSimpleName();
    }
}

