/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.values;

import java.util.HashSet;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.query.GenericQueryExecutor;
import org.neodatis.odb.core.query.IQueryExecutionPlan;
import org.neodatis.odb.core.query.IndexTool;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.MatchResult;
import org.neodatis.odb.core.query.criteria.CriteriaQueryExecutionPlan;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.query.criteria.CriteriaQueryManager;
import org.neodatis.odb.core.query.values.ValuesMatchResult;
import org.neodatis.odb.core.session.SessionEngine;

public class ValuesCriteriaQueryExecutor
extends GenericQueryExecutor {
    private HashSet<String> involvedFields;
    private CriteriaQueryImpl criteriaQuery;

    public ValuesCriteriaQueryExecutor(InternalQuery query, SessionEngine engine) {
        super(query, engine);
        this.criteriaQuery = (CriteriaQueryImpl)query;
    }

    public IQueryExecutionPlan getExecutionPlan() {
        CriteriaQueryExecutionPlan plan = new CriteriaQueryExecutionPlan(this.classInfo, this.criteriaQuery);
        return plan;
    }

    public void prepareQuery() {
        this.criteriaQuery = this.criteriaQuery;
        this.involvedFields = this.criteriaQuery.getAllInvolvedFields();
        if (this.criteriaQuery.hasOrderBy()) {
            String[] orderByFields = this.criteriaQuery.getOrderByFieldNames();
            for (int i = 0; i < orderByFields.length; ++i) {
                this.involvedFields.add(orderByFields[i]);
            }
        }
    }

    public MatchResult matchObjectWithOid(ObjectOid oid, boolean inMemory) {
        boolean optimizeObjectCompararison = this.criteriaQuery.optimizeObjectComparison();
        AttributeValuesMap values = this.engine.getFieldValuesFromOid(oid, this.involvedFields, optimizeObjectCompararison, this.criteriaQuery.getQueryParameters().getLoadDepth());
        if (values == null) {
            return new ValuesMatchResult(false);
        }
        boolean objectMatches = true;
        if (!this.criteriaQuery.isForSingleOid()) {
            objectMatches = CriteriaQueryManager.match(this.criteriaQuery, values);
        }
        if (objectMatches) {
            return new ValuesMatchResult(values);
        }
        return null;
    }

    public Comparable computeIndexKey(ClassInfo ci, ClassInfoIndex index) {
        return IndexTool.computeKey(this.classInfo, index, this.criteriaQuery);
    }
}

