/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query;

import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.Query;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.query.IQueryExecutor;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.MultiClassGenericQueryExecutor;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQueryExecutor;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.query.criteria.CriteriaQueryManager;
import org.neodatis.odb.core.query.nq.NativeQuery;
import org.neodatis.odb.core.query.nq.NativeQueryExecutor;
import org.neodatis.odb.core.query.nq.NativeQueryManager;
import org.neodatis.odb.core.query.values.ValuesCriteriaQuery;
import org.neodatis.odb.core.query.values.ValuesCriteriaQueryExecutor;
import org.neodatis.odb.core.session.SessionEngine;

public class QueryManager {
    public static boolean match(InternalQuery query, Object object) {
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return NativeQueryManager.match((NativeQuery)query, object);
        }
        if (QueryManager.isCriteriaQuery(query)) {
            return CriteriaQueryManager.match((CriteriaQueryImpl)query, object);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    public static String getFullClassName(Query query) {
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return NativeQueryManager.getClass((NativeQuery)query);
        }
        if (QueryManager.isCriteriaQuery(query) || ValuesCriteriaQuery.class == query.getClass()) {
            return CriteriaQueryManager.getFullClassName((CriteriaQuery)query);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    public static boolean needsInstanciation(Query query) {
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return true;
        }
        if (QueryManager.isCriteriaQuery(query) || ValuesCriteriaQuery.class == query.getClass()) {
            return false;
        }
        throw new NeoDatisRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    public static boolean isCriteriaQuery(Query query) {
        return query instanceof CriteriaQueryImpl || query instanceof CriteriaQuery;
    }

    public static int[] getOrderByAttributeIds(ClassInfo classInfo, InternalQuery query) {
        String[] fieldNames = query.getOrderByFieldNames();
        int[] fieldIds = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldIds[i] = classInfo.getAttributeId(fieldNames[i]);
        }
        return fieldIds;
    }

    public static IQueryExecutor getQueryExecutor(InternalQuery query, SessionEngine engine) {
        if (query.isPolymorphic()) {
            return QueryManager.getMultiClassQueryExecutor(query, engine);
        }
        return QueryManager.getSingleClassQueryExecutor(query, engine);
    }

    protected static IQueryExecutor getSingleClassQueryExecutor(InternalQuery query, SessionEngine engine) {
        if (CriteriaQueryImpl.class == query.getClass() || CriteriaQuery.class == query.getClass()) {
            return new CriteriaQueryExecutor(query, engine);
        }
        if (ValuesCriteriaQuery.class == query.getClass()) {
            return new ValuesCriteriaQueryExecutor(query, engine);
        }
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return new NativeQueryExecutor(query, engine);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    protected static IQueryExecutor getMultiClassQueryExecutor(InternalQuery query, SessionEngine engine) {
        if (CriteriaQueryImpl.class == query.getClass() || CriteriaQuery.class == query.getClass()) {
            return new MultiClassGenericQueryExecutor(new CriteriaQueryExecutor(query, engine));
        }
        if (ValuesCriteriaQuery.class == query.getClass()) {
            return new MultiClassGenericQueryExecutor(new ValuesCriteriaQueryExecutor(query, engine));
        }
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return new MultiClassGenericQueryExecutor(new NativeQueryExecutor(query, engine));
        }
        throw new NeoDatisRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }
}

