/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.CoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeIdentification;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.LazyObjectReference;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NativeAttributeHeader;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer3.BlockTypes;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesHelper;
import org.neodatis.odb.core.layers.layer3.BytesImpl;
import org.neodatis.odb.core.layers.layer3.ConversionContext;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.Layer3Converter;
import org.neodatis.odb.core.layers.layer3.Layer3Reader;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.layers.layer3.ReadSize;
import org.neodatis.odb.core.layers.layer4.StorageEngine;
import org.neodatis.odb.core.session.Session;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer3ReaderImpl
extends Layer3Converter
implements Layer3Reader {
    public static final String LOG_ID = "Layer3Reader";
    public static final String LOG_ID_DEBUG = "Layer3Reader.debug";
    protected DataConverter byteArrayConverter;
    protected StorageEngine layer4;
    private Session session;
    private boolean debug;

    public Layer3ReaderImpl(Session session, StorageEngine storageEngine) {
        this.session = session;
        this.layer4 = storageEngine;
        CoreProvider provider = session.getConfig().getCoreProvider();
        this.byteArrayConverter = provider.getByteArrayConverter(session.getConfig().debugLayers(), session.getConfig().getDatabaseCharacterEncoding(), session.getConfig());
        NATIVE_HEADER_BLOCK_SIZE_BYTE = new byte[4];
        BytesImpl b = new BytesImpl();
        this.byteArrayConverter.intToByteArray(NATIVE_HEADER_BLOCK_SIZE, b, 0, "init block size");
        NATIVE_HEADER_BLOCK_SIZE_BYTE = b.extract(0, 4);
        this.debug = session.getConfig().debugLayers();
    }

    @Override
    public NonNativeObjectInfo metaFromBytes(OidAndBytes oab, boolean full, int depth) {
        ConversionContext cc = new ConversionContext();
        cc.setDepth(depth);
        return this.internalFromBytes(oab, full, cc, 1);
    }

    @Override
    public NonNativeObjectInfo metaFromBytes(IOdbList<OidAndBytes> oabs, boolean full, Map<OID, OID> oidsToReplace, int depth) {
        ConversionContext cc = new ConversionContext(oabs, oidsToReplace);
        cc.setDepth(depth);
        return this.internalFromBytes(oabs.get(0), full, cc, 1);
    }

    protected NonNativeObjectInfo internalFromBytes(OidAndBytes oab, boolean full, ConversionContext context, int currentDepth) {
        NonNativeObjectInfo existingNnoi;
        if (this.debug) {
            DLogger.debug(String.format("\n** Converting bytes of oid %s to NNOI", oab.oid));
        }
        if ((existingNnoi = context.alreadyConvertedOids.get(oab.oid)) != null) {
            return new ObjectReference(existingNnoi);
        }
        ReadSize readSize = new ReadSize();
        Bytes bytesValues = oab.bytes;
        BytesHelper bytes = new BytesHelper(bytesValues, this.session.getConfig().debugLayers(), this.session.getConfig());
        int blockType = bytes.readInt(readSize.get(), readSize, "object type");
        ObjectOid oid = bytes.readObjectoid(readSize.get(), readSize, "oid");
        if (context.getDepth() != 0 && currentDepth > context.getDepth()) {
            ObjectOid ooid = (ObjectOid)oab.oid;
            return new LazyObjectReference(ooid, this.session.getMetaModel().getClassInfoFromId(oid.getClassOid()));
        }
        long creation = bytes.readLong(readSize.get(), readSize, "creation");
        long update = bytes.readLong(readSize.get(), readSize, "update");
        long version = bytes.readLong(readSize.get(), readSize, "version");
        boolean isSynchronized = bytes.readBoolean(readSize.get(), readSize, "is ext sync?");
        readSize.add(LONG_SIZE * 2);
        int nbAttributes = bytes.readInt(readSize.get(), readSize, "nb atributes");
        int headerPositionInfo = bytes.readInt(readSize.get(), readSize, "header position");
        if (this.debug) {
            DLogger.debug("  ** Start reading attributes header at " + headerPositionInfo);
        }
        ReadSize headerReadSize = new ReadSize();
        AttributeIdentification[] attributeIdentifications = this.bytesToHeader(bytes.bytes, nbAttributes, headerPositionInfo, headerReadSize, true);
        long totalObjectSize = bytes.readInt(headerPositionInfo + headerReadSize.get(), headerReadSize, "object size");
        int crc = bytes.readInt(headerPositionInfo + headerReadSize.get(), headerReadSize, "crc");
        int attributesPosition = readSize.get();
        if (this.debug) {
            DLogger.debug("  ** Start reading attributes values at " + attributesPosition);
        }
        if (!oid.equals(oab.oid)) {
            throw new NeoDatisRuntimeException(NeoDatisError.LAYER3_OID_DOES_OT_MATCH.addParameter(oab.oid).addParameter(oid).addParameter(16));
        }
        oab.oid = context.replaceOid(oab.oid);
        oid = (ObjectOid)oab.oid;
        ClassInfo ci = this.session.getMetaModel().getClassInfoFromId(oid.getClassOid());
        if (ci == null) {
            System.out.println("debug:ci is null for oid=" + oid);
        }
        NonNativeObjectInfo mainNnoi = new NonNativeObjectInfo(ci);
        mainNnoi.setOid(oid);
        ObjectInfoHeader oih = mainNnoi.getHeader();
        oih.setCreationDate(creation);
        oih.setObjectVersion(version);
        oih.setUpdateDate(update);
        oih.setAttributesIdentification(attributeIdentifications);
        oih.setAttributePosition(attributesPosition);
        context.alreadyConvertedOids.put(oid, mainNnoi);
        if (!full) {
            return mainNnoi;
        }
        for (int i = 0; i < nbAttributes; ++i) {
            ObjectOid aoid;
            AttributeIdentification ai = attributeIdentifications[i];
            if (ai.isNative) {
                NativeObjectInfo noi = this.bytesToNativeObject(bytes.bytes, ai.offset, readSize, context, currentDepth);
                mainNnoi.setAttributeValue(ai.id, noi);
                continue;
            }
            if (ai.oid.isNull()) {
                ObjectOid aoid2 = bytes.readObjectoid(readSize.get(), readSize, "oid");
                if (!aoid2.isNull()) {
                    throw new NeoDatisRuntimeException(NeoDatisError.LAYER3_OID_DOES_OT_MATCH.addParameter("null").addParameter(aoid2).addParameter(readSize.get()));
                }
                mainNnoi.setAttributeValue(ai.id, new NonNativeNullObjectInfo());
                continue;
            }
            OidAndBytes oab2 = context.getOabWithOid(ai.oid);
            if (oab2 == null) {
                oab2 = this.layer4.read(ai.oid, true);
            }
            if (!ai.oid.equals(aoid = bytes.readObjectoid(readSize.get(), readSize, "oid"))) {
                throw new NeoDatisRuntimeException(NeoDatisError.LAYER3_OID_DOES_OT_MATCH.addParameter(ai.oid).addParameter(aoid).addParameter(readSize.get()).addParameter(oid).addParameter(mainNnoi.getClassInfo().getFullClassName()).addParameter(mainNnoi.getClassInfo().getAttributeInfoFromId(ai.id).getName()));
            }
            if (oab2 != null) {
                NonNativeObjectInfo nnoi = this.internalFromBytes(oab2, true, context, currentDepth + 1);
                mainNnoi.setAttributeValue(ai.id, nnoi);
                continue;
            }
            mainNnoi.setAttributeValue(ai.id, new NonNativeNullObjectInfo());
        }
        int computedCrc = this.computeCrc(bytesValues);
        if (crc != computedCrc) {
            throw new NeoDatisRuntimeException(NeoDatisError.LAYER3_CRC_DOES_OT_MATCH.addParameter(oid).addParameter(crc).addParameter(computedCrc));
        }
        mainNnoi.getHeader().setAttributesIdentification(attributeIdentifications);
        if (this.debug) {
            DLogger.debug(String.format("  Object with OID %s has a size of %d", oid, totalObjectSize));
            DLogger.debug("  Attributes Identification of object with oid " + oid + " are " + DisplayUtility.toString(attributeIdentifications));
            DLogger.debug("** End Reading non native object with oid " + oid);
        }
        return mainNnoi;
    }

    private int computeCrc(Bytes bytesValues) {
        return 0;
    }

    @Override
    public AttributeValuesMap valuesFromBytes(OidAndBytes oab, HashSet<String> attributeNames, int depth) {
        ConversionContext cc = new ConversionContext();
        cc.setDepth(depth);
        return this.internalValuesFromBytes(oab, null, attributeNames, cc, 1);
    }

    protected AttributeValuesMap internalValuesFromBytes(OidAndBytes oab, String rootAttributeName, HashSet<String> attributeNames, ConversionContext context, int currentDepth) {
        if (this.debug) {
            DLogger.debug(String.format("Converting bytes of oid %s to Values for fields %s", oab.oid, attributeNames.toString()));
        }
        ReadSize readSize = new ReadSize();
        Bytes bytes = oab.bytes;
        ObjectOid oid = (ObjectOid)oab.oid;
        ObjectInfoHeader oih = this.internalFromBytes(oab, false, context, 0).getHeader();
        AttributeIdentification[] attributeIdentifications = oih.getAttributesIdentification();
        ClassInfo ci = this.session.getMetaModel().getClassInfoFromId(oih.getClassInfoId());
        AttributeValuesMap values = new AttributeValuesMap();
        values.setOid(oab.oid);
        HashMap<String, HashSet<String>> group = new HashMap<String, HashSet<String>>();
        HashSet set = null;
        for (String attributeName : attributeNames) {
            boolean mustNavigate;
            boolean bl = mustNavigate = attributeName.indexOf(".") != -1;
            if (mustNavigate) {
                set = (HashSet)group.get(attributeName);
                int firstDotIndex = attributeName.indexOf(".");
                String relationAttributeName = OdbString.substring(attributeName, firstDotIndex + 1);
                String singleAttributeName = OdbString.substring(attributeName, 0, firstDotIndex);
                if (set == null) {
                    set = new HashSet();
                    group.put(singleAttributeName, set);
                }
                set.add(relationAttributeName);
                continue;
            }
            set = (HashSet)group.get(null);
            if (set == null) {
                set = new HashSet();
                group.put(null, set);
            }
            set.add(attributeName);
        }
        HashMap<String, AttributeIdentification> attributesByName = new HashMap<String, AttributeIdentification>();
        for (AttributeIdentification ai : attributeIdentifications) {
            ClassAttributeInfo cai = ci.getAttributeInfoFromId(ai.id);
            if (cai == null) continue;
            attributesByName.put(cai.getName(), ai);
        }
        for (String attributeName : group.keySet()) {
            String fullAttributeName;
            HashSet set2;
            if (attributeName == null) {
                set2 = (HashSet)group.get(null);
                for (String aname : set2) {
                    AttributeIdentification ai;
                    ClassAttributeInfo cai = ci.getAttributeInfoFromName(aname);
                    if (cai == null) {
                        throw new NeoDatisRuntimeException(NeoDatisError.CRITERIA_QUERY_UNKNOWN_ATTRIBUTE.addParameter(aname).addParameter(ci.getFullClassName()));
                    }
                    if (cai.isNative()) {
                        ai = (AttributeIdentification)attributesByName.get(aname);
                        if (ai == null) continue;
                        NativeObjectInfo noi = this.bytesToNativeObject(bytes, ai.offset, readSize, context, currentDepth);
                        if (rootAttributeName == null) {
                            values.put(aname, noi.getObject());
                            continue;
                        }
                        String fullAttributeName2 = new StringBuffer(rootAttributeName).append(".").append(aname).toString();
                        values.put(fullAttributeName2, noi.getObject());
                        continue;
                    }
                    ai = (AttributeIdentification)attributesByName.get(aname);
                    if (rootAttributeName == null) {
                        values.put(aname, ai.oid);
                        continue;
                    }
                    fullAttributeName = new StringBuffer(rootAttributeName).append(".").append(aname).toString();
                    values.put(fullAttributeName, ai.oid);
                }
                continue;
            }
            set2 = (HashSet)group.get(attributeName);
            ClassAttributeInfo cai = ci.getAttributeInfoFromName(attributeName);
            AttributeIdentification ai = (AttributeIdentification)attributesByName.get(attributeName);
            ObjectOid aoid = ai.oid;
            if (aoid.isNull()) continue;
            OidAndBytes oab2 = this.layer4.read(aoid, true);
            fullAttributeName = attributeName;
            if (rootAttributeName != null) {
                fullAttributeName = new StringBuffer(rootAttributeName).append(".").append(attributeName).toString();
            }
            values.putAll(this.internalValuesFromBytes(oab2, fullAttributeName, set2, context, currentDepth + 1));
        }
        return values;
    }

    private AttributeIdentification[] bytesToHeader(Bytes bytes, int nbAttributes, int offset, ReadSize readSize, boolean withId) {
        AttributeIdentification[] attributeIdentifications = new AttributeIdentification[nbAttributes];
        ReadSize lreadSize = new ReadSize();
        int position = offset;
        int id = 0;
        block4: for (int i = 0; i < nbAttributes; ++i) {
            id = -1;
            if (withId) {
                id = this.byteArrayConverter.byteArrayToInt(bytes, position + lreadSize.get(), lreadSize, "attribute id");
            }
            byte type = this.byteArrayConverter.byteArrayToByte(bytes, position + lreadSize.get(), lreadSize, "type is native?");
            switch (type) {
                case 1: {
                    int aoffset = this.byteArrayConverter.byteArrayToInt(bytes, position + lreadSize.get(), lreadSize, "attribute offset");
                    attributeIdentifications[i] = new AttributeIdentification(aoffset, -1);
                    attributeIdentifications[i].id = id;
                    continue block4;
                }
                case 2: {
                    ObjectOid oid = this.byteArrayConverter.byteArrayToObjectOid(bytes, position + lreadSize.get(), lreadSize, "oid");
                    attributeIdentifications[i] = new AttributeIdentification(oid);
                    attributeIdentifications[i].id = id;
                    continue block4;
                }
                default: {
                    throw new NeoDatisRuntimeException(NeoDatisError.LAYER3_UNKNOWN_ATTRIBUTE_TYPE.addParameter(type));
                }
            }
        }
        readSize.add(lreadSize.get());
        return attributeIdentifications;
    }

    protected NativeAttributeHeader bytesToNativeObjectHeader(Bytes bytes, int offset, ReadSize readSize) {
        int blockSize = this.byteArrayConverter.byteArrayToInt(bytes, offset, readSize, "block size");
        byte blockType = this.byteArrayConverter.byteArrayToByte(bytes, offset + 4, readSize, "block type");
        int odbTypeId = this.byteArrayConverter.byteArrayToInt(bytes, offset + 5, readSize, "odb type id");
        boolean isNull = this.byteArrayConverter.byteArrayToBoolean(bytes, offset + 9, readSize, "is null?");
        return new NativeAttributeHeader(blockSize, blockType, odbTypeId, isNull);
    }

    public Object bytesToAtomicNativeObject(int odbTypeId, Bytes bytes, int offset, ReadSize readSize) {
        Object o = null;
        switch (odbTypeId) {
            case 20: 
            case 90: {
                o = new Byte(this.byteArrayConverter.byteArrayToByte(bytes, offset, readSize, "byte value"));
                break;
            }
            case 10: 
            case 160: {
                boolean b = this.byteArrayConverter.byteArrayToBoolean(bytes, offset, readSize, "bool value");
                if (b) {
                    o = Boolean.TRUE;
                    break;
                }
                o = Boolean.FALSE;
                break;
            }
            case 30: 
            case 150: {
                o = new Character(this.byteArrayConverter.byteArrayToChar(bytes, offset, readSize, "char value"));
                break;
            }
            case 70: 
            case 130: {
                o = new Float(this.byteArrayConverter.byteArrayToFloat(bytes, offset, readSize, "float value"));
                break;
            }
            case 80: 
            case 140: {
                o = new Double(this.byteArrayConverter.byteArrayToDouble(bytes, offset, readSize, "double value"));
                break;
            }
            case 50: 
            case 110: {
                o = new Integer(this.byteArrayConverter.byteArrayToInt(bytes, offset, readSize, "int value"));
                break;
            }
            case 60: 
            case 120: {
                o = new Long(this.byteArrayConverter.byteArrayToLong(bytes, offset, readSize, "long value"));
                break;
            }
            case 40: 
            case 100: {
                o = new Short(this.byteArrayConverter.byteArrayToShort(bytes, offset, readSize, "short value"));
                break;
            }
            case 200: {
                o = this.byteArrayConverter.byteArrayToBigDecimal(bytes, offset, readSize, "big decimal value");
                break;
            }
            case 190: {
                o = this.byteArrayConverter.byteArrayToBigInteger(bytes, offset, readSize, "big integer value");
                break;
            }
            case 170: {
                o = this.byteArrayConverter.byteArrayToDate(bytes, offset, readSize, "date value");
                break;
            }
            case 171: {
                o = new Date(this.byteArrayConverter.byteArrayToLong(bytes, offset, readSize, "date value"));
                break;
            }
            case 172: {
                o = new Timestamp(this.byteArrayConverter.byteArrayToLong(bytes, offset, readSize, "date value"));
                break;
            }
            case 173: 
            case 174: {
                Calendar c = Calendar.getInstance();
                c.setTime(this.byteArrayConverter.byteArrayToDate(bytes, offset, readSize, "date value"));
                o = c;
                break;
            }
            case 180: 
            case 181: 
            case 182: {
                o = this.byteArrayConverter.byteArrayToObjectOid(bytes, offset, readSize, "object oid value");
                break;
            }
            case 185: 
            case 186: 
            case 187: {
                o = this.byteArrayConverter.byteArrayToClassOid(bytes, offset, readSize, "class oid value");
                break;
            }
            case 210: {
                o = this.byteArrayConverter.byteArrayToString(bytes, true, offset, readSize, "string value");
                break;
            }
            case 211: {
                o = this.byteArrayConverter.byteArrayToString(bytes, false, offset, readSize, "enum value");
            }
        }
        if (o == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(odbTypeId).addParameter(ODBType.getNameFromId(odbTypeId)));
        }
        return o;
    }

    protected NativeObjectInfo bytesToAtomicNative(NativeAttributeHeader header, Bytes bytes, int offset, ReadSize readSize) {
        int odbTypeId = header.getOdbTypeId();
        Object o = this.bytesToAtomicNativeObject(odbTypeId, bytes, offset, readSize);
        return new AtomicNativeObjectInfo(o, odbTypeId);
    }

    protected NativeObjectInfo bytesToNativeObject(Bytes bytes, int offset, ReadSize readSize, ConversionContext context, int currentDepth) {
        try {
            if (this.debug) {
                DLogger.debug(" Start Reading native object at offset " + offset);
            }
            NativeAttributeHeader header = this.bytesToNativeObjectHeader(bytes, offset, readSize);
            int odbTypeId = header.getOdbTypeId();
            offset += NATIVE_HEADER_BLOCK_SIZE;
            if (header.isNull()) {
                NullNativeObjectInfo nullNativeObjectInfo = new NullNativeObjectInfo(odbTypeId);
                return nullNativeObjectInfo;
            }
            if (ODBType.isAtomicNative(odbTypeId)) {
                NativeObjectInfo nativeObjectInfo = this.bytesToAtomicNative(header, bytes, offset, readSize);
                return nativeObjectInfo;
            }
            if (ODBType.isCollection(odbTypeId)) {
                CollectionObjectInfo collectionObjectInfo = this.bytesToCollection(header, bytes, offset, readSize, context, currentDepth + 1);
                return collectionObjectInfo;
            }
            if (ODBType.isMap(odbTypeId)) {
                MapObjectInfo mapObjectInfo = this.bytesToMap(header, bytes, offset, readSize, context, currentDepth + 1);
                return mapObjectInfo;
            }
            if (ODBType.isArray(odbTypeId)) {
                ArrayObjectInfo arrayObjectInfo = this.bytesToArray(header, bytes, offset, readSize, context, currentDepth + 1);
                return arrayObjectInfo;
            }
            if (ODBType.isEnum(odbTypeId)) {
                EnumNativeObjectInfo enumNativeObjectInfo = this.bytesToEnum(header, bytes, offset, readSize, context);
                return enumNativeObjectInfo;
            }
            throw new NeoDatisRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(header.getOdbTypeId()));
        }
        finally {
            if (this.debug) {
                DLogger.debug(" End Reading native object at offset " + offset);
            }
        }
    }

    protected EnumNativeObjectInfo bytesToEnum(NativeAttributeHeader header, Bytes bytes, int offset, ReadSize readSize, ConversionContext context) {
        ReadSize lreadSize = new ReadSize();
        ClassOid enumClassOid = this.byteArrayConverter.byteArrayToClassOid(bytes, offset, lreadSize, "enum class id");
        String enumValue = this.byteArrayConverter.byteArrayToString(bytes, false, offset + lreadSize.get(), lreadSize, "enum value");
        readSize.add(lreadSize.get());
        return new EnumNativeObjectInfo(enumClassOid, enumValue);
    }

    protected CollectionObjectInfo bytesToCollection(NativeAttributeHeader header, Bytes bytes, int offset, ReadSize readSize, ConversionContext context, int currentDepth) {
        if (this.debug) {
            DLogger.debug("  <start reading collection at " + offset + ">");
        }
        ReadSize localReadSize = new ReadSize();
        String realCollectionClassName = this.byteArrayConverter.byteArrayToString(bytes, false, offset, localReadSize, "real collection class");
        int size = this.byteArrayConverter.byteArrayToInt(bytes, offset + localReadSize.get(), localReadSize, "collection size");
        ReadSize headerReadSize = new ReadSize();
        int headerPosition = this.byteArrayConverter.byteArrayToInt(bytes, offset + localReadSize.get(), localReadSize, "header position");
        AttributeIdentification[] attributeIdentifications = this.bytesToHeader(bytes, size, headerPosition, headerReadSize, false);
        ArrayList<AbstractObjectInfo> c = new ArrayList<AbstractObjectInfo>();
        ArrayList<NonNativeObjectInfo> nnois = new ArrayList<NonNativeObjectInfo>();
        for (int i = 0; i < size; ++i) {
            AttributeIdentification ai = attributeIdentifications[i];
            if (ai.isNative) {
                NativeObjectInfo noi = this.bytesToNativeObject(bytes, offset + localReadSize.get(), localReadSize, context, currentDepth);
                c.add(noi);
                continue;
            }
            OidAndBytes oab = context.getOabWithOid(ai.oid);
            if (oab == null) {
                oab = this.layer4.read(ai.oid, true);
            }
            if (oab == null) continue;
            NonNativeObjectInfo nnoi = this.internalFromBytes(oab, true, context, currentDepth + 1);
            c.add(nnoi);
            nnois.add(nnoi);
        }
        CollectionObjectInfo coi = new CollectionObjectInfo(c, nnois);
        coi.setRealCollectionClassName(realCollectionClassName);
        int totalSize = localReadSize.get() + headerReadSize.get();
        if (this.debug) {
            DLogger.debug("  <end reading collection at " + offset + " size=" + totalSize + ">");
        }
        readSize.add(totalSize);
        return coi;
    }

    protected MapObjectInfo bytesToMap(NativeAttributeHeader header, Bytes bytes, int offset, ReadSize readSize, ConversionContext context, int currentDepth) {
        if (this.debug) {
            DLogger.debug("  <start reading map at " + offset + ">");
        }
        ReadSize localReadSize = new ReadSize();
        String realMapClassName = this.byteArrayConverter.byteArrayToString(bytes, false, offset, localReadSize, "real collection class");
        int size = this.byteArrayConverter.byteArrayToInt(bytes, offset + localReadSize.get(), localReadSize, "map size size");
        int headerPosition = this.byteArrayConverter.byteArrayToInt(bytes, offset + localReadSize.get(), localReadSize, "header position");
        ReadSize headerReadSize = new ReadSize();
        AttributeIdentification[] attributeIdentifications = this.bytesToHeader(bytes, size * 2, headerPosition, headerReadSize, false);
        HashMap<NativeObjectInfo, NativeObjectInfo> m = new HashMap<NativeObjectInfo, NativeObjectInfo>();
        ArrayList<NonNativeObjectInfo> nnois = new ArrayList<NonNativeObjectInfo>();
        for (int i = 0; i < size; ++i) {
            OidAndBytes oab;
            AttributeIdentification aiKey = attributeIdentifications[2 * i];
            AttributeIdentification aiValue = attributeIdentifications[2 * i + 1];
            AbstractObjectInfo keyAoi = null;
            AbstractObjectInfo valueAoi = null;
            if (aiKey.isNative) {
                keyAoi = this.bytesToNativeObject(bytes, offset + localReadSize.get(), localReadSize, context, currentDepth);
            } else {
                oab = context.getOabWithOid(aiKey.oid);
                if (oab == null) {
                    oab = this.layer4.read(aiKey.oid, true);
                }
                if (oab != null) {
                    keyAoi = this.internalFromBytes(oab, true, context, currentDepth + 1);
                }
                nnois.add((NonNativeObjectInfo)keyAoi);
            }
            if (aiValue.isNative) {
                valueAoi = this.bytesToNativeObject(bytes, offset + localReadSize.get(), localReadSize, context, currentDepth);
            } else {
                oab = context.getOabWithOid(aiValue.oid);
                if (oab == null) {
                    oab = this.layer4.read(aiValue.oid, true);
                }
                valueAoi = oab != null ? this.internalFromBytes(oab, true, context, currentDepth + 1) : new NonNativeNullObjectInfo();
                nnois.add((NonNativeObjectInfo)valueAoi);
            }
            m.put((NativeObjectInfo)keyAoi, (NativeObjectInfo)valueAoi);
        }
        MapObjectInfo moi = new MapObjectInfo(m, realMapClassName);
        moi.setNonNativeObjects(nnois);
        if (this.debug) {
            DLogger.debug("  <end reading map at " + offset + ">");
        }
        readSize.add(localReadSize.get());
        return moi;
    }

    protected ArrayObjectInfo bytesToArray(NativeAttributeHeader header, Bytes bytes, int offset, ReadSize readSize, ConversionContext context, int currentDepth) {
        if (this.debug) {
            DLogger.debug("  <start reading array at " + offset + ">");
        }
        ReadSize localReadSize = new ReadSize();
        String realElementTypeClassName = this.byteArrayConverter.byteArrayToString(bytes, false, offset, localReadSize, "real array type");
        int size = this.byteArrayConverter.byteArrayToInt(bytes, offset + localReadSize.get(), localReadSize, "array size");
        ReadSize headerReadSize = new ReadSize();
        int headerPosition = this.byteArrayConverter.byteArrayToInt(bytes, offset + localReadSize.get(), localReadSize, "header position");
        AttributeIdentification[] attributeIdentifications = this.bytesToHeader(bytes, size, headerPosition, headerReadSize, false);
        AbstractObjectInfo[] array = new AbstractObjectInfo[size];
        for (int i = 0; i < size; ++i) {
            AttributeIdentification ai = attributeIdentifications[i];
            if (ai.isNative) {
                NativeObjectInfo noi = this.bytesToNativeObject(bytes, offset + localReadSize.get(), localReadSize, context, currentDepth);
                array[i] = noi;
                continue;
            }
            if (ai.oid.isNull()) {
                array[i] = new NonNativeNullObjectInfo();
                continue;
            }
            OidAndBytes oab = context.getOabWithOid(ai.oid);
            if (oab == null) {
                oab = this.layer4.read(ai.oid, true);
            }
            if (oab == null) continue;
            NonNativeObjectInfo nnoi = this.internalFromBytes(oab, true, context, currentDepth + 1);
            array[i] = nnoi;
        }
        ArrayObjectInfo aoi = new ArrayObjectInfo(array);
        aoi.setRealArrayComponentClassName(realElementTypeClassName);
        int totalSize = localReadSize.get() + headerReadSize.get();
        if (this.debug) {
            DLogger.debug("  <end reading array at " + offset + " size=" + totalSize + ">");
        }
        readSize.add(totalSize);
        return aoi;
    }

    protected AttributeIdentification enumNativeObjectToBytes(EnumNativeObjectInfo anoi, Bytes bytes, int offset) {
        return null;
    }

    @Override
    public ClassInfo classInfoFromBytes(OidAndBytes oidAndBytes, boolean full) {
        ClassOid coid = (ClassOid)oidAndBytes.oid;
        Bytes bytes = oidAndBytes.bytes;
        if (this.debug) {
            DLogger.debug("reading class info with oid " + coid);
        }
        ReadSize readSize = new ReadSize();
        int checkSum = this.byteArrayConverter.byteArrayToInt(bytes, readSize.get(), readSize, "ci check sum");
        int blockSize = this.byteArrayConverter.byteArrayToInt(bytes, readSize.get(), readSize, "class info block size");
        byte blockType = this.byteArrayConverter.byteArrayToByte(bytes, readSize.get(), readSize, "class info block type");
        if (!BlockTypes.isClassHeader(blockType)) {
            throw new NeoDatisRuntimeException(NeoDatisError.WRONG_TYPE_FOR_BLOCK_TYPE.addParameter("Class Header").addParameter(blockType).addParameter(coid));
        }
        byte classInfoCategory = this.byteArrayConverter.byteArrayToByte(bytes, readSize.get(), readSize, "class info category");
        ClassInfo classInfo = new ClassInfo();
        classInfo.setClassCategory(classInfoCategory);
        ClassOid oid2 = this.byteArrayConverter.byteArrayToClassOid(bytes, readSize.get(), readSize, "ci oid");
        if (!coid.equals(oid2)) {
            throw new NeoDatisRuntimeException(NeoDatisError.LAYER3_OID_DOES_OT_MATCH.addParameter(coid).addParameter(oid2).addParameter(readSize.get()));
        }
        classInfo.setOid(coid);
        ClassOid superClassOid = this.byteArrayConverter.byteArrayToClassOid(bytes, readSize.get(), readSize, "ci super class oid");
        if (!superClassOid.isNull()) {
            classInfo.setSuperClassOid(superClassOid);
        }
        classInfo.setFullClassName(this.byteArrayConverter.byteArrayToString(bytes, false, readSize.get(), readSize, "ci class name"));
        classInfo.setMaxAttributeId(this.byteArrayConverter.byteArrayToInt(bytes, readSize.get(), readSize, "ci max attribute id"));
        if (!full) {
            return classInfo;
        }
        int nbAttributes = this.byteArrayConverter.byteArrayToInt(bytes, readSize.get(), readSize, "ci nb attributes");
        OdbArrayList<ClassAttributeInfo> attributes = new OdbArrayList<ClassAttributeInfo>(nbAttributes);
        for (int i = 0; i < nbAttributes; ++i) {
            ClassAttributeInfo cai = this.classAttributeInfoFromBytes(bytes, readSize);
            if (cai == null) {
                String msg = "Class " + classInfo.getFullClassName() + " does not have attribute wth id " + i;
            }
            cai.setOwnerClassInfoOid(coid);
            attributes.add(cai);
        }
        classInfo.setAttributes(attributes);
        if (blockSize != readSize.get()) {
            throw new NeoDatisRuntimeException(NeoDatisError.WRONG_BLOCK_SIZE.addParameter(blockSize).addParameter(readSize.get()).addParameter(classInfo.getAttributesDefinitionPosition()));
        }
        return classInfo;
    }

    private ClassAttributeInfo classAttributeInfoFromBytes(Bytes bytes, ReadSize readSize) {
        ClassAttributeInfo cai = new ClassAttributeInfo();
        int attributeId = this.byteArrayConverter.byteArrayToInt(bytes, readSize.get(), readSize, "attribute id");
        boolean isNative = this.byteArrayConverter.byteArrayToBoolean(bytes, readSize.get(), readSize, "att is native?");
        if (isNative) {
            int attributeTypeId = this.byteArrayConverter.byteArrayToInt(bytes, readSize.get(), readSize, "attribute type id");
            ODBType type = ODBType.getFromId(attributeTypeId);
            if (type.isArray()) {
                type = type.copy();
                int subTypeId = this.byteArrayConverter.byteArrayToInt(bytes, readSize.get(), readSize, "array subtype id");
                ODBType subType = ODBType.getFromId(subTypeId);
                if (subType.isNonNative()) {
                    subType = subType.copy();
                    ClassOid coid = this.byteArrayConverter.byteArrayToClassOid(bytes, readSize.get(), readSize, "array subtype class id");
                    ClassInfo ci = this.session.getMetaModel().getClassInfoFromId(coid);
                    subType.setName(ci.getFullClassName());
                }
                type.setSubType(subType);
            }
            cai.setAttributeType(type);
            if (type.isEnum()) {
                ClassOid ciId = this.byteArrayConverter.byteArrayToClassOid(bytes, readSize.get(), readSize, "enum ci id");
                MetaModel metaModel = this.session.getMetaModel();
                cai.setAttributeClassOid(ciId);
                type = type.copy();
                cai.setAttributeType(type);
            } else {
                cai.setClassName(cai.getAttributeType().getName());
            }
        } else {
            MetaModel metaModel = this.session.getMetaModel();
            ClassOid attributeCiId = this.byteArrayConverter.byteArrayToClassOid(bytes, readSize.get(), readSize, "attribute ci id");
            ClassInfo ci = metaModel.getClassInfoFromId(attributeCiId);
            if (attributeCiId.isNull()) {
                return null;
            }
            if (ci == null) {
                String s = "ClassInfo with with id " + attributeCiId + " does not exist in the metamodel";
                DLogger.error(s);
                throw new NeoDatisRuntimeException(s);
            }
            cai.setClassName(ci.getFullClassName());
            cai.setAttributeClassOid(attributeCiId);
            cai.setAttributeType(ODBType.getFromName(cai.getClassName()));
        }
        cai.setName(this.byteArrayConverter.byteArrayToString(bytes, false, readSize.get(), readSize, "attribute name"));
        cai.setId(attributeId);
        return cai;
    }
}

