/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import org.neodatis.tool.DLogger;

public class DataConverterUtil {
    public static int INT_SIZE = 4;
    public static int LONG_SIZE = 8;

    public static int intToByteArray(int l, byte[] arrayWhereToWrite, int offset, String label, boolean debug) {
        int i = 0;
        int shift = 24;
        while (i < 4) {
            arrayWhereToWrite[offset + i] = (byte)(0xFF & l >> shift);
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : int '%d' : %s", offset, l, label));
        }
        return INT_SIZE;
    }

    public static int longToByteArray(long l, byte[] arrayWhereToWrite, int offset, String label, boolean debug) {
        int i = 0;
        int shift = 56;
        while (i < 8) {
            arrayWhereToWrite[i + offset] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
        if (debug) {
            DLogger.debug(String.format("    writing at %d : long '%d' : %s", offset, l, label));
        }
        return LONG_SIZE;
    }

    public static long byteArrayToLong(byte[] bytes, int offset, String label, boolean debug) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(bytes[offset + i] & 0xFF);
        }
        if (debug) {
            DLogger.debug(String.format("     reading at %d : long %d : %s", offset, result, label));
        }
        return result;
    }

    public static int byteArrayToInt(byte[] bytes, int offset, String label, boolean debug) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= bytes[offset + i] & 0xFF;
        }
        if (debug) {
            DLogger.debug(String.format("     reading at %d : int '%d' : %s", offset, result, label));
        }
        return result;
    }
}

