/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
implements Serializable {
    public static final byte CATEGORY_SYSTEM_CLASS = 1;
    public static final byte CATEGORY_USER_CLASS = 2;
    private static final long serialVersionUID = 1L;
    private byte classCategory = (byte)2;
    private String fullClassName;
    private String extraInfo;
    private IOdbList<ClassAttributeInfo> attributes;
    private Map<String, ClassAttributeInfo> attributesByName;
    private Map<Integer, ClassAttributeInfo> attributesById;
    private ClassOid coid;
    private long attributesDefinitionPosition;
    private ObjectInfoHeader lastObjectInfoHeader;
    private int maxAttributeId = -1;
    private ClassOid superClassOid;
    private IOdbList<ClassInfoIndex> indexes;

    public ClassInfo() {
    }

    public ClassInfo(String className) {
        this(className, "", null);
    }

    public ClassInfo(String className, String extraInfo) {
        this(className, extraInfo, null);
    }

    protected ClassInfo(String fullClassName, String extraInfo, IOdbList<ClassAttributeInfo> attributes) {
        this();
        this.fullClassName = fullClassName;
        this.extraInfo = extraInfo;
        this.attributes = attributes;
        this.attributesByName = new OdbHashMap<String, ClassAttributeInfo>();
        this.attributesById = new OdbHashMap<Integer, ClassAttributeInfo>();
        if (attributes != null) {
            this.fillAttributesMap();
        } else {
            this.attributes = new OdbArrayList<ClassAttributeInfo>();
        }
        this.maxAttributeId = attributes == null ? 1 : attributes.size() + 1;
    }

    public void fillAttributesMap() {
        ClassAttributeInfo cai = null;
        if (this.attributesByName == null) {
            this.attributesByName = new OdbHashMap<String, ClassAttributeInfo>();
            this.attributesById = new OdbHashMap<Integer, ClassAttributeInfo>();
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            cai = this.attributes.get(i);
            this.attributesByName.put(cai.getName(), cai);
            this.attributesById.put(new Integer(cai.getId()), cai);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ClassInfo.class) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)obj;
        return classInfo.fullClassName.equals(this.fullClassName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" [ ").append(this.fullClassName).append(" - id=").append(this.coid);
        buffer.append(" - attributes=(");
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.size(); ++i) {
                ClassAttributeInfo cai = this.attributes.get(i);
                buffer.append(cai.getName()).append(",");
            }
        } else {
            buffer.append("not yet defined");
        }
        buffer.append(") ]");
        return buffer.toString();
    }

    public IOdbList<ClassAttributeInfo> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IOdbList<ClassAttributeInfo> attributes) {
        this.attributes = attributes;
        this.maxAttributeId = Math.max(this.maxAttributeId, attributes.size());
        this.fillAttributesMap();
    }

    public long getAttributesDefinitionPosition() {
        return this.attributesDefinitionPosition;
    }

    public void setAttributesDefinitionPosition(long definitionPosition) {
        this.attributesDefinitionPosition = definitionPosition;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public IOdbList<ClassAttributeInfo> getAllNonNativeAttributes() {
        OdbArrayList<ClassAttributeInfo> result = new OdbArrayList<ClassAttributeInfo>(this.attributes.size());
        ClassAttributeInfo cai = null;
        for (int i = 0; i < this.attributes.size(); ++i) {
            cai = this.attributes.get(i);
            if (!cai.isNative() || cai.getAttributeType().isEnum()) {
                result.add(cai);
                continue;
            }
            if (!cai.getAttributeType().isArray() || cai.getAttributeType().getSubType().isNative()) continue;
            result.add(new ClassAttributeInfo(-1, "subtype", cai.getAttributeType().getSubType().getName(), cai.getAttributeClassOid(), cai.getOwnerClassInfoOid()));
        }
        return result;
    }

    public ClassOid getOid() {
        return this.coid;
    }

    public void setOid(ClassOid id) {
        this.coid = id;
    }

    public ClassAttributeInfo getAttributeInfoFromId(int id) {
        return this.attributesById.get(new Integer(id));
    }

    public int getAttributeId(String name) {
        ClassAttributeInfo cai;
        if (this.attributesByName == null) {
            System.out.println("attributesByName is null");
        }
        if ((cai = this.attributesByName.get(name)) == null) {
            return -1;
        }
        return cai.getId();
    }

    public ClassAttributeInfo getAttributeInfoFromName(String name) {
        return this.attributesByName.get(name);
    }

    public ClassAttributeInfo getAttributeInfo(int index) {
        return this.attributes.get(index);
    }

    public int getMaxAttributeId() {
        return this.maxAttributeId;
    }

    public void setMaxAttributeId(int maxAttributeId) {
        this.maxAttributeId = maxAttributeId;
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public ClassInfoIndex addIndexOn(String name, String[] indexFields, boolean acceptMultipleValuesForSameKey) {
        if (this.indexes == null) {
            this.indexes = new OdbArrayList<ClassInfoIndex>();
        }
        ClassInfoIndex cii = new ClassInfoIndex();
        cii.setClassInfoId(this.coid);
        cii.setCreationDate(OdbTime.getCurrentTimeInMs());
        cii.setLastRebuild(cii.getCreationDate());
        cii.setName(name);
        cii.setStatus((byte)1);
        cii.setUnique(!acceptMultipleValuesForSameKey);
        int[] attributeIds = new int[indexFields.length];
        for (int i = 0; i < indexFields.length; ++i) {
            attributeIds[i] = this.getAttributeId(indexFields[i]);
            if (attributeIds[i] != -1) continue;
            throw new NeoDatisRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getFullClassName()).addParameter(indexFields[i]));
        }
        cii.setAttributeIds(attributeIds);
        this.indexes.add(cii);
        return cii;
    }

    public void removeIndex(ClassInfoIndex cii) {
        this.indexes.remove(cii);
    }

    public int getNumberOfIndexes() {
        if (this.indexes == null) {
            return 0;
        }
        return this.indexes.size();
    }

    public ClassInfoIndex getIndex(int index) {
        if (this.indexes == null || index >= this.indexes.size()) {
            throw new NeoDatisRuntimeException(NeoDatisError.INDEX_NOT_FOUND.addParameter(this.getFullClassName()).addParameter(index));
        }
        return this.indexes.get(index);
    }

    public void setIndexes(IOdbList<ClassInfoIndex> indexes2) {
        this.indexes = indexes2;
    }

    public byte getClassCategory() {
        return this.classCategory;
    }

    public void setClassCategory(byte classInfoType) {
        this.classCategory = classInfoType;
    }

    public ObjectInfoHeader getLastObjectInfoHeader() {
        return this.lastObjectInfoHeader;
    }

    public void setLastObjectInfoHeader(ObjectInfoHeader lastObjectInfoHeader) {
        this.lastObjectInfoHeader = lastObjectInfoHeader;
    }

    public boolean isSystemClass() {
        return this.classCategory == 1;
    }

    public ClassInfoIndex getIndexWithName(String name) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return null;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (!cii.getName().equals(name)) continue;
            return cii;
        }
        return null;
    }

    public ClassInfoIndex getIndexForAttributeId(int attributeId) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return null;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (cii.getAttributeIds().length != 1 || cii.getAttributeId(0) != attributeId) continue;
            return cii;
        }
        return null;
    }

    public ClassInfoIndex getIndexForAttributeIds(int[] attributeIds) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return null;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (!cii.matchAttributeIds(attributeIds)) continue;
            return cii;
        }
        return null;
    }

    public String[] getAttributeNames(int[] attributeIds) {
        int nbIds = attributeIds.length;
        String[] names = new String[nbIds];
        for (int i = 0; i < nbIds; ++i) {
            names[i] = this.getAttributeInfoFromId(attributeIds[i]).getName();
        }
        return names;
    }

    public List<String> getAttributeNamesAsList(int[] attributeIds) {
        int nbIds = attributeIds.length;
        ArrayList<String> names = new ArrayList<String>(attributeIds.length);
        for (int i = 0; i < nbIds; ++i) {
            names.add(this.getAttributeInfoFromId(attributeIds[i]).getName());
        }
        return names;
    }

    public IOdbList<ClassInfoIndex> getIndexes() {
        if (this.indexes == null) {
            return new OdbArrayList<ClassInfoIndex>();
        }
        return this.indexes;
    }

    public void removeAttribute(ClassAttributeInfo cai) {
        this.attributes.remove(cai);
        this.attributesByName.remove(cai.getName());
    }

    public void addAttribute(ClassAttributeInfo cai) {
        cai.setId(this.maxAttributeId++);
        this.attributes.add(cai);
        this.attributesByName.put(cai.getName(), cai);
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
    }

    public boolean hasIndex(String indexName) {
        ClassInfoIndex cii = null;
        if (this.indexes == null) {
            return false;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            cii = this.indexes.get(i);
            if (!indexName.equals(cii.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndex() {
        return this.indexes != null && !this.indexes.isEmpty();
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public ClassInfo duplicate(boolean onlyData) {
        ClassInfo ci = new ClassInfo(this.fullClassName);
        ci.extraInfo = this.extraInfo;
        ci.setAttributes(this.attributes);
        ci.setClassCategory(this.classCategory);
        ci.setMaxAttributeId(this.maxAttributeId);
        if (onlyData) {
            return ci;
        }
        ci.setAttributesDefinitionPosition(this.attributesDefinitionPosition);
        ci.setExtraInfo(this.extraInfo);
        ci.setOid(this.coid);
        ci.setLastObjectInfoHeader(this.lastObjectInfoHeader);
        ci.setIndexes(this.indexes);
        return ci;
    }

    public ClassOid getSuperClassOid() {
        return this.superClassOid;
    }

    public void setSuperClassOid(ClassOid superClassOid) {
        this.superClassOid = superClassOid;
    }
}

