/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer1;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.context.ObjectReconnector;
import org.neodatis.odb.core.layers.layer1.ClassIntrospector;
import org.neodatis.odb.core.layers.layer1.IntrospectionCallback;
import org.neodatis.odb.core.layers.layer1.ObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeIdentification;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.session.Cache;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.trigger.TriggerManager;
import org.neodatis.tool.wrappers.OdbReflection;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIntrospectorImpl
implements ObjectIntrospector {
    protected ClassIntrospector classIntrospector;
    protected Session session;
    protected OidGenerator oidGenerator;
    protected ObjectReconnector objectReconnector;
    protected TriggerManager triggerManager;

    public ObjectIntrospectorImpl(Session session, ClassIntrospector classIntrospector, OidGenerator oidGenerator) {
        this.session = session;
        this.classIntrospector = classIntrospector;
        this.oidGenerator = oidGenerator;
        if (session.getConfig().reconnectObjectsToSession()) {
            this.objectReconnector = new ObjectReconnector();
        }
    }

    @Override
    public NonNativeObjectInfo getMetaRepresentation(Object object, IntrospectionCallback callback) {
        return (NonNativeObjectInfo)this.getObjectInfoInternal(object, new HashMap<Object, NonNativeObjectInfo>(), callback);
    }

    @Override
    public AbstractObjectInfo getGenericMetaRepresentation(Object object, IntrospectionCallback callback) {
        return this.getObjectInfoInternal(object, new HashMap<Object, NonNativeObjectInfo>(), callback);
    }

    protected AbstractObjectInfo getObjectInfoInternal(Object object, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IntrospectionCallback callback) {
        Object value = null;
        if (object == null) {
            return NullNativeObjectInfo.getInstance();
        }
        Class<?> clazz = object.getClass();
        ODBType type = ODBType.getFromClass(clazz);
        String className = clazz.getName();
        if (type.isNative()) {
            return this.getNativeObjectInfoInternal(type, object, alreadyReadObjects, callback);
        }
        ClassInfo ci = this.getClassInfo(className);
        NonNativeObjectInfo mainAoi = this.buildNnoi(object, ci, null, null);
        boolean isRootObject = false;
        if (alreadyReadObjects == null) {
            alreadyReadObjects = new OdbHashMap<Object, NonNativeObjectInfo>();
            isRootObject = true;
        }
        if (object != null) {
            NonNativeObjectInfo cachedNnoi = alreadyReadObjects.get(object);
            if (cachedNnoi != null) {
                ObjectReference or = new ObjectReference(cachedNnoi);
                return or;
            }
            this.objectFound(object, mainAoi.getOid(), callback);
        }
        alreadyReadObjects.put(object, mainAoi);
        IOdbList<Field> fields = this.classIntrospector.getAllFields(className);
        AbstractObjectInfo aoi = null;
        int attributeId = -1;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            try {
                value = field.get(object);
                attributeId = ci.getAttributeId(field.getName());
                if (attributeId == -1) {
                    throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_INTROSPECTOR_NO_FIELD_WITH_NAME.addParameter(ci.getFullClassName()).addParameter(field.getName()));
                }
                ODBType valueType = null;
                valueType = value == null ? ODBType.getFromClass(field.getType()) : ODBType.getFromClass(value.getClass());
                if (valueType.isNative()) {
                    aoi = this.getNativeObjectInfoInternal(valueType, value, alreadyReadObjects, callback);
                    mainAoi.setAttributeValue(attributeId, aoi);
                    continue;
                }
                ClassInfo clai = this.getClassInfo(valueType.getName());
                if (value == null) {
                    aoi = new NonNativeNullObjectInfo();
                    mainAoi.setAttributeValue(attributeId, aoi);
                    continue;
                }
                aoi = this.getObjectInfoInternal(value, alreadyReadObjects, callback);
                mainAoi.setAttributeValue(attributeId, aoi);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in getObjectInfoInternal"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("getObjectInfoInternal"), (Throwable)e);
            }
        }
        if (isRootObject) {
            alreadyReadObjects.clear();
            alreadyReadObjects = null;
        }
        return mainAoi;
    }

    protected void objectFound(Object object, ObjectOid objectOid, IntrospectionCallback callback) {
        if (callback != null) {
            callback.objectFound(object, objectOid);
        }
    }

    protected TriggerManager getTriggerManager() {
        if (this.triggerManager == null) {
            this.triggerManager = this.session.getEngine().getTriggerManager();
        }
        return this.triggerManager;
    }

    @Override
    public NonNativeObjectInfo buildNnoi(Object object, ClassInfo classInfo, AbstractObjectInfo[] values, AttributeIdentification[] attributesIdentification) {
        NonNativeObjectInfo nnoi = new NonNativeObjectInfo(object, classInfo, values, attributesIdentification);
        if (this.session != null) {
            Cache cache = this.session.getCache();
            ObjectOid oid = cache.getOid(object, false);
            if (oid != null) {
                oid.setIsNew(false);
                nnoi.setOid(oid);
                ObjectInfoHeader oih = null;
                if (oih != null) {
                    nnoi.getHeader().setObjectVersion(oih.getObjectVersion());
                    nnoi.getHeader().setUpdateDate(oih.getUpdateDate());
                    nnoi.getHeader().setCreationDate(oih.getCreationDate());
                }
            } else {
                boolean reconnected = false;
                if (this.objectReconnector != null) {
                    reconnected = this.objectReconnector.tryToReconnect(object, nnoi);
                }
                if (reconnected) {
                    return nnoi;
                }
                oid = this.getNextObjectOid(classInfo);
                oid.setIsNew(true);
                nnoi.setOid(oid);
                cache.addObject(oid, object);
                String fullClassName = classInfo.getFullClassName();
                if (this.getTriggerManager().hasOidTriggersFor(fullClassName)) {
                    this.getTriggerManager().manageOidTrigger(fullClassName, object, oid);
                }
            }
        }
        return nnoi;
    }

    private ObjectOid getNextObjectOid(ClassInfo classInfo) {
        if (this.oidGenerator == null) {
            this.oidGenerator = this.session.getEngine().getStorageEngine().getOidGenerator();
        }
        return this.oidGenerator.createObjectOid(classInfo.getOid());
    }

    protected AbstractObjectInfo getNativeObjectInfoInternal(ODBType type, Object object, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IntrospectionCallback callback) {
        Object aoi = null;
        if (type.isAtomicNative()) {
            if (object == null) {
                return new NullNativeObjectInfo(type.getId());
            }
            return new AtomicNativeObjectInfo(object, type.getId());
        }
        if (type.isCollection()) {
            return this.introspectCollection((Collection)object, alreadyReadObjects, type, callback);
        }
        if (type.isArray()) {
            if (object == null) {
                return new ArrayObjectInfo(null);
            }
            String realArrayClassName = object.getClass().getComponentType().getName();
            ArrayObjectInfo aroi = null;
            aroi = this.introspectArray(object, alreadyReadObjects, type, callback);
            aroi.setRealArrayComponentClassName(realArrayClassName);
            return aroi;
        }
        if (type.isMap()) {
            if (object == null) {
                return new MapObjectInfo(null, type, type.getDefaultInstanciationClass().getName());
            }
            MapObjectInfo moi = this.introspectMap((Map)object, alreadyReadObjects, callback);
            if (moi.getRealMapClassName().indexOf("$") != -1) {
                moi.setRealMapClassName(type.getDefaultInstanciationClass().getName());
            }
            return moi;
        }
        if (type.isEnum()) {
            Enum enumObject = (Enum)object;
            if (enumObject == null) {
                return new NullNativeObjectInfo(type.getId());
            }
            String enumClassName = enumObject == null ? null : enumObject.getClass().getName();
            ClassInfo ci = this.getClassInfo(enumClassName);
            String enumValue = enumObject == null ? null : enumObject.name();
            return new EnumNativeObjectInfo(ci, enumValue);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter(String.format("Unsupported type %s", type.getId())));
    }

    private CollectionObjectInfo introspectCollection(Collection collection, Map<Object, NonNativeObjectInfo> alreadyReadObjects, ODBType type, IntrospectionCallback callback) {
        if (collection == null) {
            return new CollectionObjectInfo();
        }
        ArrayList<AbstractObjectInfo> collectionCopy = new ArrayList<AbstractObjectInfo>(collection.size());
        ArrayList<NonNativeObjectInfo> nonNativesObjects = new ArrayList<NonNativeObjectInfo>(collection.size());
        AbstractObjectInfo aoi = null;
        for (Object o : collection) {
            Object ci = null;
            if (o == null) continue;
            aoi = this.getObjectInfoInternal(o, alreadyReadObjects, callback);
            collectionCopy.add(aoi);
            if (!aoi.isNonNativeObject()) continue;
            nonNativesObjects.add((NonNativeObjectInfo)aoi);
        }
        CollectionObjectInfo coi = new CollectionObjectInfo(collectionCopy, nonNativesObjects);
        String realCollectionClassName = collection.getClass().getName();
        if (realCollectionClassName.indexOf("$") != -1) {
            coi.setRealCollectionClassName(type.getDefaultInstanciationClass().getName());
        } else {
            coi.setRealCollectionClassName(realCollectionClassName);
        }
        return coi;
    }

    private MapObjectInfo introspectMap(Map map, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IntrospectionCallback callback) {
        OdbHashMap<AbstractObjectInfo, AbstractObjectInfo> mapCopy = new OdbHashMap<AbstractObjectInfo, AbstractObjectInfo>();
        ArrayList<NonNativeObjectInfo> nonNativeObjects = new ArrayList<NonNativeObjectInfo>(map.size() * 2);
        Set keySet = map.keySet();
        Iterator keys = keySet.iterator();
        ClassInfo ciKey = null;
        ClassInfo ciValue = null;
        AbstractObjectInfo aoiForKey = null;
        AbstractObjectInfo aoiForValue = null;
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = map.get(key);
            if (key == null) continue;
            ciKey = this.getClassInfo(key.getClass().getName());
            if (value != null) {
                ciValue = this.getClassInfo(value.getClass().getName());
            }
            aoiForKey = this.getObjectInfoInternal(key, alreadyReadObjects, callback);
            aoiForValue = this.getObjectInfoInternal(value, alreadyReadObjects, callback);
            mapCopy.put(aoiForKey, aoiForValue);
            if (aoiForKey.isNonNativeObject()) {
                nonNativeObjects.add((NonNativeObjectInfo)aoiForKey);
            }
            if (!aoiForValue.isNonNativeObject()) continue;
            nonNativeObjects.add((NonNativeObjectInfo)aoiForValue);
        }
        MapObjectInfo mapObjectInfo = new MapObjectInfo(mapCopy, map.getClass().getName());
        mapObjectInfo.setNonNativeObjects(nonNativeObjects);
        return mapObjectInfo;
    }

    private ClassInfo getClassInfo(String fullClassName) {
        return this.session.getClassInfo(fullClassName);
    }

    private ArrayObjectInfo introspectArray(Object array, Map<Object, NonNativeObjectInfo> alreadyReadObjects, ODBType valueType, IntrospectionCallback callback) {
        int length = OdbReflection.getArrayLength(array);
        Class<?> elementType = array.getClass().getComponentType();
        ODBType type = ODBType.getFromClass(elementType);
        if (type.isAtomicNative()) {
            return this.intropectAtomicNativeArray(array, type);
        }
        AbstractObjectInfo[] arrayCopy = new AbstractObjectInfo[length];
        ArrayList<NonNativeObjectInfo> nonNativeObjects = new ArrayList<NonNativeObjectInfo>(length);
        for (int i = 0; i < length; ++i) {
            Object o = OdbReflection.getArrayElement(array, i);
            Object ci = null;
            if (o != null) {
                AbstractObjectInfo aoi;
                arrayCopy[i] = aoi = this.getObjectInfoInternal(o, alreadyReadObjects, callback);
                if (!aoi.isNonNativeObject()) continue;
                nonNativeObjects.add((NonNativeObjectInfo)aoi);
                continue;
            }
            arrayCopy[i] = new NonNativeNullObjectInfo();
            nonNativeObjects.add((NonNativeObjectInfo)arrayCopy[i]);
        }
        ArrayObjectInfo arrayOfAoi = new ArrayObjectInfo(arrayCopy, valueType, type.getId());
        arrayOfAoi.setNonNativeObjects(nonNativeObjects);
        return arrayOfAoi;
    }

    private ArrayObjectInfo intropectAtomicNativeArray(Object array, ODBType type) {
        int length = OdbReflection.getArrayLength(array);
        AtomicNativeObjectInfo anoi = null;
        AbstractObjectInfo[] arrayCopy = new AbstractObjectInfo[length];
        int typeId = 0;
        for (int i = 0; i < length; ++i) {
            Object o = OdbReflection.getArrayElement(array, i);
            if (o != null) {
                typeId = ODBType.getFromClass(o.getClass()).getId();
                anoi = new AtomicNativeObjectInfo(o, typeId);
                arrayCopy[i] = anoi;
                continue;
            }
            arrayCopy[i] = new NullNativeObjectInfo(type.getId());
        }
        ArrayObjectInfo aoi = new ArrayObjectInfo(arrayCopy, ODBType.ARRAY, type.getId());
        return aoi;
    }

    @Override
    public void clear() {
    }

    @Override
    public ClassIntrospector getClassIntrospector() {
        return this.classIntrospector;
    }
}

