/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer1;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreeNodeOneValuePerKey;
import org.neodatis.btree.IKeyAndValue;
import org.neodatis.btree.impl.AbstractBTree;
import org.neodatis.btree.impl.AbstractBTreeNode;
import org.neodatis.btree.impl.KeyAndValue;
import org.neodatis.btree.impl.singlevalue.BTreeNodeSingleValuePerKey;
import org.neodatis.btree.impl.singlevalue.BTreeSingleValuePerKey;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.btree.ODBBTreeMultiple;
import org.neodatis.odb.core.btree.ODBBTreeNodeMultiple;
import org.neodatis.odb.core.btree.ODBBTreeNodeSingle;
import org.neodatis.odb.core.btree.ODBBTreeSingle;
import org.neodatis.odb.core.layers.layer1.ClassIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.ClassPool;
import org.neodatis.odb.core.layers.layer2.instance.FullInstantiationHelper;
import org.neodatis.odb.core.layers.layer2.instance.InstantiationHelper;
import org.neodatis.odb.core.layers.layer2.instance.ParameterHelper;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.oid.uuid.OIDImpl;
import org.neodatis.odb.core.query.SimpleCompareKey;
import org.neodatis.odb.core.session.Session;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.OdbClassUtil;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassIntrospectorImpl
implements ClassIntrospector {
    private static final String LOG_ID = "ClassIntrospector";
    private Map<String, IOdbList<Field>> fieldsByClassName = new OdbHashMap<String, IOdbList<Field>>();
    private Map<String, Field> fieldsByClassNameAndName = new OdbHashMap<String, Field>();
    private Map<String, Class> systemClasses = new OdbHashMap<String, Class>();
    private Map<String, FullInstantiationHelper> fullInstantiationHelpers = new OdbHashMap<String, FullInstantiationHelper>();
    private Map<String, InstantiationHelper> instantiationHelpers = new OdbHashMap<String, InstantiationHelper>();
    private Map<String, ParameterHelper> parameterHelpers = new OdbHashMap<String, ParameterHelper>();
    private ClassPool classPool;
    protected OidGenerator oidGenerator;
    protected Session session;

    public ClassIntrospectorImpl(Session session, OidGenerator oidGenerator) {
        this.session = session;
        this.oidGenerator = oidGenerator;
        this.classPool = session.getConfig().getCoreProvider().getClassPool();
    }

    protected OidGenerator getoidGenerator() {
        return this.oidGenerator;
    }

    @Override
    public void reset() {
        this.fieldsByClassName.clear();
        this.fieldsByClassNameAndName.clear();
        this.fullInstantiationHelpers.clear();
        this.instantiationHelpers.clear();
        this.parameterHelpers.clear();
    }

    @Override
    public void addInstanciationHelper(Class clazz, InstantiationHelper helper) {
        this.addInstantiationHelper(clazz.getName(), helper);
    }

    @Override
    public void addParameterHelper(Class clazz, ParameterHelper helper) {
        this.addParameterHelper(clazz.getName(), helper);
    }

    @Override
    public void addFullInstanciationHelper(Class clazz, FullInstantiationHelper helper) {
        this.addFullInstantiationHelper(clazz.getName(), helper);
    }

    @Override
    public void addInstantiationHelper(String clazz, InstantiationHelper helper) {
        this.instantiationHelpers.put(clazz, helper);
    }

    @Override
    public void addParameterHelper(String clazz, ParameterHelper helper) {
        this.parameterHelpers.put(clazz, helper);
    }

    @Override
    public void addFullInstantiationHelper(String clazz, FullInstantiationHelper helper) {
        this.fullInstantiationHelpers.put(clazz, helper);
    }

    @Override
    public void removeInstantiationHelper(Class clazz) {
        this.removeInstantiationHelper(clazz.getName());
    }

    @Override
    public void removeInstantiationHelper(String canonicalName) {
        this.instantiationHelpers.remove(canonicalName);
    }

    @Override
    public void removeParameterHelper(Class clazz) {
        this.removeParameterHelper(clazz.getName());
    }

    @Override
    public void removeParameterHelper(String canonicalName) {
        this.parameterHelpers.remove(canonicalName);
    }

    @Override
    public void removeFullInstantiationHelper(Class clazz) {
        this.removeFullInstantiationHelper(clazz.getName());
    }

    @Override
    public void removeFullInstantiationHelper(String canonicalName) {
        this.fullInstantiationHelpers.remove(canonicalName);
    }

    @Override
    public ClassInfoList introspect(Class clazz) {
        return this.internalIntrospect(clazz, null);
    }

    @Override
    public Map<String, ClassInfo> instrospect(IOdbList<ClassInfo> classInfos) {
        ClassInfo persistedCI2 = null;
        ClassInfo currentCI = null;
        OdbHashMap<String, ClassInfo> cis = new OdbHashMap<String, ClassInfo>();
        for (ClassInfo persistedCI2 : classInfos) {
            currentCI = this.getClassInfo(persistedCI2.getFullClassName(), persistedCI2);
            cis.put(currentCI.getFullClassName(), currentCI);
        }
        return cis;
    }

    private ClassInfoList internalIntrospect(Class clazz, ClassInfoList classInfoList) {
        boolean hasSuperClass;
        ClassInfo existingCi;
        if (classInfoList != null && (existingCi = classInfoList.getClassInfoWithName(clazz.getName())) != null) {
            return classInfoList;
        }
        if (classInfoList == null) {
            classInfoList = new ClassInfoList();
        }
        if ((existingCi = this.session.getMetaModel().getClassInfo(clazz.getName(), false)) != null) {
            classInfoList.addClassInfo(existingCi);
            return classInfoList;
        }
        Class superClass = clazz.getSuperclass();
        boolean bl = hasSuperClass = superClass != null && superClass != Object.class;
        if (hasSuperClass) {
            this.internalIntrospect(superClass, classInfoList);
        }
        ClassInfo classInfo = new ClassInfo(clazz.getName());
        if (hasSuperClass) {
            classInfo.setSuperClassOid(classInfoList.getClassInfoWithName(superClass.getName()).getOid());
        }
        classInfo.setOid(this.getoidGenerator().createClassOid());
        classInfo.setClassCategory(this.getClassCategory(clazz.getName()));
        if (classInfoList == null) {
            classInfoList = new ClassInfoList(classInfo);
        } else {
            classInfoList.addClassInfo(classInfo);
        }
        IOdbList<Field> fields = this.getAllFields(clazz.getName());
        OdbArrayList<ClassAttributeInfo> attributes = new OdbArrayList<ClassAttributeInfo>(fields.size());
        ClassInfo attributeCi = null;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!ODBType.getFromClass(field.getType()).isNative() || OdbClassUtil.isEnum(field.getType())) {
                classInfoList = this.internalIntrospect(field.getType(), classInfoList);
                attributeCi = classInfoList.getClassInfoWithName(field.getType().getName());
            } else {
                attributeCi = null;
            }
            ClassOid attributeClassInfoOid = null;
            if (attributeCi != null) {
                attributeClassInfoOid = attributeCi.getOid();
            }
            attributes.add(new ClassAttributeInfo(i + 1, field.getName(), field.getType(), field.getType().getName(), attributeClassInfoOid, classInfo.getOid()));
        }
        classInfo.setAttributes(attributes);
        classInfo.setMaxAttributeId(fields.size());
        return classInfoList;
    }

    @Override
    public ClassInfo getClassInfo(String fullClassName, ClassInfo existingClassInfo) {
        ClassInfo classInfo = new ClassInfo(fullClassName);
        classInfo.setClassCategory(this.getClassCategory(fullClassName));
        IOdbList<Field> fields = this.getAllFields(fullClassName);
        OdbArrayList<ClassAttributeInfo> attributes = new OdbArrayList<ClassAttributeInfo>(fields.size());
        int attributeId = -1;
        int maxAttributeId = existingClassInfo.getMaxAttributeId();
        Object ci = null;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            attributeId = existingClassInfo.getAttributeId(field.getName());
            if (attributeId == -1) {
                attributeId = ++maxAttributeId;
            }
            attributes.add(new ClassAttributeInfo(attributeId, field.getName(), field.getType(), field.getType().getName(), null, classInfo.getOid()));
        }
        classInfo.setAttributes(attributes);
        classInfo.setMaxAttributeId(maxAttributeId);
        return classInfo;
    }

    @Override
    public List<Class> getSuperClasses(String fullClassName, boolean includingThis) {
        ArrayList<Class> result = new ArrayList<Class>(10);
        Class clazz = this.classPool.getClass(fullClassName);
        if (clazz.isInterface()) {
            // empty if block
        }
        if (includingThis) {
            result.add(clazz);
        }
        for (Class superClass = clazz.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            result.add(superClass);
        }
        return result;
    }

    @Override
    public Field getField(Class clazz, String fieldName) {
        Field f = this.fieldsByClassNameAndName.get(clazz.getName() + "." + fieldName);
        if (f == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.REFLECTION_ERROR_WHILE_GETTING_FIELD.addParameter(fieldName).addParameter(clazz.getName()));
        }
        return f;
    }

    @Override
    public synchronized IOdbList<Field> getAllFields(String fullClassName) {
        IOdbList<Field> result = this.fieldsByClassName.get(fullClassName);
        if (result != null) {
            return result;
        }
        OdbHashMap<String, String> attributesNames = new OdbHashMap<String, String>();
        result = new OdbArrayList<Field>(50);
        Field[] superClassfields = null;
        List<Class> classes = this.getSuperClasses(fullClassName, true);
        for (int i = 0; i < classes.size(); ++i) {
            Class clazz1 = classes.get(i);
            superClassfields = clazz1.getDeclaredFields();
            for (int j = 0; j < superClassfields.length; ++j) {
                if (attributesNames.get(superClassfields[j].getName()) != null) continue;
                superClassfields[j].setAccessible(true);
                result.add(superClassfields[j]);
                attributesNames.put(superClassfields[j].getName(), superClassfields[j].getName());
            }
        }
        result = this.removeUnnecessaryFields(result);
        this.fieldsByClassName.put(fullClassName, result);
        for (Field f : result) {
            this.fieldsByClassNameAndName.put(fullClassName + "." + f.getName(), f);
        }
        attributesNames.clear();
        attributesNames = null;
        return result;
    }

    @Override
    public IOdbList<Field> removeUnnecessaryFields(IOdbList<Field> fields) {
        OdbArrayList<Field> fieldsToRemove = new OdbArrayList<Field>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                fieldsToRemove.add(field);
            }
            if (!field.getName().startsWith("this$")) continue;
            fieldsToRemove.add(field);
        }
        fields.removeAll(fieldsToRemove);
        return fields;
    }

    @Override
    public ClassInfoList introspect(String fullClassName) {
        return this.introspect(this.classPool.getClass(fullClassName));
    }

    @Override
    public Constructor getConstructorOf(String fullClassName) {
        Class clazz = this.classPool.getClass(fullClassName);
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            if (this.session.getConfig().isDebugEnabled(LOG_ID)) {
                DLogger.debug(clazz + " does not have default constructor! using a 'with identification' constructor will null values");
            }
            Constructor<?>[] constructors = clazz.getConstructors();
            int numberOfParameters = 1000;
            int bestConstructorIndex = 0;
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length >= numberOfParameters) continue;
                bestConstructorIndex = i;
            }
            Constructor<?> constructor = constructors[bestConstructorIndex];
            return constructor;
        }
    }

    @Override
    public Object newFullInstanceOf(Class clazz, NonNativeObjectInfo nnoi) {
        Object o;
        String className = clazz.getName();
        FullInstantiationHelper helper = this.fullInstantiationHelpers.get(className);
        if (helper != null && (o = helper.instantiate(nnoi)) != null) {
            return o;
        }
        return null;
    }

    @Override
    public Object newInstanceOf(Class clazz) {
        Object o;
        String className = clazz.getName();
        InstantiationHelper helper = this.instantiationHelpers.get(className);
        if (helper != null && (o = helper.instantiate()) != null) {
            return o;
        }
        try {
            Constructor constructor = null;
            constructor = this.classPool.getConstructor(className);
            if (constructor == null) {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.classPool.addConstructor(className, constructor);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return this.manageNoDefaultConstructor(clazz);
        }
    }

    private Object manageNoDefaultConstructor(Class clazz) {
        Object[] parameters;
        String className = clazz.getName();
        boolean ok = this.tryToCreateAnEmptyConstructor(clazz);
        if (ok) {
            Constructor createdConstructor = this.classPool.getConstructor(className);
            try {
                return createdConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.INSTANCIATION_ERROR.addParameter(className), (Throwable)e);
            }
        }
        if (this.session.getConfig().isDebugEnabled(LOG_ID)) {
            DLogger.debug(clazz + " does not have default constructor! using a 'with identification' constructor will null values");
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (clazz.isInterface()) {
            return null;
        }
        if (constructors.length == 0) {
            throw new NeoDatisRuntimeException(NeoDatisError.CLASS_WITHOUT_CONSTRUCTOR.addParameter(clazz.getName()));
        }
        int numberOfParameters = 1000;
        int bestConstructorIndex = 0;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length >= numberOfParameters) continue;
            bestConstructorIndex = i;
        }
        Constructor<?> constructor = constructors[bestConstructorIndex];
        ParameterHelper paramHelper = this.parameterHelpers.get(className);
        if (paramHelper != null) {
            parameters = paramHelper.parameters();
            if (parameters.length != constructor.getParameterTypes().length) {
                throw new NeoDatisRuntimeException(NeoDatisError.PARAM_HELPER_WRONG_NO_OF_PARAMS.addParameter(className).addParameter(constructor.toString()));
            }
        } else {
            parameters = new Object[constructor.getParameterTypes().length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = constructor.getParameterTypes()[i] == Integer.TYPE ? (Number)new Integer(0) : (Number)(constructor.getParameterTypes()[i] == Long.TYPE ? (Number)new Long(0L) : (Number)(constructor.getParameterTypes()[i] == Short.TYPE ? (Number)new Short("0") : (Number)(constructor.getParameterTypes()[i] == Byte.TYPE ? (Number)new Byte("0") : (Number)(constructor.getParameterTypes()[i] == Float.TYPE ? (Number)new Float("0") : (Number)(constructor.getParameterTypes()[i] == Double.TYPE ? new Double("0") : null)))));
            }
        }
        Object object = null;
        constructor.setAccessible(true);
        try {
            object = constructor.newInstance(parameters);
        }
        catch (Throwable e2) {
            throw new NeoDatisRuntimeException(NeoDatisError.NO_NULLABLE_CONSTRUCTOR.addParameter("[" + DisplayUtility.objectArrayToString(constructor.getParameterTypes()) + "]").addParameter(clazz.getName()), e2);
        }
        return object;
    }

    protected abstract boolean tryToCreateAnEmptyConstructor(Class var1);

    @Override
    public boolean isSystemClass(String fullClassName) {
        return this.systemClasses.containsKey(fullClassName);
    }

    @Override
    public byte getClassCategory(String fullClassName) {
        if (this.systemClasses.isEmpty()) {
            this.fillSystemClasses();
        }
        if (this.systemClasses.get(fullClassName) != null) {
            return 1;
        }
        return 2;
    }

    private void fillSystemClasses() {
        this.systemClasses.put(ClassInfoIndex.class.getName(), ClassInfoIndex.class);
        this.systemClasses.put(OID.class.getName(), OID.class);
        this.systemClasses.put(OIDImpl.class.getName(), OIDImpl.class);
        this.systemClasses.put(ODBBTreeNodeSingle.class.getName(), ODBBTreeNodeSingle.class);
        this.systemClasses.put(ODBBTreeNodeMultiple.class.getName(), ODBBTreeNodeMultiple.class);
        this.systemClasses.put(ODBBTreeMultiple.class.getName(), ODBBTreeMultiple.class);
        this.systemClasses.put(ODBBTreeSingle.class.getName(), ODBBTreeSingle.class);
        this.systemClasses.put(ODBBTreeNodeMultiple.class.getName(), ODBBTreeNodeMultiple.class);
        this.systemClasses.put(IBTree.class.getName(), IBTree.class);
        this.systemClasses.put(IBTreeNodeOneValuePerKey.class.getName(), IBTreeNodeOneValuePerKey.class);
        this.systemClasses.put(IKeyAndValue.class.getName(), IKeyAndValue.class);
        this.systemClasses.put(KeyAndValue.class.getName(), KeyAndValue.class);
        this.systemClasses.put(SimpleCompareKey.class.getName(), SimpleCompareKey.class);
        this.systemClasses.put(Comparable.class.getName(), Comparable.class);
        this.systemClasses.put(IBTreeNode.class.getName(), IBTreeNode.class);
        this.systemClasses.put(Object.class.getName(), Object.class);
        this.systemClasses.put(BTreeSingleValuePerKey.class.getName(), BTreeSingleValuePerKey.class);
        this.systemClasses.put(BTreeNodeSingleValuePerKey.class.getName(), BTreeNodeSingleValuePerKey.class);
        this.systemClasses.put(AbstractBTreeNode.class.getName(), AbstractBTreeNode.class);
        this.systemClasses.put(AbstractBTree.class.getName(), AbstractBTree.class);
    }

    protected void addConstructor(String className, Constructor constructor) {
        this.classPool.addConstructor(className, constructor);
    }

    @Override
    public ClassPool getClassPool() {
        return this.classPool;
    }
}

