/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.btree.nativ;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreePersister;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.fs.NDFS;
import org.neodatis.fs.NDFSFactory;
import org.neodatis.fs.NdfsConfig;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.btree.nativ.NativeBTree;
import org.neodatis.odb.core.btree.nativ.NativeNode;
import org.neodatis.odb.core.btree.nativ.Position;
import org.neodatis.odb.core.btree.nativ.SplitRafResult2;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.BytesHelper;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.odb.core.layers.layer3.ReadSize;

public class NativeBTreePersisterWithNeoDatisFS
implements IBTreePersister {
    protected String fileName;
    protected long maxFileSize;
    protected int btreeDegree;
    protected int nodeSize;
    protected DataConverter converter;
    protected IBTree btree;
    protected int HEADER_OFFSET = 40;
    protected Map<Long, IBTreeNode> nodes;
    protected Map<Long, IBTreeNode> modifiedNodes;
    protected boolean commit;
    protected boolean withCacheForRead;
    protected boolean withCacheForWrite;
    protected Map<Long, NdfsFile> files;
    protected NDFS ndfs;
    protected NdfsTransaction transaction;
    public static long tbuildbytes = 0L;
    public static long tgetfile = 0L;
    public static long twrite = 0L;
    protected boolean debug;
    protected String characterEncoding;
    protected NeoDatisConfig config;

    public NativeBTreePersisterWithNeoDatisFS(String fileName, long maxFileSize, int degree, boolean debug, String characterEncoding, NeoDatisConfig config) {
        this.config = config;
        System.out.println("SplitPersisterWithNeoDatisFS");
        this.nodes = new HashMap<Long, IBTreeNode>();
        this.modifiedNodes = new TreeMap<Long, IBTreeNode>();
        this.fileName = fileName;
        this.maxFileSize = maxFileSize;
        this.btreeDegree = degree;
        this.converter = new DataConverterImpl(debug, characterEncoding, config);
        this.computeNodeSize();
        this.initNdfs();
        this.debug = debug;
        this.characterEncoding = characterEncoding;
        this.withCacheForRead = true;
        this.withCacheForWrite = true;
    }

    private void initNdfs() {
        try {
            NdfsConfig config = NDFSFactory.getConfig(this.fileName, 4096);
            this.ndfs = NDFSFactory.open(config);
            this.transaction = this.ndfs.startTransaction();
            this.files = new HashMap<Long, NdfsFile>();
            String fileNameWithId = this.fileName + "0";
            NdfsFile file = this.transaction.getFile(null, fileNameWithId);
            this.files.put(new Long(0L), file);
        }
        catch (Exception e) {
            throw new BTreeException("Error while initializing RAFs", e);
        }
    }

    protected SplitRafResult2 getFileForPosition(long position) {
        long id = position / this.maxFileSize;
        long adjustedPosition = position - id * this.maxFileSize;
        try {
            Long lid = new Long(id);
            NdfsFile file = this.files.get(lid);
            if (file == null) {
                String fileId = this.fileName + id;
                file = this.transaction.getFile(null, fileId);
                this.files.put(lid, file);
                System.out.println("Creating file " + fileId);
            }
            return new SplitRafResult2(adjustedPosition, file);
        }
        catch (Exception e) {
            throw new BTreeException("Error while getting raf for id " + id, e);
        }
    }

    private void computeNodeSize() {
        int size = 2 * this.btreeDegree - 1;
        this.nodeSize = 20 + size * 8 + size * 20 + (size + 1) * 8;
    }

    public void clear() {
    }

    public void close() throws Exception {
        this.commit = true;
        long t0 = System.currentTimeMillis();
        this.saveBTree(this.btree, true);
        long t1 = System.currentTimeMillis();
        System.out.println("BTree saved " + (t1 - t0) + "ms");
        this.saveModifiedNodes();
        long t2 = System.currentTimeMillis();
        System.out.println("Modified Nodes saved " + (t2 - t1) + "ms");
        this.transaction.commit();
        long t3 = System.currentTimeMillis();
        System.out.println("Transaction committed " + (t3 - t2) + "ms");
        this.ndfs.close();
        long t4 = System.currentTimeMillis();
        System.out.println("NDFS closed " + (t4 - t3) + "ms");
    }

    private void saveModifiedNodes() throws IOException {
        for (IBTreeNode node : this.modifiedNodes.values()) {
            this.saveNode(node);
        }
    }

    private void saveModifiedNodes2() throws IOException {
        Iterator<IBTreeNode> mnodes = this.modifiedNodes.values().iterator();
        System.out.println("Saving " + this.modifiedNodes.size() + " nodes");
        boolean i = false;
        long id1 = 0L;
        long id2 = 0L;
        int nbConcat = -1;
        Bytes mainBytes = null;
        long initPosition = this.HEADER_OFFSET;
        boolean firstTime = true;
        while (mnodes.hasNext()) {
            boolean canConcat;
            IBTreeNode node = mnodes.next();
            Bytes bytes = this.buildBytesForNode(node);
            id2 = (Long)node.getId();
            boolean bl = canConcat = id1 != 0L && id1 == id2 - 1L;
            if (!firstTime && canConcat && initPosition != -1L) {
                ++nbConcat;
                mainBytes.append(bytes);
            } else {
                initPosition = (long)this.HEADER_OFFSET + (id2 - 1L) * (long)this.nodeSize;
                mainBytes = bytes;
                nbConcat = 0;
            }
            if (!firstTime && !canConcat || nbConcat > 40) {
                SplitRafResult2 result = this.getFileForPosition(initPosition);
                NdfsFile file = result.file;
                mainBytes.setOffset(result.adjustedPosition);
                file.write(mainBytes);
                id1 = -1L;
                mainBytes = null;
                initPosition = -1L;
            }
            firstTime = false;
            id1 = id2;
        }
    }

    public Object deleteNode(IBTreeNode node) {
        System.out.println("Deleting node with id " + node.getId());
        return null;
    }

    public void flush() {
    }

    public IBTree loadBTree(Object id) {
        if (this.btree != null) {
            return this.btree;
        }
        Long nid = (Long)id;
        Bytes bytes = null;
        boolean arraySize = false;
        try {
            NdfsFile file = this.getFileForPosition((long)0L).file;
            bytes = file.read(0L, this.HEADER_OFFSET);
        }
        catch (Exception e) {
            throw new BTreeException("Error while loading btree with id " + id.toString(), e);
        }
        BytesHelper helper = new BytesHelper(bytes, this.debug, this.characterEncoding, this.config);
        ReadSize readSize = new ReadSize();
        long nid2 = helper.readLong(readSize.get(), readSize, "btree id");
        int degree = helper.readInt(readSize.get(), readSize, "btree degree");
        long size = helper.readLong(readSize.get(), readSize, "btree size");
        int height = helper.readInt(readSize.get(), readSize, "btree height");
        long rootId = helper.readLong(readSize.get(), readSize, "btree root id");
        long nextNodeId = helper.readLong(readSize.get(), readSize, "btree next node id");
        NativeBTree nbtree = new NativeBTree(new Long(nid2), degree, this, new Long(nextNodeId));
        nbtree.setSize(size);
        nbtree.setHeight(2);
        this.modifiedNodes.remove(nbtree.getRoot().getId());
        IBTreeNode root = this.loadNodeById(rootId);
        nbtree.setRoot(root);
        return nbtree;
    }

    public OID saveBTree(IBTree tree) {
        return null;
    }

    public OID saveBTree(IBTree tree, boolean force) {
        if (tree.getId() == null) {
            return null;
        }
        NativeBTree nbtree = (NativeBTree)tree;
        Bytes bytes = BytesFactory.getBytes();
        int objectSize = this.converter.longToByteArray((long)((Long)tree.getId()), bytes, 0, "btree id");
        objectSize += this.converter.intToByteArray(tree.getDegree(), bytes, objectSize, "btree degree");
        objectSize += this.converter.longToByteArray(tree.getSize(), bytes, objectSize, "btree size");
        objectSize += this.converter.intToByteArray(tree.getHeight(), bytes, objectSize, "btree height");
        objectSize += this.converter.longToByteArray((long)((Long)tree.getRoot().getId()), bytes, objectSize, "btree root id");
        objectSize += this.converter.longToByteArray((long)nbtree.getNextNodeId(), bytes, objectSize, "btree next node id");
        SplitRafResult2 result = this.getFileForPosition(0L);
        NdfsFile file = result.file;
        bytes.setOffset(result.adjustedPosition);
        file.write(bytes);
        return null;
    }

    public IBTreeNode loadNodeById(Object id) {
        if (this.withCacheForRead) {
            IBTreeNode nodeFromCache = this.nodes.get(id);
            if (nodeFromCache != null) {
                return nodeFromCache;
            }
            nodeFromCache = this.modifiedNodes.get((Comparable)id);
            if (nodeFromCache != null) {
                return nodeFromCache;
            }
        }
        Long nid = (Long)id;
        Bytes bytes = null;
        SplitRafResult2 result = null;
        try {
            long position = (long)this.HEADER_OFFSET + (nid - 1L) * (long)this.nodeSize;
            result = this.getFileForPosition(position);
            NdfsFile file = result.file;
            bytes = file.read(result.adjustedPosition, this.nodeSize);
        }
        catch (Exception e) {
            throw new BTreeException("Error while loading node with id " + id, e);
        }
        ReadSize readSize = new ReadSize();
        int d = (int)(result.adjustedPosition - bytes.getOffset());
        long nodeId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "id");
        long parentId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "parent id");
        int size = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "size");
        Long[] keys = new Long[size];
        int nbKeys = 0;
        for (int i = 0; i < size; ++i) {
            keys[i] = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "key");
            if (keys[i] == -1L) continue;
            ++nbKeys;
        }
        Position[] positions = new Position[size];
        for (int i = 0; i < size; ++i) {
            Position p;
            long fileId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "file id");
            long blockId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "block id");
            int offset = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "offset");
            positions[i] = p = new Position(fileId, blockId, offset);
        }
        Long[] childrens = new Long[size + 1];
        int nbChildren = 0;
        for (int i = 0; i < size + 1; ++i) {
            childrens[i] = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "child");
            if (childrens[i] == -1L) continue;
            ++nbChildren;
        }
        NativeNode node = new NativeNode(this.btree, nid, parentId, size, keys, positions, childrens, nbKeys, nbChildren);
        if (this.withCacheForRead) {
            this.nodes.put(nid, node);
        }
        return node;
    }

    public Object saveNode(IBTreeNode node) {
        int i;
        if (!this.commit && this.withCacheForWrite) {
            this.modifiedNodes.put((Long)node.getId(), node);
            return null;
        }
        long t0 = System.currentTimeMillis();
        Bytes bytes = BytesFactory.getBytes();
        long id = (Long)node.getId();
        long parentId = node.getParentId() == null ? -1L : (Long)node.getParentId();
        int size = 2 * this.btreeDegree - 1;
        int objectSize = 0;
        objectSize += this.converter.longToByteArray(id, bytes, objectSize, "id");
        objectSize += this.converter.longToByteArray(parentId, bytes, objectSize, "parent id");
        objectSize += this.converter.intToByteArray(size, bytes, objectSize, "size");
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                objectSize += this.converter.longToByteArray((long)((Long)node.getKeyAt(i)), bytes, objectSize, "key");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
        }
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                Position p = (Position)node.getValueAsObjectAt(i);
                objectSize += this.converter.longToByteArray(p.fileId, bytes, objectSize, "file id");
                objectSize += this.converter.longToByteArray(p.blockId, bytes, objectSize, "block id");
                objectSize += this.converter.intToByteArray(p.offset, bytes, objectSize, "ofsset");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.intToByteArray(-1, bytes, objectSize, "key");
        }
        for (i = 0; i < size + 1; ++i) {
            if (i < node.getNbChildren()) {
                Long childId = (Long)node.getChildIdAt(i, false);
                if (childId == null) {
                    System.out.println("null");
                }
                objectSize += this.converter.longToByteArray((long)childId, bytes, objectSize, "childId");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "childId");
        }
        long position = (long)this.HEADER_OFFSET + (id - 1L) * (long)this.nodeSize;
        long t1 = System.currentTimeMillis();
        SplitRafResult2 result = this.getFileForPosition(position);
        NdfsFile file = result.file;
        bytes.setOffset(result.adjustedPosition);
        long t2 = System.currentTimeMillis();
        file.write(bytes);
        long t3 = System.currentTimeMillis();
        twrite += t3 - t2;
        tbuildbytes += t1 - t0;
        tgetfile += t2 - t1;
        if (this.withCacheForRead && !this.commit) {
            this.nodes.put(id, node);
        }
        return node.getId();
    }

    public Bytes buildBytesForNode(IBTreeNode node) {
        int i;
        Bytes bytes = BytesFactory.getBytes();
        long id = (Long)node.getId();
        long parentId = node.getParentId() == null ? -1L : (Long)node.getParentId();
        int size = 2 * this.btreeDegree - 1;
        int objectSize = 0;
        objectSize += this.converter.longToByteArray(id, bytes, objectSize, "id");
        objectSize += this.converter.longToByteArray(parentId, bytes, objectSize, "parent id");
        objectSize += this.converter.intToByteArray(size, bytes, objectSize, "size");
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                objectSize += this.converter.longToByteArray((long)((Long)node.getKeyAt(i)), bytes, objectSize, "key");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
        }
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                Position p = (Position)node.getValueAsObjectAt(i);
                objectSize += this.converter.longToByteArray(p.fileId, bytes, objectSize, "file id");
                objectSize += this.converter.longToByteArray(p.blockId, bytes, objectSize, "block id");
                objectSize += this.converter.intToByteArray(p.offset, bytes, objectSize, "ofsset");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.intToByteArray(-1, bytes, objectSize, "key");
        }
        for (i = 0; i < size + 1; ++i) {
            if (i < node.getNbChildren()) {
                Long childId = (Long)node.getChildIdAt(i, false);
                if (childId == null) {
                    System.out.println("null");
                }
                objectSize += this.converter.longToByteArray((long)childId, bytes, objectSize, "childId");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "childId");
        }
        return bytes;
    }

    public void setBTree(IBTree tree) {
        this.btree = tree;
    }
}

