/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neodatis.odb.Release;
import org.neodatis.odb.core.IError;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbThread;

public class NeoDatisRuntimeException
extends RuntimeException {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy-HH-mm-ss");
    private static final String url = "https://sourceforge.net/tracker/?func=add&group_id=179124&atid=887885";
    private static final String message1 = "";

    public NeoDatisRuntimeException(String error) {
        super(String.format("%s\nVersion=%s , Build=%s, Date=%s, Thread=%s\nNeoDatisError:%s\nStackTrace:", message1, Release.RELEASE_NUMBER, Release.RELEASE_BUILD, Release.RELEASE_DATE, OdbThread.getCurrentThreadName(), error));
    }

    public NeoDatisRuntimeException(IError error, Throwable t) {
        super(String.format("%s\nVersion=%s , Build=%s, Date=%s, Thread=%s\nNeoDatisError:%s\nStackTrace:", message1, Release.RELEASE_NUMBER, Release.RELEASE_BUILD, Release.RELEASE_DATE, OdbThread.getCurrentThreadName(), error.toString()), t);
    }

    public NeoDatisRuntimeException(IError error) {
        super(String.format("%s\nVersion=%s , Build=%s, Date=%s, Thread=%s\nNeoDatisError:%s\nStackTrace:", message1, Release.RELEASE_NUMBER, Release.RELEASE_BUILD, Release.RELEASE_DATE, OdbThread.getCurrentThreadName(), error.toString()));
    }

    public NeoDatisRuntimeException(IError error, String message) {
        super(String.format("%s\nVersion=%s , Build=%s, Date=%s, Thread=%s\nNeoDatisError:%s\nMessage:\n%s", message1, Release.RELEASE_NUMBER, Release.RELEASE_BUILD, Release.RELEASE_DATE, OdbThread.getCurrentThreadName(), error.toString(), message));
    }

    public void addMessageHeader(String string) {
    }

    public NeoDatisRuntimeException(Exception e, String message) {
        super(String.format("%s\nVersion=%s , Build=%s, Date=%s, Thread=%s\nMessage:%s\nStackTrace:", message1, Release.RELEASE_NUMBER, Release.RELEASE_BUILD, Release.RELEASE_DATE, OdbThread.getCurrentThreadName(), message), e);
    }

    public NeoDatisRuntimeException(Exception e) {
        super(String.format("%s\nVersion=%s , Build=%s, Date=%s, Thread=%s\nStackTrace:", message1, Release.RELEASE_NUMBER, Release.RELEASE_BUILD, Release.RELEASE_DATE, OdbThread.getCurrentThreadName()), e);
    }

    public void internalWriteToFile(String directory) {
        try {
            String fileName = directory + "/neodatis-error-" + dateFormat.format(new Date()) + "-" + System.nanoTime() + ".txt";
            FileOutputStream out = new FileOutputStream(fileName);
            out.write(OdbString.exceptionToString(this, true).getBytes());
            out.close();
            DLogger.error("Exception detail has been written to " + new File(fileName).getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToFile() {
        this.internalWriteToFile(".");
    }

    public void writeToFile(String directory) {
        this.internalWriteToFile(directory);
    }
}

