/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.neodatis.fs.NdfsException;
import org.neodatis.fs.NdfsFile;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.tool.DLogger;

public class SyncBlockWriter {
    protected RandomAccessFile raf;
    protected NdfsFile file;

    public SyncBlockWriter(NdfsFile file) {
        this.file = file;
        try {
            File f = new File(file.getFullName());
            if (!f.exists()) {
                f.getParentFile().mkdirs();
            }
            this.raf = new RandomAccessFile(file.getFullName(), "rw");
        }
        catch (FileNotFoundException e) {
            throw new NdfsException(e);
        }
    }

    public void writeTo(Bytes b) {
        try {
            byte[] bytes = b.getByteArray();
            long offset = b.getOffset();
            this.raf.seek(offset);
            this.raf.write(bytes);
            if (this.file.getNdfs().getConfig().debug()) {
                DLogger.debug(String.format("\t\tSyncBlockWriter:Writing %d bytes at %d in file %s : %s", bytes.length, offset, this.file.getName(), b.toString()));
            }
        }
        catch (Exception e) {
            throw new NdfsException(e);
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

