/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.neodatis.fs.NdfsException;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.tool.DLogger;

public class AsyncBlockWriter {
    protected NdfsFile transactionFile;
    protected RandomAccessFile raf;
    protected DataConverter converter;
    protected NdfsTransaction ndfsTransaction;

    public AsyncBlockWriter(NdfsTransaction ndfsTransaction) {
        this.transactionFile = ndfsTransaction.getTransactionFile();
        try {
            File f = new File(this.transactionFile.getFullName());
            if (!f.exists()) {
                f.getParentFile().mkdirs();
            }
            this.raf = new RandomAccessFile(this.transactionFile.getFullName(), "rw");
        }
        catch (FileNotFoundException e) {
            throw new NdfsException(e);
        }
        this.converter = new DataConverterImpl(ndfsTransaction.getNdfs().getConfig().debug(), ndfsTransaction.getNdfs().getConfig().getCharacterEncoding(), NeoDatis.getConfig());
        this.ndfsTransaction = ndfsTransaction;
    }

    public void writeTo(NdfsFile mainFile, Bytes bytes) {
        if (this.transactionFile.getNdfs().getConfig().debug()) {
            DLogger.debug(String.format("asyncBlockWriter: Writing %d bytes to transactionFile %s at position %d", bytes.getRealSize(), this.transactionFile.getName(), bytes.getOffset()));
        }
        this.queue(mainFile, bytes);
    }

    private void queue(NdfsFile mainFile, Bytes bytes) {
        int bytesSize = bytes.getRealSize();
        int fileIdSize = 8;
        int positionSize = 8;
        int nbBlockSize = 4;
        int offset = fileIdSize + nbBlockSize + positionSize;
        byte[] newbytes = new byte[bytesSize + offset];
        Bytes headerBytes = BytesFactory.getBytes();
        this.converter.longToByteArray(mainFile.getId(), headerBytes, 0, "file id");
        this.converter.longToByteArray(bytes.getOffset(), headerBytes, 8, "position");
        this.converter.intToByteArray(bytesSize, headerBytes, 16, "bytes size");
        headerBytes.extract(newbytes, 0, 0, 20);
        bytes.extract(newbytes, offset, 0, bytesSize);
        try {
            this.raf.seek(this.raf.length());
            this.raf.write(newbytes);
        }
        catch (Exception e) {
            throw new NdfsException(e);
        }
        this.ndfsTransaction.getTma().add(mainFile, bytes);
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

