/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.impl;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreePersister;
import org.neodatis.btree.IKeyAndValue;
import org.neodatis.btree.exception.BTreeNodeValidationException;
import org.neodatis.btree.impl.KeyAndValue;
import org.neodatis.btree.tool.BTreeValidator;

public abstract class AbstractBTree
implements IBTree {
    private String name;
    private int degree;
    private long size;
    private int height;
    private IBTreeNode root;
    protected transient IBTreePersister persister;
    protected int controlNumber;

    public abstract IBTreeNode buildNode();

    public AbstractBTree() {
        this.degree = 0;
        this.size = 0L;
        this.height = 1;
        this.persister = null;
        this.root = null;
    }

    public AbstractBTree(String name, int degree, IBTreePersister persister) {
        this.name = name;
        this.degree = degree;
        this.size = 0L;
        this.height = 1;
        this.persister = persister;
        this.root = this.buildNode();
        persister.saveNode(this.root);
        persister.saveBTree(this);
        persister.flush();
    }

    public Object delete(Comparable key, Object value) {
        Object o = null;
        try {
            o = this.internalDelete(this.root, new KeyAndValue(key, value));
        }
        catch (Exception e) {
            throw new BTreeNodeValidationException("Error while deleting key='" + key + "' value='" + value + "'", e);
        }
        if (o != null) {
            --this.size;
        }
        this.getPersister().saveBTree(this);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalDelete(IBTreeNode node, IKeyAndValue keyAndValue) throws Exception {
        Object currentValue;
        Comparable currentKey;
        IBTreeNode rightNode;
        IBTreeNode leftNode;
        int realPosition;
        block15: {
            block14: {
                int position;
                block12: {
                    IBTreeNode child;
                    block13: {
                        boolean keyIsHere;
                        block10: {
                            block11: {
                                position = node.getPositionOfKey(keyAndValue.getKey());
                                keyIsHere = position > 0;
                                realPosition = -1;
                                leftNode = null;
                                rightNode = null;
                                if (!node.isLeaf()) break block10;
                                if (!keyIsHere) break block11;
                                Object deletedValue = node.deleteKeyForLeafNode(keyAndValue);
                                this.getPersister().saveNode(node);
                                Object object = deletedValue;
                                return object;
                            }
                            Object deletedValue = null;
                            return deletedValue;
                        }
                        if (keyIsHere) break block12;
                        realPosition = -position - 1;
                        child = node.getChildAt(realPosition, true);
                        if (child.getNbKeys() != this.degree - 1) break block13;
                        node = this.prepareForDelete(node, child, realPosition);
                        Object object = this.internalDelete(node, keyAndValue);
                        return object;
                    }
                    Object object = this.internalDelete(child, keyAndValue);
                    return object;
                }
                realPosition = position - 1;
                currentKey = node.getKeyAt(realPosition);
                currentValue = node.getValueAsObjectAt(realPosition);
                leftNode = node.getChildAt(realPosition, true);
                if (leftNode.getNbKeys() < this.degree) break block14;
                IKeyAndValue prev = this.getBiggest(leftNode, true);
                node.setKeyAndValueAt(prev, realPosition);
                BTreeValidator.validateNode(node, node == this.root);
                this.getPersister().saveNode(node);
                Object object = currentValue;
                return object;
            }
            rightNode = node.getChildAt(realPosition + 1, true);
            if (rightNode.getNbKeys() < this.degree) break block15;
            IKeyAndValue next = this.getSmallest(rightNode, true);
            node.setKeyAndValueAt(next, realPosition);
            BTreeValidator.validateNode(node, node == this.root);
            this.getPersister().saveNode(node);
            Object object = currentValue;
            return object;
        }
        node.deleteKeyAndValueAt(realPosition, true);
        leftNode.insertKeyAndValue(currentKey, currentValue);
        leftNode.mergeWith(rightNode);
        if (!node.hasParent() && node.getNbKeys() == 0) {
            this.persister.deleteNode(node);
            this.root = leftNode;
            leftNode.setParent(null);
            --this.height;
        } else {
            node.setChildAt(leftNode, realPosition);
            BTreeValidator.validateNode(node, node == this.root);
        }
        this.persister.deleteNode(rightNode);
        BTreeValidator.validateNode(leftNode, leftNode == this.root);
        this.getPersister().saveNode(node);
        this.getPersister().saveNode(leftNode);
        Object object = this.internalDelete(leftNode, keyAndValue);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBTreeNode prepareForDelete(IBTreeNode parent, IBTreeNode child, int childIndex) {
        block25: {
            block26: {
                boolean parentWasSetToNull;
                IBTreeNode rightSibling;
                block23: {
                    block24: {
                        IBTreeNode leftSibling;
                        block22: {
                            block21: {
                                BTreeValidator.validateNode(parent);
                                BTreeValidator.validateNode(child);
                                leftSibling = null;
                                rightSibling = null;
                                if (childIndex > 0 && parent.getNbChildren() > 0) {
                                    leftSibling = parent.getChildAt(childIndex - 1, false);
                                }
                                if (childIndex < parent.getNbChildren() - 1) {
                                    rightSibling = parent.getChildAt(childIndex + 1, false);
                                }
                                if (leftSibling == null || leftSibling.getNbKeys() < this.degree) break block21;
                                IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex - 1);
                                IKeyAndValue elementToMoveUp = leftSibling.getLastKeyAndValue();
                                parent.setKeyAndValueAt(elementToMoveUp, childIndex - 1);
                                child.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
                                if (leftSibling.getNbChildren() > leftSibling.getNbKeys()) {
                                    child.setChildAt(leftSibling, leftSibling.getNbChildren() - 1, 0, true);
                                    child.incrementNbChildren();
                                }
                                leftSibling.deleteKeyAndValueAt(leftSibling.getNbKeys() - 1, false);
                                if (!leftSibling.isLeaf()) {
                                    leftSibling.deleteChildAt(leftSibling.getNbChildren() - 1);
                                }
                                this.persister.saveNode(parent);
                                this.persister.saveNode(child);
                                this.persister.saveNode(leftSibling);
                                if (!BTreeValidator.isOn()) return parent;
                                BTreeValidator.validateNode(parent, parent == this.root);
                                BTreeValidator.validateNode(child, false);
                                BTreeValidator.validateNode(leftSibling, false);
                                BTreeValidator.checkDuplicateChildren(leftSibling, child);
                                return parent;
                            }
                            if (rightSibling == null || rightSibling.getNbKeys() < this.degree) break block22;
                            IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex);
                            IKeyAndValue elementToMoveUp = rightSibling.getKeyAndValueAt(0);
                            parent.setKeyAndValueAt(elementToMoveUp, childIndex);
                            child.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
                            if (rightSibling.getNbChildren() > 0) {
                                child.setChildAt(rightSibling, 0, child.getNbChildren(), true);
                                child.incrementNbChildren();
                            }
                            rightSibling.deleteKeyAndValueAt(0, true);
                            this.persister.saveNode(parent);
                            this.persister.saveNode(child);
                            this.persister.saveNode(rightSibling);
                            if (!BTreeValidator.isOn()) return parent;
                            BTreeValidator.validateNode(parent, parent == this.root);
                            BTreeValidator.validateNode(child, false);
                            BTreeValidator.validateNode(rightSibling, false);
                            BTreeValidator.checkDuplicateChildren(rightSibling, child);
                            return parent;
                        }
                        boolean isCase3b = leftSibling != null && leftSibling.getNbKeys() == this.degree - 1 || rightSibling != null && rightSibling.getNbKeys() >= this.degree - 1;
                        parentWasSetToNull = false;
                        if (!isCase3b) throw new BTreeNodeValidationException("Unexpected case in executing prepare for delete");
                        if (leftSibling == null) break block23;
                        IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex - 1);
                        leftSibling.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
                        leftSibling.mergeWith(child);
                        parent.deleteKeyAndValueAt(childIndex - 1, true);
                        if (parent.getNbKeys() == 0) {
                            if (parent.hasParent()) throw new BTreeNodeValidationException("Unexpected empty node that is node the root!");
                            this.root = leftSibling;
                            this.root.setParent(null);
                            --this.height;
                            parentWasSetToNull = true;
                        } else {
                            parent.setChildAt(leftSibling, childIndex - 1);
                        }
                        if (parentWasSetToNull) {
                            this.persister.deleteNode(parent);
                        } else {
                            this.persister.saveNode(parent);
                            BTreeValidator.validateNode(parent, parent == this.root);
                        }
                        this.persister.deleteNode(child);
                        this.persister.saveNode(leftSibling);
                        BTreeValidator.validateNode(leftSibling, leftSibling == this.root);
                        if (!parentWasSetToNull) break block24;
                        return this.root;
                    }
                    return parent;
                }
                if (rightSibling == null) break block25;
                IKeyAndValue elementToMoveDown = parent.getKeyAndValueAt(childIndex);
                child.insertKeyAndValue(elementToMoveDown.getKey(), elementToMoveDown.getValue());
                child.mergeWith(rightSibling);
                parent.deleteKeyAndValueAt(childIndex, true);
                if (parent.getNbKeys() == 0) {
                    if (parent.hasParent()) throw new BTreeNodeValidationException("Unexpected empty root node!");
                    this.root = child;
                    this.root.setParent(null);
                    --this.height;
                    parentWasSetToNull = true;
                } else {
                    parent.setChildAt(child, childIndex);
                }
                if (parentWasSetToNull) {
                    this.persister.deleteNode(parent);
                } else {
                    this.persister.saveNode(parent);
                    BTreeValidator.validateNode(parent, parent == this.root);
                }
                this.persister.deleteNode(rightSibling);
                this.persister.saveNode(child);
                BTreeValidator.validateNode(child, child == this.root);
                if (!parentWasSetToNull) break block26;
                return this.root;
            }
            return parent;
        }
        throw new BTreeNodeValidationException("deleting case 3b but no non null sibling!");
    }

    public int getDegree() {
        return this.degree;
    }

    public void insert(Comparable key, Object value) {
        boolean increaseSize;
        if (this.root.isFull()) {
            this.newRoot();
        }
        if (increaseSize = this.insertNonFull(this.root, key, value)) {
            ++this.size;
        }
        this.persister.saveBTree(this);
    }

    protected void newRoot() {
        IBTreeNode newRoot = this.buildNode();
        IBTreeNode oldRoot = this.root;
        newRoot.setChildAt(this.root, 0);
        newRoot.setNbChildren(1);
        this.root = newRoot;
        this.split(newRoot, oldRoot, 0);
        ++this.height;
        this.persister.saveNode(oldRoot);
        this.persister.saveNode(newRoot);
        this.persister.saveBTree(this);
        BTreeValidator.validateNode(newRoot, true);
    }

    protected boolean insertNonFull(IBTreeNode node, Comparable key, Object value) {
        if (node.isLeaf()) {
            boolean increaseSize = node.insertKeyAndValue(key, value);
            this.persister.saveNode(node);
            return increaseSize;
        }
        int position = node.getPositionOfKey(key);
        int realPosition = -position - 1;
        if (position >= 0) {
            realPosition = position - 1;
            boolean increaseSize = node.insertKeyAndValue(key, value);
            this.persister.saveNode(node);
            return increaseSize;
        }
        IBTreeNode nodeToDescend = node.getChildAt(realPosition, true);
        if (nodeToDescend.isFull()) {
            this.split(node, nodeToDescend, realPosition);
            if (node.getKeyAt(realPosition).compareTo(key) < 0) {
                nodeToDescend = node.getChildAt(realPosition + 1, true);
            }
        }
        return this.insertNonFull(nodeToDescend, key, value);
    }

    public void split(IBTreeNode parent, IBTreeNode node2Split, int childIndex) {
        IKeyAndValue median = node2Split.getMedian();
        parent.setKeyAndValueAt(median, childIndex, true, true);
        IBTreeNode rightPart = node2Split.extractRightPart();
        parent.setChildAt(rightPart, childIndex + 1);
        parent.setChildAt(node2Split, childIndex);
        parent.incrementNbChildren();
        this.persister.saveNode(parent);
        this.persister.saveNode(rightPart);
        this.persister.saveNode(node2Split);
        if (BTreeValidator.isOn()) {
            BTreeValidator.validateNode(parent, parent == this.root);
            BTreeValidator.validateNode(rightPart, false);
            BTreeValidator.validateNode(node2Split, false);
        }
    }

    public long getSize() {
        return this.size;
    }

    public IBTreeNode getRoot() {
        return this.root;
    }

    public int getHeight() {
        return this.height;
    }

    public IBTreePersister getPersister() {
        return this.persister;
    }

    public void setPersister(IBTreePersister persister) {
        this.persister = persister;
        this.persister.setBTree(this);
        if (this.root.getBTree() == null) {
            this.root.setBTree(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.root.clear();
    }

    public IKeyAndValue getBiggest(IBTreeNode node, boolean delete) {
        int lastKeyIndex = node.getNbKeys() - 1;
        int lastChildIndex = node.getNbChildren() - 1;
        if (lastChildIndex > lastKeyIndex) {
            IBTreeNode child = node.getChildAt(lastChildIndex, true);
            if (child.getNbKeys() == this.degree - 1) {
                node = this.prepareForDelete(node, child, lastChildIndex);
            }
            lastChildIndex = node.getNbChildren() - 1;
            child = node.getChildAt(lastChildIndex, true);
            return this.getBiggest(child, delete);
        }
        IKeyAndValue kav = node.getKeyAndValueAt(lastKeyIndex);
        if (delete) {
            node.deleteKeyAndValueAt(lastKeyIndex, false);
            this.persister.saveNode(node);
        }
        return kav;
    }

    public IKeyAndValue getSmallest(IBTreeNode node, boolean delete) {
        if (!node.isLeaf()) {
            IBTreeNode child = node.getChildAt(0, true);
            if (child.getNbKeys() == this.degree - 1) {
                node = this.prepareForDelete(node, child, 0);
            }
            child = node.getChildAt(0, true);
            return this.getSmallest(child, delete);
        }
        IKeyAndValue kav = node.getKeyAndValueAt(0);
        if (delete) {
            node.deleteKeyAndValueAt(0, true);
            this.persister.saveNode(node);
        }
        return kav;
    }

    protected void setSize(long size2) {
        this.size = size2;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    public void setRoot(IBTreeNode root2) {
        this.root = root2;
    }
}

