/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper.compression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jdbm.extser.Stateless;
import jdbm.helper.compression.ByteArrayCompressor;
import jdbm.helper.compression.ByteArrayDecompressor;
import jdbm.helper.compression.CompressionProvider;

public class DefaultCompressionProvider
implements CompressionProvider,
Stateless {
    private static final long serialVersionUID = 1L;

    public ByteArrayCompressor getCompressor(DataOutput out) {
        Compressor comp = new Compressor();
        comp.out = out;
        return comp;
    }

    public ByteArrayDecompressor getDecompressor(DataInput in) {
        Decompressor decomp = new Decompressor();
        decomp.in = in;
        return decomp;
    }

    static byte[] readByteArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] buf = new byte[len];
        in.readFully(buf);
        return buf;
    }

    static void writeByteArray(DataOutput out, byte[] buf) throws IOException {
        if (buf == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(buf.length);
            out.write(buf);
        }
    }

    private static class Decompressor
    implements ByteArrayDecompressor {
        private DataInput in;

        private Decompressor() {
        }

        public void reset(DataInput in) {
            this.in = in;
        }

        public byte[] decompressNextGroup() throws IOException {
            return DefaultCompressionProvider.readByteArray(this.in);
        }
    }

    private static class Compressor
    implements ByteArrayCompressor {
        private DataOutput out;

        private Compressor() {
        }

        public void compressNextGroup(byte[] in) throws IOException {
            DefaultCompressionProvider.writeByteArray(this.out, in);
        }

        public void finishCompression() {
        }
    }
}

