/*
 * Decompiled with CFR 0.152.
 */
package jdbm.extser;

import java.util.Map;
import java.util.WeakHashMap;
import jdbm.extser.IExtensibleSerializer;
import jdbm.extser.Stateless;

public abstract class AbstractSingleton
implements Stateless {
    private static final transient Map _cache = new WeakHashMap();

    public IExtensibleSerializer getSerializer(Object obj) throws IllegalStateException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        IExtensibleSerializer ser = (IExtensibleSerializer)_cache.get(obj);
        if (ser == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return ser;
    }

    public void setSerializer(Object accessObject, IExtensibleSerializer ser) throws IllegalStateException {
        if (accessObject == null || ser == null) {
            throw new IllegalArgumentException();
        }
        if (_cache.get(accessObject) != null) {
            throw new IllegalStateException("Already initialized.");
        }
        _cache.put(accessObject, ser);
    }
}

