/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.xml;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ODB;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer4.engine.Dummy;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.xml.tool.XMLGenerator;
import org.neodatis.odb.xml.tool.XMLNode;
import org.neodatis.tool.ILogger;

public class XMLExporter {
    private SessionEngine engine;
    private ILogger externalLogger;
    private XMLGenerator xmlGenerator;

    public XMLExporter(SessionEngine storageEngine) {
        this.engine = storageEngine;
    }

    public XMLExporter(ODB odb) {
        this.engine = Dummy.getEngine(odb);
    }

    public void export(String directory, String filename) throws Exception {
        if (!this.engine.getSession().isLocal()) {
            throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("Export in Client Server mode"));
        }
        String baseName = this.engine.getSession().getBaseIdentification().getBaseId();
        String completeFileName = directory + "/" + filename;
        this.xmlGenerator = new XMLGenerator(this.engine.getSession().getConfig().getDatabaseCharacterEncoding());
        this.xmlGenerator.setIncrementalWriteOn(completeFileName);
        this.info("Exporting NeoDatis database " + baseName + " to " + new File(completeFileName).getAbsolutePath());
        XMLNode root = this.xmlGenerator.createRoot("odb");
        root.addAttribute("name", this.format(baseName));
        root.addAttribute("export-date-time", this.format(new Date()));
        root.addAttribute("file-format-version", this.engine.getFileFormatVersion());
        root.endHeader();
        this.buildMetaModelXml(root);
        this.buildObjectsXml(root);
        root.end();
        this.xmlGenerator.close();
        this.info("End of Export");
    }

    private void buildObjectsXml(XMLNode root) throws Exception {
        XMLNode objectsXml = root.createNode("objects");
        objectsXml.endHeader();
        MetaModel metaModel = this.engine.getSession().getMetaModel();
        this.info("Exporting Objects of " + metaModel.getNumberOfUserClasses() + " classes");
        for (ClassInfo ci : metaModel.getUserClasses()) {
            this.buildObjectsOfClassXml(objectsXml, ci);
        }
        objectsXml.end();
        this.info("Exporting Objects done.");
    }

    private void buildObjectsOfClassXml(XMLNode objectsXml, ClassInfo ci) throws Exception {
        this.info(". Exporting Objects of " + ci.getFullClassName() + " - coid=" + ci.getOid());
        CriteriaQueryImpl q = new CriteriaQueryImpl(ci.getFullClassName());
        q.getQueryParameters().setInMemory(false);
        Objects objects = this.engine.getMetaObjects(q);
        int i = 0;
        while (objects.hasNext()) {
            Object o = objects.next();
            AbstractObjectInfo aoi = (AbstractObjectInfo)o;
            this.buildOneObjectXml(objectsXml, ci, (NonNativeObjectInfo)aoi);
            if (++i % 10000 != 0) continue;
            this.info(". " + i + " objects");
        }
        this.info(". Done : " + i + " objects exported");
        objects.clear();
        objects = null;
        this.engine.getSession().clearCache();
    }

    private void buildOneObjectXml(XMLNode node, ClassInfo ci, NonNativeObjectInfo nnoi) throws UnsupportedEncodingException {
        XMLNode objectXml = node.createNode("object");
        objectXml.addAttribute("oid", String.valueOf(nnoi.getOid()));
        objectXml.addAttribute("class-id", String.valueOf(ci.getOid()));
        objectXml.endHeader();
        int attributeId = -1;
        AbstractObjectInfo aoi = null;
        int maxId = ci.getMaxAttributeId();
        for (int id = 1; id <= maxId; ++id) {
            XMLNode attributeXml = objectXml.createNode("attribute");
            ClassAttributeInfo cai = ci.getAttributeInfoFromId(id);
            if (cai == null) continue;
            attributeId = cai.getId();
            aoi = nnoi.getAttributeValueFromId(attributeId);
            attributeXml.addAttribute("id", String.valueOf(id));
            attributeXml.addAttribute("name", cai.getName());
            if (aoi.isNative()) {
                if (aoi.isNull()) {
                    attributeXml.addAttribute("is-null", "true");
                } else if (cai.getAttributeType().isCollection()) {
                    CollectionObjectInfo coi = (CollectionObjectInfo)aoi;
                    attributeXml.addAttribute("type", "collection");
                    attributeXml.endHeader();
                    this.buildListXml(attributeXml, coi);
                } else if (cai.getAttributeType().isMap()) {
                    MapObjectInfo moi = (MapObjectInfo)aoi;
                    attributeXml.addAttribute("type", "map");
                    attributeXml.endHeader();
                    this.buildMapXml(attributeXml, moi);
                } else if (cai.getAttributeType().isArray()) {
                    ArrayObjectInfo aroi = (ArrayObjectInfo)aoi;
                    attributeXml.addAttribute("type", "array");
                    attributeXml.endHeader();
                    this.buildArrayXml(attributeXml, aroi);
                } else if (nnoi.getAttributeValueFromId(id) != null) {
                    attributeXml.addAttribute("value", this.format(aoi));
                } else {
                    attributeXml.addAttribute("is-null", "true");
                }
            } else if (nnoi.getAttributeValueFromId(id) instanceof NonNativeNullObjectInfo) {
                attributeXml.addAttribute("is-null", "true");
            } else if (nnoi.getAttributeValueFromId(id).isDeletedObject()) {
                attributeXml.addAttribute("is-deleted", "true");
            } else {
                attributeXml.addAttribute("ref-oid", String.valueOf(((NonNativeObjectInfo)aoi).getOid()));
            }
            attributeXml.end();
        }
        objectXml.end();
    }

    private String format(Object object) throws UnsupportedEncodingException {
        if (object instanceof Date) {
            Date date = (Date)object;
            return String.valueOf(date.getTime());
        }
        if (object instanceof AtomicNativeObjectInfo) {
            AtomicNativeObjectInfo an = (AtomicNativeObjectInfo)object;
            if (an.getObject() instanceof Date) {
                Date date = (Date)an.getObject();
                return String.valueOf(date.getTime());
            }
            if (an.getObject() instanceof String) {
                String s = (String)an.getObject();
                String encoding = this.engine.getSession().getConfig().getDatabaseCharacterEncoding();
                if (encoding == null) {
                    return URLEncoder.encode(s);
                }
                return URLEncoder.encode(s, encoding);
            }
        }
        return URLEncoder.encode(object.toString());
    }

    private void buildListXml(XMLNode node, CollectionObjectInfo coi) {
        if (coi.isNull()) {
            node.createNode("null-collection").end();
        }
        XMLNode element = null;
        XMLNode listXml = node.createNode("collection");
        listXml.addAttribute("native-class-name", coi.getRealCollectionClassName());
        listXml.addAttribute("size", "" + coi.getCollection().size());
        listXml.endHeader();
        for (AbstractObjectInfo aoi : coi.getCollection()) {
            element = listXml.createNode("element");
            if (aoi.isNative()) {
                NativeObjectInfo noi = (NativeObjectInfo)aoi;
                element.addAttribute("value", String.valueOf(noi.getObject()));
                element.addAttribute("type", ODBType.getNameFromId(aoi.getOdbTypeId()));
            } else {
                NonNativeObjectInfo nnoi = (NonNativeObjectInfo)aoi;
                element.addAttribute("ref-oid", String.valueOf(nnoi.getOid()));
            }
            element.end();
        }
        listXml.end();
    }

    private void buildArrayXml(XMLNode node, ArrayObjectInfo aoi) {
        if (aoi.isNull()) {
            node.createNode("null-array").end();
        }
        XMLNode element = null;
        XMLNode listXml = node.createNode("array");
        listXml.addAttribute("array-of", aoi.getRealArrayComponentClassName());
        listXml.addAttribute("size", "" + aoi.getArrayLength());
        listXml.endHeader();
        for (int i = 0; i < aoi.getArrayLength(); ++i) {
            AbstractObjectInfo aboi = aoi.getArray()[i];
            element = listXml.createNode("element");
            if (aboi.isNative()) {
                if (aboi.isNull()) {
                    element.addAttribute("is-null", "true");
                } else {
                    NativeObjectInfo noi = (NativeObjectInfo)aboi;
                    element.addAttribute("value", String.valueOf(noi.getObject()));
                }
            } else if (aboi.isNull()) {
                element.addAttribute("is-null", "true");
            } else {
                NonNativeObjectInfo nnoi = (NonNativeObjectInfo)aboi;
                element.addAttribute("ref-oid", String.valueOf(nnoi.getOid()));
            }
            element.end();
        }
        listXml.end();
    }

    private void buildMapXml(XMLNode node, MapObjectInfo moi) {
        if (moi.isNull()) {
            node.createNode("null-map").end();
        }
        XMLNode element = null;
        XMLNode listXml = node.createNode("map");
        listXml.addAttribute("native-class-name", moi.getRealMapClassName());
        listXml.addAttribute("size", "" + moi.getMap().size());
        listXml.endHeader();
        Iterator<AbstractObjectInfo> iterator = moi.getMap().keySet().iterator();
        while (iterator.hasNext()) {
            NonNativeObjectInfo nnoi;
            NativeObjectInfo noi;
            AbstractObjectInfo o;
            AbstractObjectInfo aoi = o = iterator.next();
            element = listXml.createNode("element");
            if (aoi.isNative()) {
                noi = (NativeObjectInfo)aoi;
                element.addAttribute("key", String.valueOf(noi.getObject()));
                element.addAttribute("key-type", ODBType.getNameFromId(aoi.getOdbTypeId()));
            } else {
                nnoi = (NonNativeObjectInfo)aoi;
                element.addAttribute("key-id", String.valueOf(nnoi.getOid()));
            }
            aoi = moi.getMap().get(aoi);
            if (aoi.isNative()) {
                noi = (NativeObjectInfo)aoi;
                element.addAttribute("value", String.valueOf(noi.getObject()));
                element.addAttribute("value-type", ODBType.getNameFromId(aoi.getOdbTypeId()));
            } else {
                nnoi = (NonNativeObjectInfo)aoi;
                element.addAttribute("ref-oid", String.valueOf(nnoi.getOid()));
            }
            element.end();
        }
        listXml.end();
    }

    private void buildMetaModelXml(XMLNode root) throws Exception {
        XMLNode metaModelXml = root.createNode("meta-model");
        metaModelXml.endHeader();
        MetaModel metaModel = this.engine.getSession().getMetaModel();
        this.info("Exporting MetaModel : " + metaModel.getNumberOfClasses() + " classes");
        for (ClassInfo ci : metaModel.getAllClasses()) {
            this.buildClassInfoXml(metaModelXml, ci);
        }
        this.info("Exporting MetaModel done");
    }

    private void buildClassInfoXml(XMLNode node, ClassInfo ci) {
        XMLNode classXml = node.createNode("class");
        classXml.addAttribute("id", String.valueOf(ci.getOid()));
        classXml.addAttribute("name", ci.getFullClassName());
        classXml.endHeader();
        this.info(". Class " + ci.getFullClassName() + " - coid=" + ci.getOid());
        for (int i = 0; i < ci.getAttributes().size(); ++i) {
            ClassAttributeInfo cai = ci.getAttributeInfo(i);
            this.buildClassAttributeXml(classXml, cai, i + 1);
        }
        classXml.end();
    }

    private void buildClassAttributeXml(XMLNode node, ClassAttributeInfo cai, int index) {
        XMLNode classAttributeXml = node.createNode("attribute");
        classAttributeXml.addAttribute("id", String.valueOf(cai.getId()));
        classAttributeXml.addAttribute("name", cai.getName());
        if (cai.isNonNative()) {
            classAttributeXml.addAttribute("class-id", cai.getAttributeClassOid().oidToString());
        } else {
            classAttributeXml.addAttribute("type", cai.getClassName());
        }
        if (cai.getAttributeType().isArray()) {
            classAttributeXml.addAttribute("array-of", cai.getAttributeType().getSubType().getName());
        }
        if (cai.getAttributeType().isEnum()) {
            classAttributeXml.addAttribute("is-enum", "true");
        }
        classAttributeXml.end();
    }

    public void setExternalLogger(ILogger logger) {
        this.externalLogger = logger;
    }

    protected void info(Object o) {
        if (this.externalLogger != null) {
            this.externalLogger.info(o);
        }
    }
}

