/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.main;

import java.math.BigInteger;
import java.util.Collection;
import org.neodatis.odb.ClassRepresentation;
import org.neodatis.odb.DatabaseStartupManager;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisEventType;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBExt;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Query;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.event.NeoDatisEventListener;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.ValuesQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.query.criteria.Criterion;
import org.neodatis.odb.core.query.nq.NativeQuery;
import org.neodatis.odb.core.query.values.ValuesCriteriaQuery;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.OIDTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.main.DefaultClassRepresentation;
import org.neodatis.odb.main.ODBExtImpl;
import org.neodatis.tool.DLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODBAdapter
implements ODB {
    protected SessionEngine sessionEngine;
    protected Session session;
    private ODBExt ext;

    public ODBAdapter(Session session) {
        this.session = session;
        this.sessionEngine = session.getEngine();
        DatabaseStartupManager manager = session.getConfig().getDatabaseStartupManager();
        if (manager != null) {
            manager.start(this);
        }
    }

    @Override
    public void commit() {
        this.session.commit();
    }

    @Override
    public void rollback() {
        this.session.rollback();
    }

    public void commitAndClose() {
        this.session.close();
    }

    @Override
    public ObjectOid store(Object object) {
        return this.sessionEngine.store(object);
    }

    @Override
    public <T> Objects<T> getObjects(Class clazz) {
        return this.sessionEngine.execute(new CriteriaQueryImpl(clazz));
    }

    public <T> Objects<T> getObjects(Class clazz, boolean inMemory) {
        CriteriaQueryImpl q = new CriteriaQueryImpl(clazz);
        q.getQueryParameters().setInMemory(inMemory);
        return this.sessionEngine.execute(q);
    }

    public <T> Objects<T> getObjects(Class clazz, boolean inMemory, int startIndex, int endIndex) {
        CriteriaQueryImpl q = new CriteriaQueryImpl(clazz);
        q.getQueryParameters().setInMemory(inMemory).setStartIndex(startIndex).setEndIndex(endIndex);
        return this.sessionEngine.execute(q);
    }

    @Override
    public void close() {
        this.commitAndClose();
    }

    @Override
    public ObjectOid delete(Object object) {
        return this.sessionEngine.delete(object, false);
    }

    @Override
    public void deleteAll(Collection objects) {
        for (Object o : objects) {
            this.sessionEngine.delete(o, false);
        }
    }

    @Override
    public void deleteObjectWithId(ObjectOid oid) {
        this.sessionEngine.deleteObjectWithOid(oid, false);
    }

    @Override
    public <T> Objects<T> getObjects(Query query) {
        InternalQuery iq = (InternalQuery)query;
        iq.setSessionEngine(this.sessionEngine);
        return this.sessionEngine.execute(iq);
    }

    public Values getValues(ValuesQuery query) {
        return this.sessionEngine.getValues(query);
    }

    @Override
    public BigInteger count(CriteriaQuery query) {
        return this.sessionEngine.count(query);
    }

    @Override
    public <T> Objects<T> getObjects(Query query, boolean inMemory) {
        query.getQueryParameters().setInMemory(inMemory);
        return this.sessionEngine.execute((InternalQuery)query);
    }

    @Override
    public <T> Objects<T> getObjects(Query query, boolean inMemory, int startIndex, int endIndex) {
        query.getQueryParameters().setInMemory(inMemory).setStartIndex(startIndex).setEndIndex(endIndex);
        return this.sessionEngine.execute((InternalQuery)query);
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public ObjectOid getObjectId(Object object) {
        return this.sessionEngine.getObjectOid(object, true);
    }

    @Override
    public Object getObjectFromId(ObjectOid oid) {
        return this.sessionEngine.getObjectFromOid(oid, true, new InstanceBuilderContext());
    }

    @Override
    public void defragmentTo(String newFileName) {
        this.sessionEngine.defragmentTo(newFileName);
    }

    @Override
    public ClassRepresentation getClassRepresentation(Class clazz) {
        return this.getClassRepresentation(clazz.getName());
    }

    @Override
    public ClassRepresentation getClassRepresentation(String fullClassName) {
        ClassInfo classInfo = this.session.getClassInfo(fullClassName);
        return new DefaultClassRepresentation(this.sessionEngine, classInfo);
    }

    public void run() {
        if (!this.session.isClosed()) {
            DLogger.debug("ODBFactory has not been closed and VM is exiting : force ODBFactory close");
            this.session.close();
        }
    }

    @Override
    public void addUpdateTrigger(Class clazz, UpdateTrigger trigger) {
        String className = "__all_class_";
        if (clazz != null) {
            className = clazz.getName();
        }
        this.sessionEngine.addUpdateTriggerFor(className, trigger);
    }

    @Override
    public void addOidTrigger(Class clazz, OIDTrigger trigger) {
        String className = "__all_class_";
        if (clazz != null) {
            className = clazz.getName();
        }
        this.sessionEngine.addOidTriggerFor(className, trigger);
    }

    @Override
    public void addInsertTrigger(Class clazz, InsertTrigger trigger) {
        String className = "__all_class_";
        if (clazz != null) {
            className = clazz.getName();
        }
        this.sessionEngine.addInsertTriggerFor(className, trigger);
    }

    @Override
    public void addDeleteTrigger(Class clazz, DeleteTrigger trigger) {
        String className = "__all_class_";
        if (clazz != null) {
            className = clazz.getName();
        }
        this.sessionEngine.addDeleteTriggerFor(className, trigger);
    }

    @Override
    public void addSelectTrigger(Class clazz, SelectTrigger trigger) {
        String className = "__all_class_";
        if (clazz != null) {
            className = clazz.getName();
        }
        this.sessionEngine.addSelectTriggerFor(className, trigger);
    }

    @Override
    public ODBExt ext() {
        if (this.isClosed()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.getName()));
        }
        if (this.ext == null) {
            this.ext = new ODBExtImpl(this.sessionEngine);
        }
        return this.ext;
    }

    @Override
    public void disconnect(Object object) {
        this.sessionEngine.disconnect(object);
    }

    @Override
    public void reconnect(Object object) {
        this.sessionEngine.reconnect(object);
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public String getName() {
        return this.session.getBaseIdentification().getBaseId();
    }

    @Override
    public void registerEventListenerFor(NeoDatisEventType neoDatisEventType, NeoDatisEventListener eventListener) {
        this.session.registerEventListenerFor(neoDatisEventType, eventListener);
    }

    @Override
    public void refresh(Object o, int depth) {
        this.sessionEngine.refresh(o, depth);
    }

    @Override
    public Query query(Class clazz, Criterion criterion) {
        return this.sessionEngine.criteriaQuery(clazz, criterion);
    }

    @Override
    public Query query(String className, Criterion criterion) {
        return this.sessionEngine.criteriaQuery(className, criterion);
    }

    @Override
    public Query query(String className) {
        return this.sessionEngine.criteriaQuery(className);
    }

    @Override
    public Query query(Class clazz) {
        return this.sessionEngine.criteriaQuery(clazz);
    }

    @Override
    public Query query(NativeQuery q) {
        q.setSessionEngine(this.sessionEngine);
        return q;
    }

    @Override
    public Query query(Query q) {
        InternalQuery iq = (InternalQuery)q;
        iq.setSessionEngine(this.sessionEngine);
        return q;
    }

    @Override
    public ValuesQuery queryValues(Class clazz, Criterion criterion) {
        return this.sessionEngine.queryValues(clazz, criterion);
    }

    @Override
    public ValuesQuery queryValues(String className, Criterion criterion) {
        return this.sessionEngine.queryValues(className, criterion);
    }

    @Override
    public ValuesQuery queryValues(String className) {
        return this.sessionEngine.queryValues(className);
    }

    @Override
    public ValuesQuery queryValues(Class clazz) {
        return this.sessionEngine.queryValues(clazz);
    }

    @Override
    public ValuesCriteriaQuery queryValues(Class clazz, ObjectOid oid) {
        return this.sessionEngine.queryValues(clazz, oid);
    }

    @Override
    public NeoDatisConfig getConfig() {
        return this.session.getConfig();
    }
}

