/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.ODB;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.component.GUITool;
import org.neodatis.odb.xml.XMLImporter;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbTime;

public class XmlImportPanel
extends JPanel
implements ActionListener,
Runnable {
    private JButton btImport;
    private JButton btCancel;
    private JTextField tfXmlFile;
    private JButton btBrowseXml;
    private JTextField tfOdbFile;
    private JButton btBrowseOdb;
    private JTextField tfUser;
    private JTextField tfPassword;
    private ILogger logger;
    private LoggerPanel loggerPanel;

    public XmlImportPanel(ILogger logger) {
        this.logger = logger;
        this.init();
    }

    private void init() {
        JLabel label1 = new JLabel(Messages.getString("Xml File name to import from"));
        JLabel label2 = new JLabel(Messages.getString("ODB file to import to"));
        this.tfXmlFile = new JTextField(20);
        this.tfOdbFile = new JTextField(20);
        this.btBrowseXml = new JButton(Messages.getString("..."));
        this.btBrowseOdb = new JButton(Messages.getString("..."));
        this.btImport = new JButton(Messages.getString("Import File"));
        this.btCancel = new JButton(Messages.getString("Cancel"));
        this.btBrowseOdb.setActionCommand("browse-odb");
        this.btBrowseXml.setActionCommand("browse-xml");
        this.btImport.setActionCommand("import");
        this.btCancel.setActionCommand("cancel");
        this.btBrowseOdb.addActionListener(this);
        this.btBrowseXml.addActionListener(this);
        this.btImport.addActionListener(this);
        this.btCancel.addActionListener(this);
        JPanel left = new JPanel(new GridLayout(3, 1, 2, 2));
        JPanel center = new JPanel(new GridLayout(3, 1, 2, 2));
        left.add(label1);
        JPanel panel1 = new JPanel();
        panel1.add(this.tfXmlFile);
        panel1.add(this.btBrowseXml);
        left.add(label2);
        left.add(new JLabel());
        JPanel panel2 = new JPanel();
        panel2.add(this.tfOdbFile);
        panel2.add(this.btBrowseOdb);
        JPanel panel3 = new JPanel();
        JLabel lbUser = new JLabel("User");
        JLabel lbPassword = new JLabel("Password");
        this.tfUser = new JTextField(5);
        this.tfPassword = new JPasswordField(5);
        this.loggerPanel = new LoggerPanel();
        panel3.add(lbUser);
        panel3.add(this.tfUser);
        panel3.add(lbPassword);
        panel3.add(this.tfPassword);
        center.add(panel1);
        center.add(panel2);
        center.add(panel3);
        JPanel wpanel = new JPanel(new BorderLayout(2, 2));
        wpanel.add((Component)left, "West");
        wpanel.add((Component)center, "Center");
        wpanel.add((Component)new JScrollPane(this.loggerPanel), "South");
        wpanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel bpanel = new JPanel();
        bpanel.add(this.btCancel);
        bpanel.add(this.btImport);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)wpanel, "Center");
        this.add((Component)bpanel, "South");
        this.add((Component)GUITool.buildHeaderPanel("XML Import Wizard"), "North");
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if ("browse-xml".equals(action)) {
            this.browse("xml");
        }
        if ("browse-odb".equals(action)) {
            this.browse("odb");
        }
        if ("cancel".equals(action)) {
            this.cancel();
        }
        if ("import".equals(action)) {
            try {
                Thread t = new Thread(this);
                t.start();
            }
            catch (Exception e1) {
                this.logger.error("Error while importing XML file : ", e1);
            }
        }
    }

    private void importFromXml() throws Exception {
        File xmlFile = new File(this.tfXmlFile.getText());
        File odbFile = new File(this.tfOdbFile.getText());
        if (!xmlFile.exists()) {
            JOptionPane.showMessageDialog(this, Messages.getString("The file " + xmlFile.getPath() + " does not exist!"));
            return;
        }
        if (odbFile.exists()) {
            JOptionPane.showMessageDialog(this, Messages.getString("The database file " + odbFile.getPath() + " already exist!"));
            return;
        }
        long start = OdbTime.getCurrentTimeInMs();
        this.setCursor(Cursor.getPredefinedCursor(3));
        String user = this.tfUser.getText();
        String password = this.tfPassword.getText();
        if (user.length() == 0 && password.length() == 0) {
            user = null;
            password = null;
        }
        ODB odb = NeoDatis.open(odbFile.getPath(), user, password);
        XMLImporter importer = new XMLImporter(odb);
        importer.setExternalLogger(this.loggerPanel);
        importer.importFile(xmlFile.getParent(), xmlFile.getName());
        odb.close();
        this.disableFields();
        this.setCursor(Cursor.getPredefinedCursor(0));
        long end = OdbTime.getCurrentTimeInMs();
        this.loggerPanel.info("Import successfull (" + (end - start) + "ms)");
    }

    private void cancel() {
        this.disableFields();
    }

    private void disableFields() {
        this.tfOdbFile.setEnabled(false);
        this.tfXmlFile.setEnabled(false);
        this.btImport.setEnabled(false);
        this.btCancel.setEnabled(false);
        this.btBrowseOdb.setEnabled(false);
        this.btBrowseXml.setEnabled(false);
    }

    private void browse(String type) {
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        String title = null;
        title = type.equals("xml") ? Messages.getString("Choose the name of the xml file to import from") : Messages.getString("Choose the name of the ODB file to export to");
        fc.setDialogTitle(title);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            if (type.equals("xml")) {
                this.tfXmlFile.setText(fc.getSelectedFile().getPath());
            } else {
                this.tfOdbFile.setText(fc.getSelectedFile().getPath());
            }
        }
    }

    public void run() {
        try {
            this.importFromXml();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
            this.loggerPanel.error(e);
        }
    }
}

