/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.hierarchy;

import java.text.ParseException;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeIdentification;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.gui.objectbrowser.hierarchy.Wrapper;
import org.neodatis.odb.tool.ObjectTool;

public class NativeAttributeValueWrapper
implements Wrapper {
    private String name;
    private Object value;
    private AttributeIdentification attributeIdentification;
    private NonNativeObjectInfo parent;
    private ObjectTool objectTool;

    public NativeAttributeValueWrapper(NonNativeObjectInfo nnoi, String name, Object value, AttributeIdentification attributeIdentification, Session session) {
        this.parent = nnoi;
        this.name = name;
        this.value = value;
        this.attributeIdentification = attributeIdentification;
        this.objectTool = new ObjectTool(session);
    }

    public String toString() {
        try {
            if (this.value == null || this.value instanceof NullNativeObjectInfo || this.value instanceof NonNativeNullObjectInfo) {
                this.value = "null";
            }
            if (this.value instanceof String) {
                return String.valueOf(this.value);
            }
            if (this.value instanceof AtomicNativeObjectInfo) {
                AtomicNativeObjectInfo anoi = (AtomicNativeObjectInfo)this.value;
                return this.name + " = " + this.objectTool.atomicNativeObjectToString(anoi, ObjectTool.ID_CALLER_IS_ODB_EXPLORER);
            }
            if (this.value instanceof EnumNativeObjectInfo) {
                EnumNativeObjectInfo enoi = (EnumNativeObjectInfo)this.value;
                return this.name + " = " + enoi.getObject().toString() + " (enum)";
            }
            return String.format("%s: Unable to retrieve the value (%s, type=%s)", this.name, this.value.toString(), this.value.getClass().getName());
        }
        catch (Throwable e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Error while reading field " + this.name + ":" + e.getMessage());
            return buffer.toString();
        }
    }

    public String objectToString() {
        if (this.value == null || this.value instanceof NullNativeObjectInfo) {
            this.value = "null";
        }
        AtomicNativeObjectInfo anoi = (AtomicNativeObjectInfo)this.value;
        return this.objectTool.atomicNativeObjectToString(anoi, ObjectTool.ID_CALLER_IS_ODB_EXPLORER);
    }

    public AttributeIdentification getAttributeIdentification() {
        return this.attributeIdentification;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setNewValue(String newValue) throws NumberFormatException, ParseException {
        AtomicNativeObjectInfo anoi = (AtomicNativeObjectInfo)this.value;
        int odbTypeId = anoi.getOdbTypeId();
        Object o = this.objectTool.stringToObject(odbTypeId, newValue, ObjectTool.ID_CALLER_IS_ODB_EXPLORER);
        anoi.setObject(o);
    }

    public AbstractObjectInfo getObject() {
        return (AbstractObjectInfo)this.value;
    }

    public NonNativeObjectInfo getParent() {
        return this.parent;
    }
}

